/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.flightsql;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.core.AdbcStatement;
import org.apache.arrow.adbc.core.AdbcStatusCode;
import org.apache.arrow.adbc.core.BulkIngestMode;
import org.apache.arrow.adbc.core.PartitionDescriptor;
import org.apache.arrow.adbc.driver.flightsql.FlightInfoReader;
import org.apache.arrow.adbc.driver.flightsql.FlightSqlClientWithCallOptions;
import org.apache.arrow.adbc.driver.flightsql.FlightSqlDriverUtil;
import org.apache.arrow.adbc.sql.SqlQuirks;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.flight.sql.FlightSqlClient;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FlightSqlStatement
implements AdbcStatement {
    private final BufferAllocator allocator;
    private final FlightSqlClientWithCallOptions client;
    private final LoadingCache<Location, FlightSqlClientWithCallOptions> clientCache;
    private final SqlQuirks quirks;
    private @Nullable String sqlQuery;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable FlightSqlClient.PreparedStatement preparedStatement;
    private @Nullable BulkState bulkOperation;
    private @Nullable VectorSchemaRoot bindRoot;

    FlightSqlStatement(BufferAllocator allocator, FlightSqlClientWithCallOptions client, LoadingCache<Location, FlightSqlClientWithCallOptions> clientCache, SqlQuirks quirks) {
        this.allocator = allocator;
        this.client = client;
        this.clientCache = clientCache;
        this.quirks = quirks;
        this.sqlQuery = null;
        this.preparedStatement = null;
        this.bulkOperation = null;
        this.bindRoot = null;
    }

    static FlightSqlStatement ingestRoot(BufferAllocator allocator, FlightSqlClientWithCallOptions client, LoadingCache<Location, FlightSqlClientWithCallOptions> clientCache, SqlQuirks quirks, String targetTableName, BulkIngestMode mode) {
        Objects.requireNonNull(targetTableName);
        FlightSqlStatement statement = new FlightSqlStatement(allocator, client, clientCache, quirks);
        statement.bulkOperation = new BulkState(mode, targetTableName);
        return statement;
    }

    public void setSqlQuery(String query) throws AdbcException {
        if (this.bulkOperation != null) {
            throw AdbcException.invalidState((String)"[Flight SQL] Statement is configured for a bulk ingest/append operation");
        }
        this.sqlQuery = query;
    }

    public void bind(VectorSchemaRoot root) {
        this.bindRoot = root;
    }

    private void createBulkTable(BulkState bulkOperation, VectorSchemaRoot bindRoot) throws AdbcException {
        StringBuilder create = new StringBuilder("CREATE TABLE ");
        create.append(bulkOperation.targetTable);
        create.append(" (");
        for (int col = 0; col < bindRoot.getFieldVectors().size(); ++col) {
            if (col > 0) {
                create.append(", ");
            }
            Field field = bindRoot.getVector(col).getField();
            create.append(field.getName());
            create.append(' ');
            String typeName = (String)this.quirks.getArrowToSqlTypeNameMapping().apply(field.getType());
            if (typeName == null) {
                throw AdbcException.notImplemented((String)("[Flight SQL] Cannot generate CREATE TABLE statement for field " + field));
            }
            create.append(typeName);
        }
        create.append(")");
        try {
            this.client.executeUpdate(create.toString(), new CallOption[0]);
        }
        catch (FlightRuntimeException e) {
            throw new AdbcException("[Flight SQL] Could not create table for bulk ingestion: " + bulkOperation.targetTable, (Throwable)e, AdbcStatusCode.ALREADY_EXISTS, null, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdbcStatement.UpdateResult executeBulk(BulkState bulkOperation) throws AdbcException {
        FlightSqlClient.PreparedStatement statement;
        if (this.bindRoot == null) {
            throw AdbcException.invalidState((String)"[Flight SQL] Must call bind() before bulk insert");
        }
        VectorSchemaRoot bindParams = this.bindRoot;
        if (bulkOperation.mode == BulkIngestMode.CREATE) {
            this.createBulkTable(bulkOperation, bindParams);
        }
        StringBuilder insert = new StringBuilder("INSERT INTO ");
        insert.append(bulkOperation.targetTable);
        insert.append(" VALUES (");
        for (int col = 0; col < bindParams.getFieldVectors().size(); ++col) {
            if (col > 0) {
                insert.append(", ");
            }
            insert.append("?");
        }
        insert.append(")");
        try {
            statement = this.client.prepare(insert.toString(), new CallOption[0]);
        }
        catch (FlightRuntimeException e) {
            throw new AdbcException("[Flight SQL] Could not prepare statement for bulk ingestion into " + bulkOperation.targetTable, (Throwable)e, AdbcStatusCode.NOT_FOUND, null, 0);
        }
        try {
            try {
                statement.setParameters((VectorSchemaRoot)new NonOwningRoot(bindParams));
                statement.executeUpdate(new CallOption[0]);
            }
            finally {
                statement.close();
            }
        }
        catch (FlightRuntimeException e) {
            if (e.getCause() instanceof ExecutionException && e.getCause().getCause() instanceof FlightRuntimeException) {
                throw FlightSqlDriverUtil.fromFlightException((FlightRuntimeException)e.getCause().getCause());
            }
            throw FlightSqlDriverUtil.fromFlightException(e);
        }
        return new AdbcStatement.UpdateResult((long)bindParams.getRowCount());
    }

    private <R> R execute(Execute<FlightSqlClient.PreparedStatement, R> doPrepared, Execute<FlightSqlClientWithCallOptions, R> doRegular) throws AdbcException {
        try {
            if (this.preparedStatement != null) {
                FlightSqlClient.PreparedStatement prepared = this.preparedStatement;
                if (this.bindRoot != null) {
                    prepared.setParameters((VectorSchemaRoot)new NonOwningRoot(this.bindRoot));
                }
                return doPrepared.execute(prepared);
            }
            return doRegular.execute(this.client);
        }
        catch (FlightRuntimeException e) {
            throw FlightSqlDriverUtil.fromFlightException(e);
        }
    }

    private FlightInfo executeFlightInfo() throws AdbcException {
        if (this.bulkOperation != null) {
            throw AdbcException.invalidState((String)"[Flight SQL] Must executeUpdate() for bulk ingestion");
        }
        if (this.sqlQuery == null) {
            throw AdbcException.invalidState((String)"[Flight SQL] Must setSqlQuery() before execute");
        }
        String query = this.sqlQuery;
        return this.execute(rec$ -> ((FlightSqlClient.PreparedStatement)rec$).execute(new CallOption[0]), client -> client.execute(query, new CallOption[0]));
    }

    public AdbcStatement.PartitionResult executePartitioned() throws AdbcException {
        FlightInfo info = this.executeFlightInfo();
        ArrayList<PartitionDescriptor> descriptors = new ArrayList<PartitionDescriptor>();
        for (FlightEndpoint endpoint : info.getEndpoints()) {
            Flight.FlightEndpoint.Builder protoEndpoint = Flight.FlightEndpoint.newBuilder().setTicket(Flight.Ticket.newBuilder().setTicket(ByteString.copyFrom((byte[])endpoint.getTicket().getBytes())));
            for (Location location : endpoint.getLocations()) {
                protoEndpoint.addLocation(Flight.Location.newBuilder().setUri(location.getUri().toString()).build());
            }
            descriptors.add(new PartitionDescriptor(protoEndpoint.build().toByteString().asReadOnlyByteBuffer()));
        }
        return new AdbcStatement.PartitionResult(info.getSchema(), info.getRecords(), descriptors);
    }

    public AdbcStatement.QueryResult executeQuery() throws AdbcException {
        FlightInfo info = this.executeFlightInfo();
        return new AdbcStatement.QueryResult(info.getRecords(), (ArrowReader)new FlightInfoReader(this.allocator, this.client, this.clientCache, info.getEndpoints()));
    }

    public Schema executeSchema() throws AdbcException {
        if (this.bulkOperation != null) {
            throw AdbcException.invalidState((String)"[Flight SQL] Must executeUpdate() for bulk ingestion");
        }
        if (this.sqlQuery == null) {
            throw AdbcException.invalidState((String)"[Flight SQL] Must setSqlQuery() before execute");
        }
        String query = this.sqlQuery;
        return this.execute(FlightSqlClient.PreparedStatement::getResultSetSchema, client -> client.getExecuteSchema(query, new CallOption[0]).getSchema());
    }

    public AdbcStatement.UpdateResult executeUpdate() throws AdbcException {
        if (this.bulkOperation != null) {
            return this.executeBulk(this.bulkOperation);
        }
        if (this.sqlQuery == null) {
            throw AdbcException.invalidState((String)"[Flight SQL] Must setSqlQuery() before executeUpdate");
        }
        String query = this.sqlQuery;
        long updatedRows = this.execute(preparedStatement -> {
            try {
                return preparedStatement.executeUpdate(new CallOption[0]);
            }
            catch (FlightRuntimeException e) {
                throw FlightSqlDriverUtil.fromFlightException(e);
            }
        }, client -> client.executeUpdate(query, new CallOption[0]));
        return new AdbcStatement.UpdateResult(updatedRows);
    }

    public Schema getParameterSchema() throws AdbcException {
        if (this.preparedStatement == null) {
            throw AdbcException.invalidState((String)"[Flight SQL] Must call prepare() before getParameterSchema()");
        }
        return this.preparedStatement.getParameterSchema();
    }

    public void prepare() throws AdbcException {
        try {
            if (this.sqlQuery == null) {
                throw AdbcException.invalidArgument((String)"[Flight SQL] Must call setSqlQuery(String) before prepare()");
            }
            this.preparedStatement = this.client.prepare(this.sqlQuery, new CallOption[0]);
        }
        catch (FlightRuntimeException e) {
            throw FlightSqlDriverUtil.fromFlightException(e);
        }
    }

    public void close() throws Exception {
        if (this.preparedStatement != null) {
            AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.preparedStatement});
        }
    }

    private static final class NonOwningRoot
    extends VectorSchemaRoot {
        public NonOwningRoot(VectorSchemaRoot parent) {
            super(parent.getSchema(), parent.getFieldVectors(), parent.getRowCount());
        }

        public void close() {
        }
    }

    private static final class BulkState {
        BulkIngestMode mode;
        String targetTable;

        public BulkState(BulkIngestMode mode, String targetTableName) {
            this.mode = mode;
            this.targetTable = targetTableName;
        }
    }

    @FunctionalInterface
    static interface Execute<T, R> {
        public R execute(T var1) throws AdbcException;
    }
}

