/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.flightsql;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.primitives.Shorts;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.arrow.adbc.core.AdbcConnection;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.core.AdbcStatusCode;
import org.apache.arrow.adbc.core.StandardSchemas;
import org.apache.arrow.adbc.driver.flightsql.BaseFlightReader;
import org.apache.arrow.adbc.driver.flightsql.FlightSqlClientWithCallOptions;
import org.apache.arrow.adbc.driver.flightsql.FlightSqlDriverUtil;
import org.apache.arrow.driver.jdbc.utils.SqlTypes;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.sql.FlightSqlColumnMetadata;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.ReusableBuffer;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.VarCharWriter;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.checkerframework.checker.nullness.qual.Nullable;

final class GetObjectsMetadataReaders {
    private static final String JAVA_REGEX_SPECIALS = "[]()|^-+*?{}$\\.";
    static final int NO_DECIMAL_DIGITS = 0;
    static final int COLUMN_SIZE_BYTE = (int)Math.ceil(7.0 * Math.log(2.0) / Math.log(10.0));
    static final int COLUMN_SIZE_SHORT = (int)Math.ceil(15.0 * Math.log(2.0) / Math.log(10.0));
    static final int COLUMN_SIZE_INT = (int)Math.ceil(31.0 * Math.log(2.0) / Math.log(10.0));
    static final int COLUMN_SIZE_LONG = (int)Math.ceil(63.0 * Math.log(2.0) / Math.log(10.0));
    static final int COLUMN_SIZE_VARCHAR_AND_BINARY = 65536;
    static final int COLUMN_SIZE_DATE = "YYYY-MM-DD".length();
    static final int COLUMN_SIZE_TIME = "HH:MM:ss".length();
    static final int COLUMN_SIZE_TIME_MILLISECONDS = "HH:MM:ss.SSS".length();
    static final int COLUMN_SIZE_TIME_MICROSECONDS = "HH:MM:ss.SSSSSS".length();
    static final int COLUMN_SIZE_TIME_NANOSECONDS = "HH:MM:ss.SSSSSSSSS".length();
    static final int COLUMN_SIZE_TIMESTAMP_SECONDS = COLUMN_SIZE_DATE + 1 + COLUMN_SIZE_TIME;
    static final int COLUMN_SIZE_TIMESTAMP_MILLISECONDS = COLUMN_SIZE_DATE + 1 + COLUMN_SIZE_TIME_MILLISECONDS;
    static final int COLUMN_SIZE_TIMESTAMP_MICROSECONDS = COLUMN_SIZE_DATE + 1 + COLUMN_SIZE_TIME_MICROSECONDS;
    static final int COLUMN_SIZE_TIMESTAMP_NANOSECONDS = COLUMN_SIZE_DATE + 1 + COLUMN_SIZE_TIME_NANOSECONDS;
    static final int DECIMAL_DIGITS_TIME_MILLISECONDS = 3;
    static final int DECIMAL_DIGITS_TIME_MICROSECONDS = 6;
    static final int DECIMAL_DIGITS_TIME_NANOSECONDS = 9;

    GetObjectsMetadataReaders() {
    }

    static ArrowReader CreateGetObjectsReader(BufferAllocator allocator, FlightSqlClientWithCallOptions client, LoadingCache<Location, FlightSqlClientWithCallOptions> clientCache, AdbcConnection.GetObjectsDepth depth, String catalogPattern, String dbSchemaPattern, String tableNamePattern, String[] tableTypes, String columnNamePattern) throws AdbcException {
        switch (depth) {
            case CATALOGS: {
                return new GetCatalogsMetadataReader(allocator, client, clientCache, catalogPattern);
            }
            case DB_SCHEMAS: {
                return new GetDbSchemasMetadataReader(allocator, client, clientCache, catalogPattern, dbSchemaPattern);
            }
            case TABLES: {
                return new GetTablesMetadataReader(allocator, client, clientCache, catalogPattern, dbSchemaPattern, tableNamePattern, tableTypes);
            }
            case ALL: {
                return new GetTablesMetadataReader(allocator, client, clientCache, catalogPattern, dbSchemaPattern, tableNamePattern, tableTypes, columnNamePattern);
            }
        }
        throw new IllegalArgumentException();
    }

    static @Nullable Integer getDecimalDigits(ArrowType fieldType) {
        if (fieldType instanceof ArrowType.Decimal) {
            ArrowType.Decimal thisDecimal = (ArrowType.Decimal)fieldType;
            return thisDecimal.getScale();
        }
        if (fieldType instanceof ArrowType.Int) {
            return 0;
        }
        if (fieldType instanceof ArrowType.Timestamp) {
            switch (((ArrowType.Timestamp)fieldType).getUnit()) {
                case SECOND: {
                    return 0;
                }
                case MILLISECOND: {
                    return 3;
                }
                case MICROSECOND: {
                    return 6;
                }
                case NANOSECOND: {
                    return 9;
                }
            }
        } else if (fieldType instanceof ArrowType.Time) {
            switch (((ArrowType.Time)fieldType).getUnit()) {
                case SECOND: {
                    return 0;
                }
                case MILLISECOND: {
                    return 3;
                }
                case MICROSECOND: {
                    return 6;
                }
                case NANOSECOND: {
                    return 9;
                }
            }
        } else if (fieldType instanceof ArrowType.Date) {
            return 0;
        }
        return null;
    }

    static @Nullable Integer getColumnSize(ArrowType fieldType) {
        if (fieldType instanceof ArrowType.Decimal) {
            ArrowType.Decimal thisDecimal = (ArrowType.Decimal)fieldType;
            return thisDecimal.getPrecision();
        }
        if (fieldType instanceof ArrowType.Int) {
            ArrowType.Int thisInt = (ArrowType.Int)fieldType;
            switch (thisInt.getBitWidth()) {
                case 8: {
                    return COLUMN_SIZE_BYTE;
                }
                case 16: {
                    return COLUMN_SIZE_SHORT;
                }
                case 32: {
                    return COLUMN_SIZE_INT;
                }
                case 64: {
                    return COLUMN_SIZE_LONG;
                }
            }
        } else {
            if (fieldType instanceof ArrowType.Utf8 || fieldType instanceof ArrowType.Binary) {
                return 65536;
            }
            if (fieldType instanceof ArrowType.Timestamp) {
                switch (((ArrowType.Timestamp)fieldType).getUnit()) {
                    case SECOND: {
                        return COLUMN_SIZE_TIMESTAMP_SECONDS;
                    }
                    case MILLISECOND: {
                        return COLUMN_SIZE_TIMESTAMP_MILLISECONDS;
                    }
                    case MICROSECOND: {
                        return COLUMN_SIZE_TIMESTAMP_MICROSECONDS;
                    }
                    case NANOSECOND: {
                        return COLUMN_SIZE_TIMESTAMP_NANOSECONDS;
                    }
                }
            } else if (fieldType instanceof ArrowType.Time) {
                switch (((ArrowType.Time)fieldType).getUnit()) {
                    case SECOND: {
                        return COLUMN_SIZE_TIME;
                    }
                    case MILLISECOND: {
                        return COLUMN_SIZE_TIME_MILLISECONDS;
                    }
                    case MICROSECOND: {
                        return COLUMN_SIZE_TIME_MICROSECONDS;
                    }
                    case NANOSECOND: {
                        return COLUMN_SIZE_TIME_NANOSECONDS;
                    }
                }
            } else if (fieldType instanceof ArrowType.Date) {
                return COLUMN_SIZE_DATE;
            }
        }
        return null;
    }

    static String sqlToRegexLike(String sqlPattern) {
        int len = sqlPattern.length();
        StringBuilder javaPattern = new StringBuilder(len + len);
        block4: for (int i = 0; i < len; ++i) {
            char currentChar = sqlPattern.charAt(i);
            if (JAVA_REGEX_SPECIALS.indexOf(currentChar) >= 0) {
                javaPattern.append('\\');
            }
            switch (currentChar) {
                case '_': {
                    javaPattern.append('.');
                    continue block4;
                }
                case '%': {
                    javaPattern.append(".");
                    javaPattern.append('*');
                    continue block4;
                }
                default: {
                    javaPattern.append(currentChar);
                }
            }
        }
        return javaPattern.toString();
    }

    private static class GetTablesMetadataReader
    extends GetObjectMetadataReader {
        private final String catalogPattern;
        private final String dbSchemaPattern;
        private final @Nullable Pattern compiledColumnNamePattern;
        private final boolean shouldGetColumns;
        private final Map<String, Map<String, Map<String, TableDefinition>>> tablePathToColumnsMap = new LinkedHashMap<String, Map<String, Map<String, TableDefinition>>>();

        protected GetTablesMetadataReader(BufferAllocator allocator, FlightSqlClientWithCallOptions client, LoadingCache<Location, FlightSqlClientWithCallOptions> clientCache, String catalogPattern, String schemaPattern, String tablePattern, String[] tableTypes) throws AdbcException {
            super(allocator, client, clientCache, () -> GetTablesMetadataReader.doRequest(client, catalogPattern, schemaPattern, tablePattern, tableTypes, false));
            this.catalogPattern = catalogPattern;
            this.dbSchemaPattern = schemaPattern;
            this.compiledColumnNamePattern = null;
            this.shouldGetColumns = false;
        }

        protected GetTablesMetadataReader(BufferAllocator allocator, FlightSqlClientWithCallOptions client, LoadingCache<Location, FlightSqlClientWithCallOptions> clientCache, String catalogPattern, String schemaPattern, String tablePattern, String[] tableTypes, String columnPattern) throws AdbcException {
            super(allocator, client, clientCache, () -> GetTablesMetadataReader.doRequest(client, catalogPattern, schemaPattern, tablePattern, tableTypes, true));
            this.catalogPattern = catalogPattern;
            this.dbSchemaPattern = schemaPattern;
            this.compiledColumnNamePattern = columnPattern != null ? Pattern.compile(GetObjectsMetadataReaders.sqlToRegexLike(columnPattern)) : null;
            this.shouldGetColumns = true;
        }

        @Override
        protected void processRootFromStream(VectorSchemaRoot root) {
            VarCharVector catalogVector = (VarCharVector)root.getVector(0);
            VarCharVector schemaVector = (VarCharVector)root.getVector(1);
            VarCharVector tableVector = (VarCharVector)root.getVector(2);
            VarCharVector tableTypeVector = (VarCharVector)root.getVector(3);
            VarBinaryVector tableSchemaVector = this.shouldGetColumns ? (VarBinaryVector)root.getVector(4) : null;
            for (int i = 0; i < root.getRowCount(); ++i) {
                String tableType;
                String schema;
                String catalog;
                List<ColumnDefinition> columns = this.getColumnDefinitions(tableSchemaVector, i);
                if (catalogVector.isNull(i)) {
                    catalog = "";
                } else {
                    catalogVector.read(i, (ReusableBuffer)this.buffer);
                    catalog = this.buffer.toString();
                }
                if (schemaVector.isNull(i)) {
                    schema = "";
                } else {
                    schemaVector.read(i, (ReusableBuffer)this.buffer);
                    schema = this.buffer.toString();
                }
                if (tableTypeVector.isNull(i)) {
                    tableType = null;
                } else {
                    tableTypeVector.read(i, (ReusableBuffer)this.buffer);
                    tableType = this.buffer.toString();
                }
                tableVector.read(i, (ReusableBuffer)this.buffer);
                String table = this.buffer.toString();
                this.tablePathToColumnsMap.compute(catalog, (catalogEntryKey, catalogEntryValue) -> {
                    if (catalogEntryValue == null) {
                        catalogEntryValue = new HashMap<String, Map>();
                    }
                    catalogEntryValue.compute(schema, (schemaEntryKey, schemaEntryValue) -> {
                        if (schemaEntryValue == null) {
                            schemaEntryValue = new LinkedHashMap<String, TableDefinition>();
                        }
                        TableDefinition tableDefinition = new TableDefinition(tableType, columns);
                        schemaEntryValue.put(table, tableDefinition);
                        return schemaEntryValue;
                    });
                    return catalogEntryValue;
                });
            }
        }

        @Override
        protected void finish() throws AdbcException, IOException {
            try (GetDbSchemasMetadataReader schemaReader = new GetDbSchemasMetadataReader(this.allocator, this.client, (LoadingCache<Location, FlightSqlClientWithCallOptions>)this.clientCache, this.catalogPattern, this.dbSchemaPattern);){
                if (!schemaReader.loadNextBatch()) {
                    return;
                }
                VarCharVector outputCatalogColumn = (VarCharVector)this.getAggregateRoot().getVector(0);
                ListVector outputSchemaStructList = (ListVector)this.getAggregateRoot().getVector(1);
                ListVector sourceSchemaStructList = (ListVector)schemaReader.getAggregateRoot().getVector(1);
                this.getAggregateRoot().setRowCount(schemaReader.getAggregateRoot().getRowCount());
                VarCharVector catalogColumn = (VarCharVector)schemaReader.getAggregateRoot().getVector(0);
                catalogColumn.makeTransferPair((ValueVector)outputCatalogColumn).transfer();
                UnionListWriter schemaListWriter = outputSchemaStructList.getWriter();
                schemaListWriter.allocate();
                for (int i = 0; i < this.getAggregateRoot().getRowCount(); ++i) {
                    outputCatalogColumn.read(i, (ReusableBuffer)this.buffer);
                    String catalog = this.buffer.toString();
                    schemaListWriter.startList();
                    for (Object schemaStructObj : sourceSchemaStructList.getObject(i)) {
                        Map<String, TableDefinition> tables;
                        Map schemaStructAsMap = (Map)schemaStructObj;
                        if (schemaStructAsMap == null) {
                            throw new IllegalStateException(String.format("Error in catalog %s: Null schema encountered when schemas were requested.", catalog));
                        }
                        Object schemaNameObj = schemaStructAsMap.get("db_schema_name");
                        if (schemaNameObj == null) {
                            throw new IllegalStateException(String.format("Error in catalog %s: Schema with no name encountered.", catalog));
                        }
                        String schemaName = schemaNameObj.toString();
                        schemaListWriter.setPosition(i);
                        BaseWriter.StructWriter schemaStructWriter = schemaListWriter.struct();
                        schemaStructWriter.start();
                        schemaStructWriter.varChar("db_schema_name").writeVarChar(schemaName);
                        BaseWriter.ListWriter tableWriter = schemaStructWriter.list("db_schema_tables");
                        tableWriter.startList();
                        Map<String, Map<String, TableDefinition>> schemaToTableMap = this.tablePathToColumnsMap.get(catalog);
                        if (schemaToTableMap != null && (tables = schemaToTableMap.get(schemaName)) != null) {
                            for (Map.Entry<String, TableDefinition> table : tables.entrySet()) {
                                BaseWriter.StructWriter tableStructWriter = tableWriter.struct();
                                tableStructWriter.start();
                                tableStructWriter.varChar("table_name").writeVarChar(table.getKey());
                                if (table.getValue().tableType != null) {
                                    tableStructWriter.varChar("table_type").writeVarChar(table.getValue().tableType);
                                }
                                if (this.shouldGetColumns) {
                                    BaseWriter.ListWriter columnListWriter = tableStructWriter.list("table_columns");
                                    columnListWriter.startList();
                                    for (ColumnDefinition columnDefinition : table.getValue().columnDefinitions) {
                                        BaseWriter.StructWriter columnDefinitionWriter = columnListWriter.struct();
                                        this.writeColumnDefinition(columnDefinition, columnDefinitionWriter);
                                    }
                                    columnListWriter.endList();
                                }
                                tableStructWriter.end();
                            }
                        }
                        tableWriter.endList();
                        schemaStructWriter.end();
                    }
                    schemaListWriter.endList();
                }
                schemaListWriter.setValueCount(this.getAggregateRoot().getRowCount());
            }
        }

        private List<ColumnDefinition> getColumnDefinitions(@Nullable VarBinaryVector tableSchemaVector, int index) {
            if (tableSchemaVector == null) {
                return Collections.emptyList();
            }
            tableSchemaVector.read(index, (ReusableBuffer)this.buffer);
            try {
                ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
                Schema tableSchema = MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel(Channels.newChannel(new ByteArrayInputStream(this.buffer.getBytes(), 0, (int)this.buffer.getLength()))));
                List fields = tableSchema.getFields();
                for (int fieldIndex = 0; fieldIndex < fields.size(); ++fieldIndex) {
                    Field field = (Field)fields.get(fieldIndex);
                    if (this.compiledColumnNamePattern != null && !this.compiledColumnNamePattern.matcher(field.getName()).matches()) continue;
                    result.add(ColumnDefinition.from(field, fieldIndex + 1));
                }
                return result;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void writeColumnDefinition(ColumnDefinition columnDefinition, BaseWriter.StructWriter columnDefinitionWriter) {
            Integer decimalDigits;
            Integer columnSize;
            columnDefinitionWriter.start();
            columnDefinitionWriter.varChar("column_name").writeVarChar(columnDefinition.field.getName());
            columnDefinitionWriter.integer("ordinal_position").writeInt(columnDefinition.ordinal);
            columnDefinitionWriter.smallInt("xdbc_data_type").writeSmallInt(Shorts.saturatedCast((long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)columnDefinition.field.getType())));
            ArrowType fieldType = columnDefinition.field.getType();
            String typeName = columnDefinition.metadata.getTypeName();
            if (typeName == null) {
                typeName = SqlTypes.getSqlTypeNameFromArrowType((ArrowType)fieldType);
            }
            if (typeName != null) {
                columnDefinitionWriter.varChar("xdbc_type_name").writeVarChar(typeName);
            }
            if ((columnSize = columnDefinition.metadata.getPrecision()) == null) {
                columnSize = GetObjectsMetadataReaders.getColumnSize(fieldType);
            }
            if (columnSize != null) {
                columnDefinitionWriter.integer("xdbc_column_size").writeInt(columnSize.intValue());
            }
            if ((decimalDigits = columnDefinition.metadata.getScale()) == null) {
                decimalDigits = GetObjectsMetadataReaders.getDecimalDigits(fieldType);
            }
            if (decimalDigits != null) {
                columnDefinitionWriter.smallInt("xdbc_decimal_digits").writeSmallInt(Shorts.saturatedCast((long)decimalDigits.intValue()));
            }
            if (fieldType instanceof ArrowType.Decimal) {
                columnDefinitionWriter.smallInt("xdbc_num_prec_radix").writeSmallInt((short)10);
            } else if (fieldType instanceof ArrowType.Int) {
                columnDefinitionWriter.smallInt("xdbc_num_prec_radix").writeSmallInt((short)10);
            } else if (fieldType instanceof ArrowType.FloatingPoint) {
                columnDefinitionWriter.smallInt("xdbc_num_prec_radix").writeSmallInt((short)10);
            }
            columnDefinitionWriter.smallInt("xdbc_nullable").writeSmallInt(columnDefinition.field.isNullable() ? (short)1 : 0);
            columnDefinitionWriter.smallInt("xdbc_sql_data_type").writeSmallInt((short)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)fieldType));
            columnDefinitionWriter.varChar("xdbc_is_nullable").writeVarChar(columnDefinition.field.isNullable() ? "YES" : "NO");
            if (columnDefinition.metadata.isAutoIncrement() != null) {
                columnDefinitionWriter.bit("xdbc_auto_increment").writeBit(columnDefinition.metadata.isAutoIncrement() != false ? 1 : 0);
            }
            columnDefinitionWriter.end();
        }

        private static List<FlightEndpoint> doRequest(FlightSqlClientWithCallOptions client, String catalog, String schemaPattern, String table, String[] tableTypes, boolean shouldGetColumns) {
            return client.getTables(catalog, schemaPattern, table, null != tableTypes ? Arrays.asList(tableTypes) : null, shouldGetColumns, new CallOption[0]).getEndpoints();
        }

        private static class TableDefinition {
            final String tableType;
            final List<ColumnDefinition> columnDefinitions;

            TableDefinition(String tableType, List<ColumnDefinition> columnDefinitions) {
                this.tableType = tableType;
                this.columnDefinitions = columnDefinitions;
            }
        }

        private static class ColumnDefinition {
            final Field field;
            final FlightSqlColumnMetadata metadata;
            final int ordinal;

            private ColumnDefinition(Field field, int ordinal) {
                this.field = field;
                this.metadata = new FlightSqlColumnMetadata(field.getMetadata());
                this.ordinal = ordinal;
            }

            static ColumnDefinition from(Field field, int ordinal) {
                return new ColumnDefinition(field, ordinal);
            }
        }
    }

    private static class GetDbSchemasMetadataReader
    extends GetObjectMetadataReader {
        private final String catalog;
        private final Map<String, List<String>> catalogToSchemaMap = new LinkedHashMap<String, List<String>>();

        protected GetDbSchemasMetadataReader(BufferAllocator allocator, FlightSqlClientWithCallOptions client, LoadingCache<Location, FlightSqlClientWithCallOptions> clientCache, String catalog, String schemaPattern) throws AdbcException {
            super(allocator, client, clientCache, () -> GetDbSchemasMetadataReader.doRequest(client, catalog, schemaPattern));
            this.catalog = catalog;
        }

        @Override
        protected void processRootFromStream(VectorSchemaRoot root) {
            VarCharVector catalogVector = (VarCharVector)root.getVector(0);
            VarCharVector schemaVector = (VarCharVector)root.getVector(1);
            for (int i = 0; i < root.getRowCount(); ++i) {
                String catalog;
                if (catalogVector.isNull(i)) {
                    catalog = "";
                } else {
                    catalogVector.read(i, (ReusableBuffer)this.buffer);
                    catalog = this.buffer.toString();
                }
                schemaVector.read(i, (ReusableBuffer)this.buffer);
                String schema = this.buffer.toString();
                this.catalogToSchemaMap.compute(catalog, (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<String>();
                    }
                    v.add(schema);
                    return v;
                });
            }
        }

        @Override
        protected void finish() throws AdbcException, IOException {
            VarCharVector outputCatalogColumn = (VarCharVector)this.getAggregateRoot().getVector(0);
            try (GetCatalogsMetadataReader catalogReader = new GetCatalogsMetadataReader(this.allocator, this.client, (LoadingCache<Location, FlightSqlClientWithCallOptions>)this.clientCache, this.catalog);){
                if (!catalogReader.loadNextBatch()) {
                    return;
                }
                this.getAggregateRoot().setRowCount(catalogReader.getAggregateRoot().getRowCount());
                VarCharVector catalogColumn = (VarCharVector)catalogReader.getAggregateRoot().getVector(0);
                catalogColumn.makeTransferPair((ValueVector)outputCatalogColumn).transfer();
            }
            UnionListWriter adbcCatalogDbSchemasWriter = ((ListVector)this.getAggregateRoot().getVector(1)).getWriter();
            BaseWriter.StructWriter adbcCatalogDbSchemasStructWriter = adbcCatalogDbSchemasWriter.struct();
            for (int i = 0; i < this.getAggregateRoot().getRowCount(); ++i) {
                outputCatalogColumn.read(i, (ReusableBuffer)this.buffer);
                String catalog = this.buffer.toString();
                List<String> schemas = this.catalogToSchemaMap.get(catalog);
                adbcCatalogDbSchemasWriter.setPosition(i);
                adbcCatalogDbSchemasWriter.startList();
                if (schemas != null) {
                    for (String schema : schemas) {
                        adbcCatalogDbSchemasStructWriter.start();
                        VarCharWriter adbcCatalogDbSchemaNameWriter = adbcCatalogDbSchemasStructWriter.varChar("db_schema_name");
                        adbcCatalogDbSchemaNameWriter.writeVarChar(schema);
                        adbcCatalogDbSchemasStructWriter.end();
                    }
                }
                adbcCatalogDbSchemasWriter.endList();
            }
            adbcCatalogDbSchemasWriter.setValueCount(this.getAggregateRoot().getRowCount());
        }

        private static List<FlightEndpoint> doRequest(FlightSqlClientWithCallOptions client, String catalog, String schemaPattern) {
            return client.getSchemas(catalog, schemaPattern, new CallOption[0]).getEndpoints();
        }
    }

    private static class GetCatalogsMetadataReader
    extends GetObjectMetadataReader {
        private final @Nullable Pattern catalogPattern;

        protected GetCatalogsMetadataReader(BufferAllocator allocator, FlightSqlClientWithCallOptions client, LoadingCache<Location, FlightSqlClientWithCallOptions> clientCache, String catalog) throws AdbcException {
            super(allocator, client, clientCache, () -> GetCatalogsMetadataReader.doRequest(client));
            this.catalogPattern = catalog != null ? Pattern.compile(GetObjectsMetadataReaders.sqlToRegexLike(catalog)) : null;
        }

        @Override
        protected void processRootFromStream(VectorSchemaRoot root) {
            VarCharVector catalogVector = (VarCharVector)root.getVector(0);
            VarCharVector adbcCatalogNames = (VarCharVector)this.getAggregateRoot().getVector(0);
            int dstIndex = this.getAggregateRoot().getRowCount();
            for (int srcIndex = 0; srcIndex < root.getRowCount(); ++srcIndex) {
                catalogVector.read(srcIndex, (ReusableBuffer)this.buffer);
                if (this.catalogPattern != null && !this.catalogPattern.matcher(this.buffer.toString()).matches()) continue;
                catalogVector.makeTransferPair((ValueVector)adbcCatalogNames).copyValueSafe(srcIndex, dstIndex++);
            }
            this.getAggregateRoot().setRowCount(dstIndex);
        }

        private static List<FlightEndpoint> doRequest(FlightSqlClientWithCallOptions client) {
            return client.getCatalogs(new CallOption[0]).getEndpoints();
        }
    }

    private static abstract class GetObjectMetadataReader
    extends BaseFlightReader {
        private final VectorSchemaRoot aggregateRoot;
        private boolean hasLoaded = false;
        protected final Text buffer = new Text();

        protected GetObjectMetadataReader(BufferAllocator allocator, FlightSqlClientWithCallOptions client, LoadingCache<Location, FlightSqlClientWithCallOptions> clientCache, Supplier<List<FlightEndpoint>> rpcCall) throws AdbcException {
            super(allocator, client, clientCache, rpcCall);
            this.aggregateRoot = VectorSchemaRoot.create((Schema)this.readSchema(), (BufferAllocator)allocator);
            this.populateEndpointData();
            try {
                this.ensureInitialized();
            }
            catch (IOException e) {
                throw new AdbcException(FlightSqlDriverUtil.prefixExceptionMessage(e.getMessage()), (Throwable)e, AdbcStatusCode.IO, null, 0);
            }
        }

        public void close() throws IOException {
            Exception caughtException = null;
            try {
                AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.aggregateRoot});
            }
            catch (Exception ex) {
                caughtException = ex;
            }
            super.close();
            if (caughtException != null) {
                throw new RuntimeException(caughtException);
            }
        }

        @Override
        public boolean loadNextBatch() throws IOException {
            if (!this.hasLoaded) {
                while (super.loadNextBatch()) {
                }
                try {
                    this.finish();
                }
                catch (AdbcException e) {
                    throw new RuntimeException(e);
                }
                this.hasLoaded = true;
                if (this.aggregateRoot.getRowCount() > 0) {
                    this.loadRoot(this.aggregateRoot);
                    return true;
                }
            }
            return false;
        }

        @Override
        protected Schema readSchema() {
            return StandardSchemas.GET_OBJECTS_SCHEMA;
        }

        protected void finish() throws AdbcException, IOException {
        }

        protected VectorSchemaRoot getAggregateRoot() {
            return this.aggregateRoot;
        }
    }
}

