/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.arrow.adbc.core.AdbcConnection;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.core.AdbcStatement;
import org.apache.arrow.adbc.core.AdbcStatusCode;
import org.apache.arrow.adbc.core.BulkIngestMode;
import org.apache.arrow.adbc.core.IsolationLevel;
import org.apache.arrow.adbc.core.StandardSchemas;
import org.apache.arrow.adbc.core.StandardStatistics;
import org.apache.arrow.adbc.driver.jdbc.InfoMetadataBuilder;
import org.apache.arrow.adbc.driver.jdbc.JdbcArrowReader;
import org.apache.arrow.adbc.driver.jdbc.JdbcDriverUtil;
import org.apache.arrow.adbc.driver.jdbc.JdbcQuirks;
import org.apache.arrow.adbc.driver.jdbc.JdbcStatement;
import org.apache.arrow.adbc.driver.jdbc.ObjectMetadataBuilder;
import org.apache.arrow.adbc.driver.jdbc.RootArrowReader;
import org.apache.arrow.adbc.driver.jdbc.adapter.JdbcFieldInfoExtra;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.holders.NullableBigIntHolder;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JdbcConnection
implements AdbcConnection {
    private final BufferAllocator allocator;
    private final Connection connection;
    private final JdbcQuirks quirks;

    JdbcConnection(BufferAllocator allocator, Connection connection, JdbcQuirks quirks) {
        this.allocator = allocator;
        this.connection = connection;
        this.quirks = quirks;
    }

    public void commit() throws AdbcException {
        try {
            this.checkAutoCommit();
            this.connection.commit();
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public AdbcStatement createStatement() throws AdbcException {
        return new JdbcStatement(this.allocator, this.connection, this.quirks);
    }

    public AdbcStatement bulkIngest(String targetTableName, BulkIngestMode mode) throws AdbcException {
        return JdbcStatement.ingestRoot(this.allocator, this.connection, this.quirks, targetTableName, mode);
    }

    public ArrowReader getInfo(int @Nullable [] infoCodes) throws AdbcException {
        ArrowReader arrowReader;
        block8: {
            VectorSchemaRoot root = new InfoMetadataBuilder(this.allocator, this.connection, infoCodes).build();
            try {
                arrowReader = RootArrowReader.fromRoot(this.allocator, root);
                if (root == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (root != null) {
                        try {
                            root.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw JdbcDriverUtil.fromSqlException(e);
                }
            }
            root.close();
        }
        return arrowReader;
    }

    public ArrowReader getObjects(AdbcConnection.GetObjectsDepth depth, String catalogPattern, String dbSchemaPattern, String tableNamePattern, String[] tableTypes, String columnNamePattern) throws AdbcException {
        ArrowReader arrowReader;
        block8: {
            VectorSchemaRoot root = new ObjectMetadataBuilder(this.allocator, this.connection, depth, catalogPattern, dbSchemaPattern, tableNamePattern, tableTypes, columnNamePattern).build();
            try {
                arrowReader = RootArrowReader.fromRoot(this.allocator, root);
                if (root == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (root != null) {
                        try {
                            root.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw JdbcDriverUtil.fromSqlException(e);
                }
            }
            root.close();
        }
        return arrowReader;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ArrowReader getStatistics(String catalogPattern, String dbSchemaPattern, String tableNamePattern, boolean approximate) throws AdbcException {
        if (tableNamePattern == null) {
            throw AdbcException.notImplemented((String)JdbcDriverUtil.prefixExceptionMessage("getStatistics: must supply table name"));
        }
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)StandardSchemas.GET_STATISTICS_SCHEMA, (BufferAllocator)this.allocator);){
            ArrowReader arrowReader;
            block30: {
                ResultSet rs = this.connection.getMetaData().getIndexInfo(catalogPattern, dbSchemaPattern, tableNamePattern, false, approximate);
                try {
                    HashMap allStatistics = new HashMap();
                    while (rs.next()) {
                        Map catalogStats;
                        @Nullable String catalog = rs.getString(1);
                        String schema = rs.getString(2);
                        String table = rs.getString(3);
                        String index = rs.getString(6);
                        short statisticType = rs.getShort(7);
                        String column = rs.getString(9);
                        long cardinality = rs.getLong(11);
                        if (table == null || column == null) {
                            throw new AdbcException(JdbcDriverUtil.prefixExceptionMessage("JDBC driver returned null table/column name"), null, AdbcStatusCode.INTERNAL, null, 0);
                        }
                        if (!allStatistics.containsKey(catalog)) {
                            allStatistics.put(catalog, new HashMap());
                        }
                        if (!(catalogStats = (Map)allStatistics.get(catalog)).containsKey(schema)) {
                            catalogStats.put(schema, new HashMap());
                        }
                        Map schemaStats = (Map)catalogStats.get(schema);
                        Statistic statistic = schemaStats.getOrDefault(index, new Statistic(table, column));
                        assert (statistic != null);
                        if (schemaStats.containsKey(index)) {
                            statistic.multiColumn = true;
                            continue;
                        }
                        statistic.column = column;
                        statistic.table = table;
                        statistic.key = statisticType == 0 ? StandardStatistics.ROW_COUNT.getKey() : StandardStatistics.DISTINCT_COUNT.getKey();
                        statistic.value = cardinality;
                        schemaStats.put(index, statistic);
                    }
                    VarCharVector catalogNames = (VarCharVector)root.getVector(0);
                    ListVector catalogDbSchemas = (ListVector)root.getVector(1);
                    StructVector dbSchemas = (StructVector)catalogDbSchemas.getDataVector();
                    VarCharVector dbSchemaNames = (VarCharVector)dbSchemas.getVectorById(0);
                    ListVector dbSchemaStatistics = (ListVector)dbSchemas.getVectorById(1);
                    StructVector statistics = (StructVector)dbSchemaStatistics.getDataVector();
                    VarCharVector tableNames = (VarCharVector)statistics.getVectorById(0);
                    VarCharVector columnNames = (VarCharVector)statistics.getVectorById(1);
                    SmallIntVector statisticKeys = (SmallIntVector)statistics.getVectorById(2);
                    DenseUnionVector statisticValues = (DenseUnionVector)statistics.getVectorById(3);
                    BitVector statisticIsApproximate = (BitVector)statistics.getVectorById(4);
                    Text text = new Text();
                    NullableBigIntHolder holder = new NullableBigIntHolder();
                    int catalogIndex = 0;
                    int schemaIndex = 0;
                    int statisticIndex = 0;
                    for (String catalog : allStatistics.keySet()) {
                        Map schemas = (Map)allStatistics.get(catalog);
                        if (catalog == null) {
                            catalogNames.setNull(catalogIndex);
                        } else {
                            text.set(catalog);
                            catalogNames.setSafe(catalogIndex, text);
                        }
                        catalogDbSchemas.startNewValue(catalogIndex);
                        int schemaCount = 0;
                        for (String schema : schemas.keySet()) {
                            if (schema == null) {
                                dbSchemaNames.setNull(schemaIndex);
                            } else {
                                text.set(schema);
                                dbSchemaNames.setSafe(schemaIndex, text);
                            }
                            dbSchemaStatistics.startNewValue(schemaIndex);
                            Map indices = (Map)schemas.get(schema);
                            int statisticCount = 0;
                            for (Statistic statistic : indices.values()) {
                                if (statistic.multiColumn) continue;
                                text.set(statistic.table);
                                tableNames.setSafe(statisticIndex, text);
                                if (statistic.column == null) {
                                    columnNames.setNull(statisticIndex);
                                } else {
                                    text.set(statistic.column);
                                    columnNames.setSafe(statisticIndex, text);
                                }
                                statisticKeys.setSafe(statisticIndex, statistic.key);
                                statisticValues.setTypeId(statisticIndex, (byte)0);
                                holder.isSet = 1;
                                holder.value = statistic.value;
                                statisticValues.setSafe(statisticIndex, holder);
                                statisticIsApproximate.setSafe(statisticIndex, approximate ? 1 : 0);
                                statistics.setIndexDefined(statisticIndex++);
                                ++statisticCount;
                            }
                            dbSchemaStatistics.endValue(schemaIndex, statisticCount);
                            dbSchemas.setIndexDefined(schemaIndex++);
                            ++schemaCount;
                        }
                        catalogDbSchemas.endValue(catalogIndex, schemaCount);
                        ++catalogIndex;
                    }
                    root.setRowCount(catalogIndex);
                    arrowReader = RootArrowReader.fromRoot(this.allocator, root);
                    if (rs == null) break block30;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrowReader;
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public ArrowReader getStatisticNames() throws AdbcException {
        return super.getStatisticNames();
    }

    public Schema getTableSchema(String catalog, String dbSchema, String tableName) throws AdbcException {
        try (ResultSet rs = this.connection.getMetaData().getTables(catalog, dbSchema, tableName, null);){
            if (!rs.next()) {
                throw new AdbcException(JdbcDriverUtil.prefixExceptionMessage("Table not found: " + tableName), null, AdbcStatusCode.NOT_FOUND, null, 0);
            }
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        try (ResultSet rs = this.connection.getMetaData().getColumns(catalog, dbSchema, tableName, null);){
            while (rs.next()) {
                @Nullable String fieldName = rs.getString("COLUMN_NAME");
                if (fieldName == null) {
                    fieldName = "";
                }
                JdbcFieldInfoExtra fieldInfoExtra = new JdbcFieldInfoExtra(rs);
                ArrowType arrowType = (ArrowType)this.quirks.getTypeConverter().apply(fieldInfoExtra);
                if (arrowType == null) {
                    throw AdbcException.notImplemented((String)JdbcDriverUtil.prefixExceptionMessage(String.format("Column '%s' has unsupported type: %s", fieldName, fieldInfoExtra)));
                }
                Field field = new Field(fieldName, fieldInfoExtra.isNullable() == 0 ? FieldType.notNullable((ArrowType)arrowType) : FieldType.nullable((ArrowType)arrowType), Collections.emptyList());
                fields.add(field);
            }
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
        return new Schema(fields);
    }

    public ArrowReader getTableTypes() throws AdbcException {
        try {
            return new JdbcArrowReader(this.allocator, this.connection.getMetaData().getTableTypes(), StandardSchemas.TABLE_TYPES_SCHEMA);
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public void rollback() throws AdbcException {
        try {
            this.checkAutoCommit();
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public boolean getAutoCommit() throws AdbcException {
        try {
            return this.connection.getAutoCommit();
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public void setAutoCommit(boolean enableAutoCommit) throws AdbcException {
        try {
            this.connection.setAutoCommit(enableAutoCommit);
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public String getCurrentCatalog() throws AdbcException {
        try {
            return this.connection.getCatalog();
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public void setCurrentCatalog(String catalog) throws AdbcException {
        try {
            this.connection.setCatalog(catalog);
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public String getCurrentDbSchema() throws AdbcException {
        try {
            return this.connection.getSchema();
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public void setCurrentDbSchema(String dbSchema) throws AdbcException {
        try {
            this.connection.setSchema(dbSchema);
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public boolean getReadOnly() throws AdbcException {
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public void setReadOnly(boolean isReadOnly) throws AdbcException {
        try {
            this.connection.setReadOnly(isReadOnly);
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public IsolationLevel getIsolationLevel() throws AdbcException {
        try {
            int transactionIsolation = this.connection.getTransactionIsolation();
            switch (transactionIsolation) {
                case 0: {
                    return IsolationLevel.DEFAULT;
                }
                case 1: {
                    return IsolationLevel.READ_UNCOMMITTED;
                }
                case 2: {
                    return IsolationLevel.READ_COMMITTED;
                }
                case 4: {
                    return IsolationLevel.REPEATABLE_READ;
                }
                case 8: {
                    return IsolationLevel.SERIALIZABLE;
                }
            }
            throw AdbcException.notImplemented((String)JdbcDriverUtil.prefixExceptionMessage("JDBC isolation level not recognized: " + transactionIsolation));
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public void setIsolationLevel(IsolationLevel level) throws AdbcException {
        try {
            switch (level) {
                case READ_UNCOMMITTED: {
                    this.connection.setTransactionIsolation(1);
                    break;
                }
                case READ_COMMITTED: {
                    this.connection.setTransactionIsolation(2);
                    break;
                }
                case REPEATABLE_READ: {
                    this.connection.setTransactionIsolation(4);
                    break;
                }
                case SERIALIZABLE: {
                    this.connection.setTransactionIsolation(8);
                    break;
                }
                case DEFAULT: 
                case SNAPSHOT: 
                case LINEARIZABLE: {
                    throw AdbcException.notImplemented((String)JdbcDriverUtil.prefixExceptionMessage("Isolation level not supported: " + level));
                }
            }
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public void close() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.connection, this.allocator});
    }

    private void checkAutoCommit() throws AdbcException, SQLException {
        if (this.connection.getAutoCommit()) {
            throw AdbcException.invalidState((String)"[JDBC] Cannot perform operation in autocommit mode");
        }
    }

    public String toString() {
        return "JdbcConnection{connection=" + this.connection + "}";
    }

    static final class Statistic {
        String table;
        String column;
        short key;
        long value;
        boolean multiColumn = false;

        public Statistic(String table, String column) {
            this.table = table;
            this.column = column;
        }
    }
}

