/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.jdbc;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.arrow.adbc.core.AdbcDatabase;
import org.apache.arrow.adbc.core.AdbcDriver;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.driver.jdbc.JdbcDataSourceDatabase;
import org.apache.arrow.adbc.driver.jdbc.JdbcQuirks;
import org.apache.arrow.adbc.driver.jdbc.UrlDataSource;
import org.apache.arrow.adbc.sql.SqlQuirks;
import org.apache.arrow.memory.BufferAllocator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JdbcDriver
implements AdbcDriver {
    public static final String PARAM_DATASOURCE = "adbc.jdbc.datasource";
    public static final String PARAM_JDBC_QUIRKS = "adbc.jdbc.quirks";
    public static final String PARAM_URI = "uri";
    private final BufferAllocator allocator;

    public JdbcDriver(BufferAllocator allocator) {
        this.allocator = Objects.requireNonNull(allocator);
    }

    public AdbcDatabase open(Map<String, Object> parameters) throws AdbcException {
        DataSource dataSource = JdbcDriver.getParam(DataSource.class, parameters, PARAM_DATASOURCE);
        String target = JdbcDriver.getParam(String.class, parameters, PARAM_URI, "adbc.url");
        if (dataSource != null && target != null) {
            throw AdbcException.invalidArgument((String)"[JDBC] Provide at most one of uri and adbc.jdbc.datasource");
        }
        SqlQuirks quirks = JdbcDriver.getParam(SqlQuirks.class, parameters, "adbc.sql.quirks");
        JdbcQuirks jdbcQuirks = JdbcDriver.getParam(JdbcQuirks.class, parameters, PARAM_JDBC_QUIRKS);
        if (jdbcQuirks != null && quirks != null) {
            throw AdbcException.invalidArgument((String)"[JDBC] Provide at most one of adbc.sql.quirks and adbc.jdbc.quirks");
        }
        if (jdbcQuirks == null) {
            if (quirks == null) {
                quirks = new SqlQuirks();
            }
            jdbcQuirks = JdbcQuirks.builder("unknown").sqlQuirks(quirks).build();
        }
        String username = JdbcDriver.getParam(String.class, parameters, "username");
        String password = JdbcDriver.getParam(String.class, parameters, "password");
        if (username != null && password == null || username == null && password != null) {
            throw AdbcException.invalidArgument((String)"[JDBC] Must provide both or neither of username and password");
        }
        if (target != null) {
            dataSource = new UrlDataSource(target);
        }
        if (dataSource == null) {
            throw AdbcException.invalidArgument((String)"[JDBC] Must provide one of uri and adbc.jdbc.datasource options");
        }
        return new JdbcDataSourceDatabase(this.allocator, dataSource, username, password, jdbcQuirks);
    }

    private static <T> @Nullable T getParam(Class<T> klass, Map<String, Object> parameters, String ... choices) throws AdbcException {
        Object result = null;
        for (String choice : choices) {
            Object value = parameters.get(choice);
            if (value == null) continue;
            if (result != null) {
                throw AdbcException.invalidArgument((String)("[JDBC] Provide at most one of " + Arrays.toString(choices)));
            }
            result = value;
        }
        if (result == null) {
            return null;
        }
        try {
            return klass.cast(result);
        }
        catch (ClassCastException e) {
            throw AdbcException.invalidArgument((String)("[JDBC] " + Arrays.toString(choices) + " must be a " + klass + ", not a " + result.getClass()));
        }
    }
}

