/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.jdbc;

import java.util.Objects;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adbc.driver.jdbc.adapter.JdbcToArrowTypeConverter;
import org.apache.arrow.adbc.sql.SqlQuirks;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JdbcQuirks {
    final String backendName;
    JdbcToArrowTypeConverter typeConverter;
    @Nullable SqlQuirks sqlQuirks;

    public JdbcQuirks(String backendName) {
        this.backendName = Objects.requireNonNull(backendName);
        this.typeConverter = fieldInfo -> JdbcToArrowUtils.getArrowTypeFromJdbcType((JdbcFieldInfo)fieldInfo.getFieldInfo(), null);
    }

    public String getBackendName() {
        return this.backendName;
    }

    public JdbcToArrowTypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public @Nullable SqlQuirks getSqlQuirks() {
        return this.sqlQuirks;
    }

    public static Builder builder(String backendName) {
        return new Builder(backendName);
    }

    public String toString() {
        return "JdbcQuirks{" + this.backendName + "}";
    }

    public static final class Builder {
        final JdbcQuirks quirks;

        public Builder(String backendName) {
            this.quirks = new JdbcQuirks(backendName);
        }

        public Builder typeConverter(JdbcToArrowTypeConverter typeConverter) {
            this.quirks.typeConverter = Objects.requireNonNull(typeConverter);
            return this;
        }

        public Builder sqlQuirks(SqlQuirks sqlQuirks) {
            this.quirks.sqlQuirks = sqlQuirks;
            return this;
        }

        public JdbcQuirks build() {
            return this.quirks;
        }
    }
}

