/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Objects;
import java.util.stream.LongStream;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcParameterBinder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.core.AdbcStatement;
import org.apache.arrow.adbc.core.AdbcStatusCode;
import org.apache.arrow.adbc.core.BulkIngestMode;
import org.apache.arrow.adbc.driver.jdbc.JdbcArrowReader;
import org.apache.arrow.adbc.driver.jdbc.JdbcBindReader;
import org.apache.arrow.adbc.driver.jdbc.JdbcDriverUtil;
import org.apache.arrow.adbc.driver.jdbc.JdbcQuirks;
import org.apache.arrow.adbc.sql.SqlQuirks;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JdbcStatement
implements AdbcStatement {
    private final BufferAllocator allocator;
    private final Connection connection;
    private final JdbcQuirks quirks;
    private @Nullable Statement statement;
    private @Nullable String sqlQuery;
    private @Nullable ArrowReader reader;
    private @Nullable ResultSet resultSet;
    private @Nullable BulkState bulkOperation;
    private @Nullable VectorSchemaRoot bindRoot;

    JdbcStatement(BufferAllocator allocator, Connection connection, JdbcQuirks quirks) {
        this.allocator = allocator;
        this.connection = connection;
        this.quirks = quirks;
        this.sqlQuery = null;
    }

    static JdbcStatement ingestRoot(BufferAllocator allocator, Connection connection, JdbcQuirks quirks, String targetTableName, BulkIngestMode mode) {
        Objects.requireNonNull(targetTableName);
        JdbcStatement statement = new JdbcStatement(allocator, connection, quirks);
        statement.bulkOperation = new BulkState(mode, targetTableName);
        statement.bulkOperation.mode = mode;
        statement.bulkOperation.targetTable = targetTableName;
        return statement;
    }

    public void setSqlQuery(String query) throws AdbcException {
        if (this.bulkOperation != null) {
            throw AdbcException.invalidState((String)"[JDBC] Statement is configured for a bulk ingest/append operation");
        }
        this.sqlQuery = query;
    }

    public void bind(VectorSchemaRoot root) {
        this.bindRoot = root;
    }

    private void createBulkTable(BulkState bulkOperation, VectorSchemaRoot bindRoot) throws AdbcException {
        StringBuilder create = new StringBuilder("CREATE TABLE ");
        create.append(bulkOperation.targetTable);
        create.append(" (");
        for (int col = 0; col < bindRoot.getFieldVectors().size(); ++col) {
            if (col > 0) {
                create.append(", ");
            }
            Field field = bindRoot.getVector(col).getField();
            create.append(field.getName());
            create.append(' ');
            @Nullable SqlQuirks sqlQuirks = this.quirks.getSqlQuirks();
            if (sqlQuirks == null) {
                throw AdbcException.invalidState((String)JdbcDriverUtil.prefixExceptionMessage("Must create driver with SqlQuirks to use bulk ingestion"));
            }
            String typeName = (String)sqlQuirks.getArrowToSqlTypeNameMapping().apply(field.getType());
            if (typeName == null) {
                throw AdbcException.notImplemented((String)("[JDBC] Cannot generate CREATE TABLE statement for field " + field));
            }
            create.append(typeName);
        }
        create.append(")");
        try (Statement statement = this.connection.createStatement();){
            statement.execute(create.toString());
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(AdbcStatusCode.ALREADY_EXISTS, "Could not create table %s: ", e, bulkOperation.targetTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdbcStatement.UpdateResult executeBulk(BulkState bulkOperation) throws AdbcException {
        PreparedStatement statement;
        if (this.bindRoot == null) {
            throw AdbcException.invalidState((String)"[JDBC] Must call bind() before bulk insert");
        }
        VectorSchemaRoot bind = this.bindRoot;
        if (bulkOperation.mode == BulkIngestMode.CREATE) {
            this.createBulkTable(bulkOperation, bind);
        }
        StringBuilder insert = new StringBuilder("INSERT INTO ");
        insert.append(bulkOperation.targetTable);
        insert.append(" VALUES (");
        for (int col = 0; col < bind.getFieldVectors().size(); ++col) {
            if (col > 0) {
                insert.append(", ");
            }
            insert.append("?");
        }
        insert.append(")");
        try {
            statement = this.connection.prepareStatement(insert.toString());
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException("Could not bulk insert into table %s: ", e, bulkOperation.targetTable);
        }
        try {
            try {
                JdbcParameterBinder binder = JdbcParameterBinder.builder((PreparedStatement)statement, (VectorSchemaRoot)bind).bindAll().build();
                statement.clearBatch();
                while (binder.next()) {
                    statement.addBatch();
                }
                statement.executeBatch();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
        return new AdbcStatement.UpdateResult((long)bind.getRowCount());
    }

    private void invalidatePriorQuery() throws AdbcException {
        try {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    throw new AdbcException("[JDBC] Failed to close unread result set", (Throwable)e, AdbcStatusCode.IO, null, 0);
                }
                this.reader = null;
            }
            if (this.resultSet != null) {
                this.resultSet.close();
                this.resultSet = null;
            }
            if (!(this.statement instanceof PreparedStatement) && this.statement != null) {
                this.statement.close();
                this.statement = null;
            }
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public AdbcStatement.UpdateResult executeUpdate() throws AdbcException {
        if (this.bulkOperation != null) {
            return this.executeBulk(this.bulkOperation);
        }
        if (this.sqlQuery == null) {
            throw AdbcException.invalidState((String)"[JDBC] Must setSqlQuery() first");
        }
        String query = this.sqlQuery;
        long affectedRows = 0L;
        try {
            this.invalidatePriorQuery();
            if (this.statement instanceof PreparedStatement) {
                PreparedStatement preparedStatement = (PreparedStatement)this.statement;
                if (this.bindRoot != null) {
                    JdbcParameterBinder binder = JdbcParameterBinder.builder((PreparedStatement)preparedStatement, (VectorSchemaRoot)this.bindRoot).bindAll().build();
                    preparedStatement.clearBatch();
                    while (binder.next()) {
                        preparedStatement.addBatch();
                    }
                    affectedRows = LongStream.of(preparedStatement.executeLargeBatch()).sum();
                } else {
                    affectedRows = preparedStatement.executeUpdate();
                }
            } else {
                this.statement = this.connection.createStatement(1004, 1007);
                affectedRows = this.statement.executeUpdate(query);
            }
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
        return new AdbcStatement.UpdateResult(affectedRows);
    }

    public AdbcStatement.QueryResult executeQuery() throws AdbcException {
        if (this.bulkOperation != null) {
            throw AdbcException.invalidState((String)"[JDBC] Call executeUpdate() for bulk operations");
        }
        if (this.sqlQuery == null) {
            throw AdbcException.invalidState((String)"[JDBC] Must setSqlQuery() first");
        }
        String query = this.sqlQuery;
        try {
            this.invalidatePriorQuery();
            if (this.statement instanceof PreparedStatement) {
                PreparedStatement preparedStatement = (PreparedStatement)this.statement;
                if (this.bindRoot != null) {
                    this.reader = new JdbcBindReader(this.allocator, preparedStatement, this.bindRoot);
                } else {
                    this.resultSet = preparedStatement.executeQuery();
                    this.reader = new JdbcArrowReader(this.allocator, this.resultSet, null);
                }
            } else {
                this.statement = this.connection.createStatement(1004, 1007);
                this.resultSet = this.statement.executeQuery(query);
                this.reader = new JdbcArrowReader(this.allocator, this.resultSet, null);
            }
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
        return new AdbcStatement.QueryResult(-1L, this.reader);
    }

    public Schema executeSchema() throws AdbcException {
        if (this.bulkOperation != null) {
            throw AdbcException.invalidState((String)"[JDBC] Call executeUpdate() for bulk operations");
        }
        if (this.sqlQuery == null) {
            throw AdbcException.invalidState((String)"[JDBC] Must setSqlQuery() first");
        }
        String query = this.sqlQuery;
        try {
            PreparedStatement ownedStatement;
            PreparedStatement preparedStatement;
            this.invalidatePriorQuery();
            if (this.statement instanceof PreparedStatement) {
                preparedStatement = (PreparedStatement)this.statement;
                if (this.bindRoot != null) {
                    JdbcParameterBinder.builder((PreparedStatement)preparedStatement, (VectorSchemaRoot)this.bindRoot).bindAll().build().next();
                }
                ownedStatement = null;
            } else {
                ownedStatement = preparedStatement = this.connection.prepareStatement(query);
            }
            JdbcToArrowConfig config = JdbcArrowReader.makeJdbcConfig(this.allocator);
            @Nullable ResultSetMetaData rsmd = preparedStatement.getMetaData();
            if (rsmd == null) {
                throw new AdbcException(JdbcDriverUtil.prefixExceptionMessage("JDBC driver returned null ResultSetMetaData"), null, AdbcStatusCode.INTERNAL, null, 0);
            }
            Schema schema = JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)rsmd, (JdbcToArrowConfig)config);
            if (ownedStatement != null) {
                ownedStatement.close();
            }
            return schema;
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public Schema getParameterSchema() throws AdbcException {
        if (this.statement instanceof PreparedStatement) {
            PreparedStatement preparedStatement = (PreparedStatement)this.statement;
            try {
                ParameterMetaData md = preparedStatement.getParameterMetaData();
                ArrayList<Field> fields = new ArrayList<Field>(md.getParameterCount());
                for (int i = 0; i < md.getParameterCount(); ++i) {
                    int paramIndex = i + 1;
                    JdbcFieldInfo fieldInfo = new JdbcFieldInfo(md.getParameterType(paramIndex), md.getPrecision(paramIndex), md.getScale(paramIndex));
                    ArrowType arrowType = JdbcToArrowUtils.getArrowTypeFromJdbcType((JdbcFieldInfo)fieldInfo, (Calendar)JdbcToArrowUtils.getUtcCalendar());
                    fields.add(Field.nullable((String)"", (ArrowType)arrowType));
                }
                return new Schema(fields);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        throw AdbcException.invalidState((String)"[JDBC] Must prepare() before getParameterSchema()");
    }

    public void prepare() throws AdbcException {
        try {
            if (this.sqlQuery == null) {
                throw AdbcException.invalidArgument((String)"[JDBC] Must setSqlQuery(String) before prepare()");
            }
            String query = this.sqlQuery;
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            this.statement = this.connection.prepareStatement(query, 1004, 1007);
        }
        catch (SQLException e) {
            throw JdbcDriverUtil.fromSqlException(e);
        }
    }

    public void close() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.reader, this.resultSet, this.statement});
    }

    private static final class BulkState {
        BulkIngestMode mode;
        String targetTable;

        BulkState(BulkIngestMode mode, String targetTable) {
            this.mode = mode;
            this.targetTable = targetTable;
        }
    }
}

