/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.jdbc;

import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.arrow.adbc.core.AdbcConnection;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.core.AdbcStatusCode;
import org.apache.arrow.adbc.core.StandardSchemas;
import org.apache.arrow.adbc.driver.jdbc.JdbcDriverUtil;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.VarCharWriter;
import org.apache.arrow.vector.types.pojo.Schema;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ObjectMetadataBuilder
implements AutoCloseable {
    private final AdbcConnection.GetObjectsDepth depth;
    private final Predicate<String> catalogPattern;
    private final String dbSchemaPattern;
    private final String tableNamePattern;
    private final String[] tableTypesFilter;
    private final String columnNamePattern;
    private final DatabaseMetaData dbmd;
    private VectorSchemaRoot root;
    final VarCharVector catalogNames;
    final ListVector catalogDbSchemas;
    final StructVector dbSchemas;
    final VarCharVector dbSchemaNames;
    final ListVector dbSchemaTables;
    final StructVector tables;
    final VarCharVector tableNames;
    final VarCharVector tableTypes;
    final ListVector tableColumns;
    final StructVector columns;
    final VarCharVector columnNames;
    final IntVector columnOrdinalPositions;
    final VarCharVector columnRemarks;
    final SmallIntVector columnXdbcDataTypes;
    final ListVector tableConstraints;
    final UnionListWriter tableConstraintsWriter;
    final BaseWriter.StructWriter tableConstraintsStructWriter;
    final VarCharWriter constraintNamesWriter;
    final VarCharWriter constraintTypesWriter;
    final BaseWriter.ListWriter constraintColumnNamesWriter;
    final BaseWriter.ListWriter constraintColumnUsageWriter;
    final BaseWriter.StructWriter constraintColumnUsageStructWriter;
    final VarCharWriter constraintColumnUsageFkCatalogsWriter;
    final VarCharWriter constraintColumnUsageFkDbSchemasWriter;
    final VarCharWriter constraintColumnUsageFkTablesWriter;
    final VarCharWriter constraintColumnUsageFkColumnsWriter;
    final BufferAllocator allocator;

    ObjectMetadataBuilder(BufferAllocator allocator, Connection connection, AdbcConnection.GetObjectsDepth depth, String catalogPattern, String dbSchemaPattern, String tableNamePattern, String[] tableTypesFilter, String columnNamePattern) throws SQLException {
        this.allocator = allocator;
        this.depth = depth;
        if (catalogPattern == null) {
            this.catalogPattern = ignored -> true;
        } else {
            Pattern pattern = Pattern.compile(ObjectMetadataBuilder.translatePattern(catalogPattern));
            this.catalogPattern = catalog -> pattern.matcher((CharSequence)catalog).matches();
        }
        this.dbSchemaPattern = dbSchemaPattern;
        this.tableNamePattern = tableNamePattern;
        this.tableTypesFilter = tableTypesFilter;
        this.columnNamePattern = columnNamePattern;
        this.root = VectorSchemaRoot.create((Schema)StandardSchemas.GET_OBJECTS_SCHEMA, (BufferAllocator)allocator);
        this.dbmd = connection.getMetaData();
        this.catalogNames = (VarCharVector)this.root.getVector(0);
        this.catalogDbSchemas = (ListVector)this.root.getVector(1);
        this.dbSchemas = (StructVector)this.catalogDbSchemas.getDataVector();
        this.dbSchemaNames = (VarCharVector)this.dbSchemas.getVectorById(0);
        this.dbSchemaTables = (ListVector)this.dbSchemas.getVectorById(1);
        this.tables = (StructVector)this.dbSchemaTables.getDataVector();
        this.tableNames = (VarCharVector)this.tables.getVectorById(0);
        this.tableTypes = (VarCharVector)this.tables.getVectorById(1);
        this.tableColumns = (ListVector)this.tables.getVectorById(2);
        this.columns = (StructVector)this.tableColumns.getDataVector();
        this.columnNames = (VarCharVector)this.columns.getVectorById(0);
        this.columnOrdinalPositions = (IntVector)this.columns.getVectorById(1);
        this.columnRemarks = (VarCharVector)this.columns.getVectorById(2);
        this.columnXdbcDataTypes = (SmallIntVector)this.columns.getVectorById(3);
        this.tableConstraints = (ListVector)this.tables.getVectorById(3);
        this.tableConstraintsWriter = this.tableConstraints.getWriter();
        this.tableConstraintsStructWriter = this.tableConstraintsWriter.struct();
        this.constraintNamesWriter = this.tableConstraintsWriter.varChar("constraint_name");
        this.constraintTypesWriter = this.tableConstraintsWriter.varChar("constraint_type");
        this.constraintColumnNamesWriter = this.tableConstraintsWriter.list("constraint_column_names");
        this.constraintColumnUsageWriter = this.tableConstraintsWriter.list("constraint_column_usage");
        this.constraintColumnUsageStructWriter = this.constraintColumnUsageWriter.struct();
        this.constraintColumnUsageFkCatalogsWriter = this.constraintColumnUsageStructWriter.varChar("fk_catalog");
        this.constraintColumnUsageFkDbSchemasWriter = this.constraintColumnUsageStructWriter.varChar("fk_db_schema");
        this.constraintColumnUsageFkTablesWriter = this.constraintColumnUsageStructWriter.varChar("fk_table");
        this.constraintColumnUsageFkColumnsWriter = this.constraintColumnUsageStructWriter.varChar("fk_column_name");
    }

    VectorSchemaRoot build() throws AdbcException, SQLException {
        try (ResultSet rs = this.dbmd.getCatalogs();){
            int catalogCount = 0;
            while (rs.next()) {
                String catalogName = rs.getString(1);
                if (catalogName == null) {
                    throw new AdbcException(JdbcDriverUtil.prefixExceptionMessage("JDBC driver returned null catalog name"), null, AdbcStatusCode.INVALID_DATA, null, 0);
                }
                if (!this.catalogPattern.test(catalogName)) continue;
                this.addCatalogRow(catalogCount, catalogName);
                ++catalogCount;
            }
            if (this.catalogPattern.test("") && catalogCount == 0) {
                this.addCatalogRow(catalogCount, "");
                ++catalogCount;
            }
            this.root.setRowCount(catalogCount);
        }
        VectorSchemaRoot result = this.root;
        try {
            this.root = VectorSchemaRoot.create((Schema)StandardSchemas.GET_OBJECTS_SCHEMA, (BufferAllocator)this.allocator);
        }
        catch (RuntimeException e) {
            result.close();
            throw e;
        }
        return result;
    }

    private void addCatalogRow(int rowIndex, String catalogName) throws AdbcException, SQLException {
        this.catalogNames.setSafe(rowIndex, catalogName.getBytes(StandardCharsets.UTF_8));
        if (this.depth == AdbcConnection.GetObjectsDepth.CATALOGS) {
            this.catalogDbSchemas.setNull(rowIndex);
        } else {
            int dbSchemasBaseIndex = this.catalogDbSchemas.startNewValue(rowIndex);
            int dbSchemaCount = this.buildDbSchemas(dbSchemasBaseIndex, catalogName);
            this.catalogDbSchemas.endValue(rowIndex, dbSchemaCount);
        }
    }

    private int buildDbSchemas(int rowIndex, String catalogName) throws AdbcException, SQLException {
        int dbSchemaCount = 0;
        try (ResultSet rs = this.dbmd.getSchemas(catalogName, this.dbSchemaPattern);){
            while (rs.next()) {
                String dbSchemaName = rs.getString(1);
                if (dbSchemaName == null) {
                    throw new AdbcException(JdbcDriverUtil.prefixExceptionMessage("JDBC driver returned null schema name"), null, AdbcStatusCode.INVALID_DATA, null, 0);
                }
                this.addDbSchemaRow(rowIndex + dbSchemaCount, catalogName, dbSchemaName);
                ++dbSchemaCount;
            }
        }
        return dbSchemaCount;
    }

    private void addDbSchemaRow(int rowIndex, String catalogName, String dbSchemaName) throws AdbcException, SQLException {
        this.dbSchemas.setIndexDefined(rowIndex);
        this.dbSchemaNames.setSafe(rowIndex, dbSchemaName.getBytes(StandardCharsets.UTF_8));
        if (this.depth == AdbcConnection.GetObjectsDepth.DB_SCHEMAS) {
            this.dbSchemaTables.setNull(rowIndex);
        } else {
            int tableBaseIndex = this.dbSchemaTables.startNewValue(rowIndex);
            int tableCount = this.buildTables(tableBaseIndex, catalogName, dbSchemaName);
            this.dbSchemaTables.endValue(rowIndex, tableCount);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private int buildTables(int rowIndex, String catalogName, String dbSchemaName) throws AdbcException, SQLException {
        int tableCount = 0;
        try (ResultSet rs = this.dbmd.getTables(catalogName, dbSchemaName, this.tableNamePattern, this.tableTypesFilter);){
            while (rs.next()) {
                int columnIndex;
                String columnName;
                @Nullable String tableName = rs.getString(3);
                @Nullable String tableType = rs.getString(4);
                if (tableName == null || tableType == null) {
                    throw new AdbcException(JdbcDriverUtil.prefixExceptionMessage("JDBC driver returned null table name/type"), null, AdbcStatusCode.INTERNAL, null, 0);
                }
                this.tables.setIndexDefined(rowIndex + tableCount);
                this.tableNames.setSafe(rowIndex + tableCount, tableName.getBytes(StandardCharsets.UTF_8));
                this.tableTypes.setSafe(rowIndex + tableCount, tableType.getBytes(StandardCharsets.UTF_8));
                this.tableConstraintsWriter.setPosition(rowIndex + tableCount);
                this.tableConstraintsWriter.startList();
                try (ResultSet pk = this.dbmd.getPrimaryKeys(catalogName, dbSchemaName, tableName);){
                    String constraintName = null;
                    ArrayList<@Nullable String> constraintColumns = new ArrayList<String>();
                    while (pk.next()) {
                        constraintName = pk.getString(6);
                        columnName = pk.getString(4);
                        columnIndex = pk.getInt(5);
                        while (constraintColumns.size() < columnIndex) {
                            constraintColumns.add(null);
                        }
                        constraintColumns.set(columnIndex - 1, columnName);
                    }
                    if (!constraintColumns.isEmpty()) {
                        this.addConstraint(constraintName, "PRIMARY KEY", constraintColumns, Collections.emptyList());
                    }
                }
                try (ResultSet fk = this.dbmd.getImportedKeys(catalogName, dbSchemaName, tableName);){
                    ArrayList<@Nullable String> names = new ArrayList<String>();
                    ArrayList<ArrayList<@Nullable E>> columns2 = new ArrayList();
                    ArrayList references = new ArrayList();
                    while (fk.next()) {
                        String keyName = fk.getString(12);
                        String keyColumn = fk.getString(8);
                        int keySeq = fk.getInt(9);
                        if (keySeq == 1) {
                            names.add(keyName);
                            columns2.add(new ArrayList());
                            references.add(new ArrayList());
                        }
                        ((List)columns2.get(columns2.size() - 1)).add(keyColumn);
                        @Nullable String fkTableName = fk.getString(3);
                        @Nullable String fkColumnName = fk.getString(4);
                        if (fkTableName == null || fkColumnName == null) {
                            throw new AdbcException(JdbcDriverUtil.prefixExceptionMessage("JDBC driver returned null table/column name"), null, AdbcStatusCode.INTERNAL, null, 0);
                        }
                        ReferencedColumn reference = new ReferencedColumn(fk.getString(1), fk.getString(2), fkTableName, fkColumnName);
                        ((List)references.get(references.size() - 1)).add(reference);
                    }
                    for (int i = 0; i < names.size(); ++i) {
                        this.addConstraint((String)names.get(i), "FOREIGN KEY", (List)columns2.get(i), (List)references.get(i));
                    }
                }
                try (ResultSet uq = this.dbmd.getIndexInfo(catalogName, dbSchemaName, tableName, true, false);){
                    HashMap<String, @Nullable ArrayList> uniqueConstraints = new HashMap<String, ArrayList>();
                    while (uq.next()) {
                        @Nullable String constraintName = uq.getString(6);
                        columnName = uq.getString(9);
                        columnIndex = uq.getInt(8);
                        if (constraintName == null || columnName == null) {
                            throw new AdbcException(JdbcDriverUtil.prefixExceptionMessage("JDBC driver returned null constraint/column name"), null, AdbcStatusCode.INTERNAL, null, 0);
                        }
                        if (!uniqueConstraints.containsKey(constraintName)) {
                            uniqueConstraints.put(constraintName, new ArrayList());
                        }
                        @Nullable ArrayList uniqueColumns = (ArrayList)uniqueConstraints.get(constraintName);
                        while (uniqueColumns.size() < columnIndex) {
                            uniqueColumns.add(null);
                        }
                        uniqueColumns.set(columnIndex - 1, columnName);
                    }
                    uniqueConstraints.forEach((name, columns) -> this.addConstraint((String)name, "UNIQUE", (List<String>)columns, Collections.emptyList()));
                }
                this.tableConstraintsWriter.endList();
                if (this.depth == AdbcConnection.GetObjectsDepth.TABLES) {
                    this.tableColumns.setNull(rowIndex + tableCount);
                } else {
                    int columnBaseIndex = this.tableColumns.startNewValue(rowIndex + tableCount);
                    int columnCount = this.buildColumns(columnBaseIndex, catalogName, dbSchemaName, tableName);
                    this.tableColumns.endValue(rowIndex + tableCount, columnCount);
                }
                ++tableCount;
            }
        }
        return tableCount;
    }

    private int buildColumns(int rowIndex, String catalogName, String dbSchemaName, String tableName) throws AdbcException, SQLException {
        int columnCount = 0;
        try (ResultSet rs = this.dbmd.getColumns(catalogName, dbSchemaName, tableName, this.columnNamePattern);){
            while (rs.next()) {
                @Nullable String columnName = rs.getString(4);
                if (columnName == null) {
                    throw new AdbcException(JdbcDriverUtil.prefixExceptionMessage("JDBC driver returned null column name"), null, AdbcStatusCode.INTERNAL, null, 0);
                }
                int ordinalPosition = rs.getInt(17);
                @Nullable String remarks = rs.getString(12);
                int xdbcDataType = rs.getInt(5);
                this.columns.setIndexDefined(rowIndex + columnCount);
                this.columnNames.setSafe(rowIndex + columnCount, columnName.getBytes(StandardCharsets.UTF_8));
                this.columnOrdinalPositions.setSafe(rowIndex + columnCount, ordinalPosition);
                if (remarks != null) {
                    this.columnRemarks.setSafe(rowIndex + columnCount, remarks.getBytes(StandardCharsets.UTF_8));
                }
                this.columnXdbcDataTypes.setSafe(rowIndex + columnCount, xdbcDataType);
                ++columnCount;
            }
        }
        return columnCount;
    }

    private void addConstraint(@Nullable String constraintName, String constraintType, List<@Nullable String> constraintColumns, List<ReferencedColumn> referencedColumns) {
        this.tableConstraintsStructWriter.start();
        if (constraintName == null) {
            this.constraintNamesWriter.writeNull();
        } else {
            this.constraintNamesWriter.writeVarChar(constraintName);
        }
        this.constraintTypesWriter.writeVarChar(constraintType);
        this.constraintColumnNamesWriter.startList();
        for (String constraintColumn : constraintColumns) {
            VarCharWriter writer = this.constraintColumnNamesWriter.varChar();
            if (constraintColumn == null) {
                writer.writeNull();
                continue;
            }
            writer.writeVarChar(constraintColumn);
        }
        this.constraintColumnNamesWriter.endList();
        this.constraintColumnUsageWriter.startList();
        for (ReferencedColumn referencedColumn : referencedColumns) {
            this.constraintColumnUsageStructWriter.start();
            if (referencedColumn.catalog != null) {
                this.constraintColumnUsageFkCatalogsWriter.writeVarChar(referencedColumn.catalog);
            } else {
                this.constraintColumnUsageFkCatalogsWriter.writeNull();
            }
            if (referencedColumn.dbSchema != null) {
                this.constraintColumnUsageFkDbSchemasWriter.writeVarChar(referencedColumn.dbSchema);
            } else {
                this.constraintColumnUsageFkDbSchemasWriter.writeNull();
            }
            this.constraintColumnUsageFkTablesWriter.writeVarChar(referencedColumn.table);
            this.constraintColumnUsageFkColumnsWriter.writeVarChar(referencedColumn.column);
            this.constraintColumnUsageStructWriter.end();
        }
        this.constraintColumnUsageWriter.endList();
        this.tableConstraintsStructWriter.end();
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.root});
    }

    static String translatePattern(String filter) {
        StringBuilder builder = new StringBuilder(filter.length());
        builder.append("^");
        for (char c : filter.toCharArray()) {
            if (c == '%') {
                builder.append(".*");
                continue;
            }
            if (c == '_') {
                builder.append(".");
                continue;
            }
            builder.append(Pattern.quote(String.valueOf(c)));
        }
        builder.append("$");
        return builder.toString();
    }

    static class ReferencedColumn {
        @Nullable String catalog;
        @Nullable String dbSchema;
        String table;
        String column;

        public ReferencedColumn(@Nullable String catalog, @Nullable String dbSchema, String table, String column) throws AdbcException {
            this.catalog = catalog;
            this.dbSchema = dbSchema;
            if (table == null || column == null) {
                throw new AdbcException(JdbcDriverUtil.prefixExceptionMessage("JDBC driver returned null table/column name"), null, AdbcStatusCode.INTERNAL, null, 0);
            }
            this.table = table;
            this.column = column;
        }
    }
}

