/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.jdbc.adapter;

import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adbc.driver.jdbc.adapter.JdbcFieldInfoExtra;
import org.apache.arrow.adbc.driver.jdbc.adapter.JdbcToArrowTypeConverter;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;

public final class JdbcToArrowTypeConverters {
    public static final JdbcToArrowTypeConverter MICROSOFT_SQL_SERVER = JdbcToArrowTypeConverters::mssql;
    public static final JdbcToArrowTypeConverter POSTGRESQL = JdbcToArrowTypeConverters::postgresql;
    private static final int MS_SQL_TYPE_DATETIMEOFFSET = -155;

    private static ArrowType mssql(JdbcFieldInfoExtra field) {
        switch (field.getJdbcType()) {
            case 92: {
                return Types.MinorType.TIMENANO.getType();
            }
            case 93: {
                return Types.MinorType.TIMESTAMPNANO.getType();
            }
            case -155: {
                return new ArrowType.Timestamp(TimeUnit.NANOSECOND, "UTC");
            }
        }
        return JdbcToArrowUtils.getArrowTypeFromJdbcType((JdbcFieldInfo)field.getFieldInfo(), null);
    }

    private static ArrowType postgresql(JdbcFieldInfoExtra field) {
        switch (field.getJdbcType()) {
            case 92: {
                return Types.MinorType.TIMEMICRO.getType();
            }
            case 93: {
                TimeUnit unit;
                int decimalDigits = field.getScale();
                if (decimalDigits == 0) {
                    unit = TimeUnit.SECOND;
                } else if (decimalDigits > 0 && decimalDigits <= 3) {
                    unit = TimeUnit.MILLISECOND;
                } else if (decimalDigits > 0 && decimalDigits <= 6) {
                    unit = TimeUnit.MICROSECOND;
                } else if (decimalDigits > 6) {
                    unit = TimeUnit.NANOSECOND;
                } else {
                    throw new UnsupportedOperationException("Cannot convert type to Arrow Timestamp (precision is negative)");
                }
                if ("timestamptz".equals(field.getTypeName())) {
                    return new ArrowType.Timestamp(unit, "UTC");
                }
                if ("timestamp".equals(field.getTypeName())) {
                    return new ArrowType.Timestamp(unit, null);
                }
                throw new UnsupportedOperationException("Cannot convert type to Arrow Timestamp");
            }
        }
        return JdbcToArrowUtils.getArrowTypeFromJdbcType((JdbcFieldInfo)field.getFieldInfo(), null);
    }
}

