/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.IntVector;

class OffHeapIntStack
implements AutoCloseable {
    private static final int INIT_SIZE = 128;
    private IntVector intVector;
    private int top = 0;

    public OffHeapIntStack(BufferAllocator allocator) {
        this.intVector = new IntVector("int stack inner vector", allocator);
        this.intVector.allocateNew(128);
        this.intVector.setValueCount(128);
    }

    public void push(int value) {
        if (this.top == this.intVector.getValueCount()) {
            int targetCapacity = this.intVector.getValueCount() * 2;
            while (this.intVector.getValueCapacity() < targetCapacity) {
                this.intVector.reAlloc();
            }
            this.intVector.setValueCount(targetCapacity);
        }
        this.intVector.set(this.top++, value);
    }

    public int pop() {
        return this.intVector.get(--this.top);
    }

    public int getTop() {
        return this.intVector.get(this.top - 1);
    }

    public boolean isEmpty() {
        return this.top == 0;
    }

    public int getCount() {
        return this.top;
    }

    @Override
    public void close() {
        this.intVector.close();
    }
}

