/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.arrow.c.BaseStruct;
import org.apache.arrow.c.jni.JniWrapper;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.arrow.memory.util.MemoryUtil;
import org.apache.arrow.util.Preconditions;

public class ArrowSchema
implements BaseStruct {
    private static final int SIZE_OF = 72;
    private static final int INDEX_RELEASE_CALLBACK = 56;
    private ArrowBuf data;

    public static ArrowSchema wrap(long memoryAddress) {
        return new ArrowSchema(new ArrowBuf(ReferenceManager.NO_OP, null, 72L, memoryAddress));
    }

    public static ArrowSchema allocateNew(BufferAllocator allocator) {
        ArrowSchema schema = new ArrowSchema(allocator.buffer(72L));
        schema.markReleased();
        return schema;
    }

    ArrowSchema(ArrowBuf data) {
        Preconditions.checkNotNull((Object)data, (Object)"ArrowSchema initialized with a null buffer");
        this.data = data;
    }

    public void markReleased() {
        this.directBuffer().putLong(56, 0L);
    }

    @Override
    public long memoryAddress() {
        Preconditions.checkNotNull((Object)this.data, (Object)"ArrowSchema is already closed");
        return this.data.memoryAddress();
    }

    @Override
    public void release() {
        long address = this.memoryAddress();
        JniWrapper.get().releaseSchema(address);
    }

    @Override
    public void close() {
        if (this.data != null) {
            this.data.close();
            this.data = null;
        }
    }

    private ByteBuffer directBuffer() {
        return MemoryUtil.directBuffer((long)this.memoryAddress(), (int)72).order(ByteOrder.nativeOrder());
    }

    public Snapshot snapshot() {
        ByteBuffer data = this.directBuffer();
        Snapshot snapshot = new Snapshot();
        snapshot.format = data.getLong();
        snapshot.name = data.getLong();
        snapshot.metadata = data.getLong();
        snapshot.flags = data.getLong();
        snapshot.n_children = data.getLong();
        snapshot.children = data.getLong();
        snapshot.dictionary = data.getLong();
        snapshot.release = data.getLong();
        snapshot.private_data = data.getLong();
        return snapshot;
    }

    public void save(Snapshot snapshot) {
        this.directBuffer().putLong(snapshot.format).putLong(snapshot.name).putLong(snapshot.metadata).putLong(snapshot.flags).putLong(snapshot.n_children).putLong(snapshot.children).putLong(snapshot.dictionary).putLong(snapshot.release).putLong(snapshot.private_data);
    }

    public static class Snapshot {
        public long format = 0L;
        public long name = 0L;
        public long metadata = 0L;
        public long flags = 0L;
        public long n_children = 0L;
        public long children = 0L;
        public long dictionary = 0L;
        public long release = 0L;
        public long private_data = 0L;
    }
}

