package org.apache.arrow.flight.impl;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * A flight service is an endpoint for retrieving or storing Arrow data. A
 * flight service can expose one or more predefined endpoints that can be
 * accessed using the Arrow Flight Protocol. Additionally, a flight service
 * can expose a set of actions that are available.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.14.0)",
    comments = "Source: Flight.proto")
public final class FlightServiceGrpc {

  private FlightServiceGrpc() {}

  public static final String SERVICE_NAME = "arrow.flight.protocol.FlightService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.HandshakeRequest,
      org.apache.arrow.flight.impl.Flight.HandshakeResponse> getHandshakeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Handshake",
      requestType = org.apache.arrow.flight.impl.Flight.HandshakeRequest.class,
      responseType = org.apache.arrow.flight.impl.Flight.HandshakeResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
  public static io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.HandshakeRequest,
      org.apache.arrow.flight.impl.Flight.HandshakeResponse> getHandshakeMethod() {
    io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.HandshakeRequest, org.apache.arrow.flight.impl.Flight.HandshakeResponse> getHandshakeMethod;
    if ((getHandshakeMethod = FlightServiceGrpc.getHandshakeMethod) == null) {
      synchronized (FlightServiceGrpc.class) {
        if ((getHandshakeMethod = FlightServiceGrpc.getHandshakeMethod) == null) {
          FlightServiceGrpc.getHandshakeMethod = getHandshakeMethod = 
              io.grpc.MethodDescriptor.<org.apache.arrow.flight.impl.Flight.HandshakeRequest, org.apache.arrow.flight.impl.Flight.HandshakeResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "arrow.flight.protocol.FlightService", "Handshake"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.HandshakeRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.HandshakeResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new FlightServiceMethodDescriptorSupplier("Handshake"))
                  .build();
          }
        }
     }
     return getHandshakeMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.Criteria,
      org.apache.arrow.flight.impl.Flight.FlightGetInfo> getListFlightsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListFlights",
      requestType = org.apache.arrow.flight.impl.Flight.Criteria.class,
      responseType = org.apache.arrow.flight.impl.Flight.FlightGetInfo.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.Criteria,
      org.apache.arrow.flight.impl.Flight.FlightGetInfo> getListFlightsMethod() {
    io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.Criteria, org.apache.arrow.flight.impl.Flight.FlightGetInfo> getListFlightsMethod;
    if ((getListFlightsMethod = FlightServiceGrpc.getListFlightsMethod) == null) {
      synchronized (FlightServiceGrpc.class) {
        if ((getListFlightsMethod = FlightServiceGrpc.getListFlightsMethod) == null) {
          FlightServiceGrpc.getListFlightsMethod = getListFlightsMethod = 
              io.grpc.MethodDescriptor.<org.apache.arrow.flight.impl.Flight.Criteria, org.apache.arrow.flight.impl.Flight.FlightGetInfo>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "arrow.flight.protocol.FlightService", "ListFlights"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.Criteria.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.FlightGetInfo.getDefaultInstance()))
                  .setSchemaDescriptor(new FlightServiceMethodDescriptorSupplier("ListFlights"))
                  .build();
          }
        }
     }
     return getListFlightsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightDescriptor,
      org.apache.arrow.flight.impl.Flight.FlightGetInfo> getGetFlightInfoMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetFlightInfo",
      requestType = org.apache.arrow.flight.impl.Flight.FlightDescriptor.class,
      responseType = org.apache.arrow.flight.impl.Flight.FlightGetInfo.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightDescriptor,
      org.apache.arrow.flight.impl.Flight.FlightGetInfo> getGetFlightInfoMethod() {
    io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightDescriptor, org.apache.arrow.flight.impl.Flight.FlightGetInfo> getGetFlightInfoMethod;
    if ((getGetFlightInfoMethod = FlightServiceGrpc.getGetFlightInfoMethod) == null) {
      synchronized (FlightServiceGrpc.class) {
        if ((getGetFlightInfoMethod = FlightServiceGrpc.getGetFlightInfoMethod) == null) {
          FlightServiceGrpc.getGetFlightInfoMethod = getGetFlightInfoMethod = 
              io.grpc.MethodDescriptor.<org.apache.arrow.flight.impl.Flight.FlightDescriptor, org.apache.arrow.flight.impl.Flight.FlightGetInfo>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "arrow.flight.protocol.FlightService", "GetFlightInfo"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.FlightDescriptor.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.FlightGetInfo.getDefaultInstance()))
                  .setSchemaDescriptor(new FlightServiceMethodDescriptorSupplier("GetFlightInfo"))
                  .build();
          }
        }
     }
     return getGetFlightInfoMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.Ticket,
      org.apache.arrow.flight.impl.Flight.FlightData> getDoGetMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DoGet",
      requestType = org.apache.arrow.flight.impl.Flight.Ticket.class,
      responseType = org.apache.arrow.flight.impl.Flight.FlightData.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.Ticket,
      org.apache.arrow.flight.impl.Flight.FlightData> getDoGetMethod() {
    io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.Ticket, org.apache.arrow.flight.impl.Flight.FlightData> getDoGetMethod;
    if ((getDoGetMethod = FlightServiceGrpc.getDoGetMethod) == null) {
      synchronized (FlightServiceGrpc.class) {
        if ((getDoGetMethod = FlightServiceGrpc.getDoGetMethod) == null) {
          FlightServiceGrpc.getDoGetMethod = getDoGetMethod = 
              io.grpc.MethodDescriptor.<org.apache.arrow.flight.impl.Flight.Ticket, org.apache.arrow.flight.impl.Flight.FlightData>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "arrow.flight.protocol.FlightService", "DoGet"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.Ticket.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.FlightData.getDefaultInstance()))
                  .setSchemaDescriptor(new FlightServiceMethodDescriptorSupplier("DoGet"))
                  .build();
          }
        }
     }
     return getDoGetMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightData,
      org.apache.arrow.flight.impl.Flight.PutResult> getDoPutMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DoPut",
      requestType = org.apache.arrow.flight.impl.Flight.FlightData.class,
      responseType = org.apache.arrow.flight.impl.Flight.PutResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.CLIENT_STREAMING)
  public static io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightData,
      org.apache.arrow.flight.impl.Flight.PutResult> getDoPutMethod() {
    io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightData, org.apache.arrow.flight.impl.Flight.PutResult> getDoPutMethod;
    if ((getDoPutMethod = FlightServiceGrpc.getDoPutMethod) == null) {
      synchronized (FlightServiceGrpc.class) {
        if ((getDoPutMethod = FlightServiceGrpc.getDoPutMethod) == null) {
          FlightServiceGrpc.getDoPutMethod = getDoPutMethod = 
              io.grpc.MethodDescriptor.<org.apache.arrow.flight.impl.Flight.FlightData, org.apache.arrow.flight.impl.Flight.PutResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.CLIENT_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "arrow.flight.protocol.FlightService", "DoPut"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.FlightData.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.PutResult.getDefaultInstance()))
                  .setSchemaDescriptor(new FlightServiceMethodDescriptorSupplier("DoPut"))
                  .build();
          }
        }
     }
     return getDoPutMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.Action,
      org.apache.arrow.flight.impl.Flight.Result> getDoActionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DoAction",
      requestType = org.apache.arrow.flight.impl.Flight.Action.class,
      responseType = org.apache.arrow.flight.impl.Flight.Result.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.Action,
      org.apache.arrow.flight.impl.Flight.Result> getDoActionMethod() {
    io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.Action, org.apache.arrow.flight.impl.Flight.Result> getDoActionMethod;
    if ((getDoActionMethod = FlightServiceGrpc.getDoActionMethod) == null) {
      synchronized (FlightServiceGrpc.class) {
        if ((getDoActionMethod = FlightServiceGrpc.getDoActionMethod) == null) {
          FlightServiceGrpc.getDoActionMethod = getDoActionMethod = 
              io.grpc.MethodDescriptor.<org.apache.arrow.flight.impl.Flight.Action, org.apache.arrow.flight.impl.Flight.Result>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "arrow.flight.protocol.FlightService", "DoAction"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.Action.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.Result.getDefaultInstance()))
                  .setSchemaDescriptor(new FlightServiceMethodDescriptorSupplier("DoAction"))
                  .build();
          }
        }
     }
     return getDoActionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.Empty,
      org.apache.arrow.flight.impl.Flight.ActionType> getListActionsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListActions",
      requestType = org.apache.arrow.flight.impl.Flight.Empty.class,
      responseType = org.apache.arrow.flight.impl.Flight.ActionType.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.Empty,
      org.apache.arrow.flight.impl.Flight.ActionType> getListActionsMethod() {
    io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.Empty, org.apache.arrow.flight.impl.Flight.ActionType> getListActionsMethod;
    if ((getListActionsMethod = FlightServiceGrpc.getListActionsMethod) == null) {
      synchronized (FlightServiceGrpc.class) {
        if ((getListActionsMethod = FlightServiceGrpc.getListActionsMethod) == null) {
          FlightServiceGrpc.getListActionsMethod = getListActionsMethod = 
              io.grpc.MethodDescriptor.<org.apache.arrow.flight.impl.Flight.Empty, org.apache.arrow.flight.impl.Flight.ActionType>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "arrow.flight.protocol.FlightService", "ListActions"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.Empty.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.ActionType.getDefaultInstance()))
                  .setSchemaDescriptor(new FlightServiceMethodDescriptorSupplier("ListActions"))
                  .build();
          }
        }
     }
     return getListActionsMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static FlightServiceStub newStub(io.grpc.Channel channel) {
    return new FlightServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static FlightServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new FlightServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static FlightServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new FlightServiceFutureStub(channel);
  }

  /**
   * <pre>
   * A flight service is an endpoint for retrieving or storing Arrow data. A
   * flight service can expose one or more predefined endpoints that can be
   * accessed using the Arrow Flight Protocol. Additionally, a flight service
   * can expose a set of actions that are available.
   * </pre>
   */
  public static abstract class FlightServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Handshake between client and server. Depending on the server, the
     * handshake may be required to determine the token that should be used for
     * future operations. Both request and response are streams to allow multiple
     * round-trips depending on auth mechanism.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.HandshakeRequest> handshake(
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.HandshakeResponse> responseObserver) {
      return asyncUnimplementedStreamingCall(getHandshakeMethod(), responseObserver);
    }

    /**
     * <pre>
     * Get a list of available streams given a particular criteria. Most flight
     * services will expose one or more streams that are readily available for
     * retrieval. This api allows listing the streams available for
     * consumption. A user can also provide a criteria. The criteria can limit
     * the subset of streams that can be listed via this interface. Each flight
     * service allows its own definition of how to consume criteria.
     * </pre>
     */
    public void listFlights(org.apache.arrow.flight.impl.Flight.Criteria request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.FlightGetInfo> responseObserver) {
      asyncUnimplementedUnaryCall(getListFlightsMethod(), responseObserver);
    }

    /**
     * <pre>
     * For a given FlightDescriptor, get information about how the flight can be
     * consumed. This is a useful interface if the consumer of the interface
     * already can identify the specific flight to consume. This interface can
     * also allow a consumer to generate a flight stream through a specified
     * descriptor. For example, a flight descriptor might be something that
     * includes a SQL statement or a Pickled Python operation that will be
     * executed. In those cases, the descriptor will not be previously available
     * within the list of available streams provided by ListFlights but will be
     * available for consumption for the duration defined by the specific flight
     * service.
     * </pre>
     */
    public void getFlightInfo(org.apache.arrow.flight.impl.Flight.FlightDescriptor request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.FlightGetInfo> responseObserver) {
      asyncUnimplementedUnaryCall(getGetFlightInfoMethod(), responseObserver);
    }

    /**
     * <pre>
     * Retrieve a single stream associated with a particular descriptor
     * associated with the referenced ticket. A Flight can be composed of one or
     * more streams where each stream can be retrieved using a separate opaque
     * ticket that the flight service uses for managing a collection of streams.
     * </pre>
     */
    public void doGet(org.apache.arrow.flight.impl.Flight.Ticket request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.FlightData> responseObserver) {
      asyncUnimplementedUnaryCall(getDoGetMethod(), responseObserver);
    }

    /**
     * <pre>
     * Push a stream to the flight service associated with a particular
     * flight stream. This allows a client of a flight service to upload a stream
     * of data. Depending on the particular flight service, a client consumer
     * could be allowed to upload a single stream per descriptor or an unlimited
     * number. In the latter, the service might implement a 'seal' action that
     * can be applied to a descriptor once all streams are uploaded.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.FlightData> doPut(
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.PutResult> responseObserver) {
      return asyncUnimplementedStreamingCall(getDoPutMethod(), responseObserver);
    }

    /**
     * <pre>
     * Flight services can support an arbitrary number of simple actions in
     * addition to the possible ListFlights, GetFlightInfo, DoGet, DoPut
     * operations that are potentially available. DoAction allows a flight client
     * to do a specific action against a flight service. An action includes
     * opaque request and response objects that are specific to the type action
     * being undertaken.
     * </pre>
     */
    public void doAction(org.apache.arrow.flight.impl.Flight.Action request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.Result> responseObserver) {
      asyncUnimplementedUnaryCall(getDoActionMethod(), responseObserver);
    }

    /**
     * <pre>
     * A flight service exposes all of the available action types that it has
     * along with descriptions. This allows different flight consumers to
     * understand the capabilities of the flight service.
     * </pre>
     */
    public void listActions(org.apache.arrow.flight.impl.Flight.Empty request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.ActionType> responseObserver) {
      asyncUnimplementedUnaryCall(getListActionsMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getHandshakeMethod(),
            asyncBidiStreamingCall(
              new MethodHandlers<
                org.apache.arrow.flight.impl.Flight.HandshakeRequest,
                org.apache.arrow.flight.impl.Flight.HandshakeResponse>(
                  this, METHODID_HANDSHAKE)))
          .addMethod(
            getListFlightsMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                org.apache.arrow.flight.impl.Flight.Criteria,
                org.apache.arrow.flight.impl.Flight.FlightGetInfo>(
                  this, METHODID_LIST_FLIGHTS)))
          .addMethod(
            getGetFlightInfoMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                org.apache.arrow.flight.impl.Flight.FlightDescriptor,
                org.apache.arrow.flight.impl.Flight.FlightGetInfo>(
                  this, METHODID_GET_FLIGHT_INFO)))
          .addMethod(
            getDoGetMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                org.apache.arrow.flight.impl.Flight.Ticket,
                org.apache.arrow.flight.impl.Flight.FlightData>(
                  this, METHODID_DO_GET)))
          .addMethod(
            getDoPutMethod(),
            asyncClientStreamingCall(
              new MethodHandlers<
                org.apache.arrow.flight.impl.Flight.FlightData,
                org.apache.arrow.flight.impl.Flight.PutResult>(
                  this, METHODID_DO_PUT)))
          .addMethod(
            getDoActionMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                org.apache.arrow.flight.impl.Flight.Action,
                org.apache.arrow.flight.impl.Flight.Result>(
                  this, METHODID_DO_ACTION)))
          .addMethod(
            getListActionsMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                org.apache.arrow.flight.impl.Flight.Empty,
                org.apache.arrow.flight.impl.Flight.ActionType>(
                  this, METHODID_LIST_ACTIONS)))
          .build();
    }
  }

  /**
   * <pre>
   * A flight service is an endpoint for retrieving or storing Arrow data. A
   * flight service can expose one or more predefined endpoints that can be
   * accessed using the Arrow Flight Protocol. Additionally, a flight service
   * can expose a set of actions that are available.
   * </pre>
   */
  public static final class FlightServiceStub extends io.grpc.stub.AbstractStub<FlightServiceStub> {
    private FlightServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private FlightServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected FlightServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new FlightServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Handshake between client and server. Depending on the server, the
     * handshake may be required to determine the token that should be used for
     * future operations. Both request and response are streams to allow multiple
     * round-trips depending on auth mechanism.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.HandshakeRequest> handshake(
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.HandshakeResponse> responseObserver) {
      return asyncBidiStreamingCall(
          getChannel().newCall(getHandshakeMethod(), getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     * Get a list of available streams given a particular criteria. Most flight
     * services will expose one or more streams that are readily available for
     * retrieval. This api allows listing the streams available for
     * consumption. A user can also provide a criteria. The criteria can limit
     * the subset of streams that can be listed via this interface. Each flight
     * service allows its own definition of how to consume criteria.
     * </pre>
     */
    public void listFlights(org.apache.arrow.flight.impl.Flight.Criteria request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.FlightGetInfo> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getListFlightsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * For a given FlightDescriptor, get information about how the flight can be
     * consumed. This is a useful interface if the consumer of the interface
     * already can identify the specific flight to consume. This interface can
     * also allow a consumer to generate a flight stream through a specified
     * descriptor. For example, a flight descriptor might be something that
     * includes a SQL statement or a Pickled Python operation that will be
     * executed. In those cases, the descriptor will not be previously available
     * within the list of available streams provided by ListFlights but will be
     * available for consumption for the duration defined by the specific flight
     * service.
     * </pre>
     */
    public void getFlightInfo(org.apache.arrow.flight.impl.Flight.FlightDescriptor request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.FlightGetInfo> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetFlightInfoMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Retrieve a single stream associated with a particular descriptor
     * associated with the referenced ticket. A Flight can be composed of one or
     * more streams where each stream can be retrieved using a separate opaque
     * ticket that the flight service uses for managing a collection of streams.
     * </pre>
     */
    public void doGet(org.apache.arrow.flight.impl.Flight.Ticket request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.FlightData> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getDoGetMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Push a stream to the flight service associated with a particular
     * flight stream. This allows a client of a flight service to upload a stream
     * of data. Depending on the particular flight service, a client consumer
     * could be allowed to upload a single stream per descriptor or an unlimited
     * number. In the latter, the service might implement a 'seal' action that
     * can be applied to a descriptor once all streams are uploaded.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.FlightData> doPut(
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.PutResult> responseObserver) {
      return asyncClientStreamingCall(
          getChannel().newCall(getDoPutMethod(), getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     * Flight services can support an arbitrary number of simple actions in
     * addition to the possible ListFlights, GetFlightInfo, DoGet, DoPut
     * operations that are potentially available. DoAction allows a flight client
     * to do a specific action against a flight service. An action includes
     * opaque request and response objects that are specific to the type action
     * being undertaken.
     * </pre>
     */
    public void doAction(org.apache.arrow.flight.impl.Flight.Action request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.Result> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getDoActionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * A flight service exposes all of the available action types that it has
     * along with descriptions. This allows different flight consumers to
     * understand the capabilities of the flight service.
     * </pre>
     */
    public void listActions(org.apache.arrow.flight.impl.Flight.Empty request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.ActionType> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getListActionsMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * A flight service is an endpoint for retrieving or storing Arrow data. A
   * flight service can expose one or more predefined endpoints that can be
   * accessed using the Arrow Flight Protocol. Additionally, a flight service
   * can expose a set of actions that are available.
   * </pre>
   */
  public static final class FlightServiceBlockingStub extends io.grpc.stub.AbstractStub<FlightServiceBlockingStub> {
    private FlightServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private FlightServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected FlightServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new FlightServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Get a list of available streams given a particular criteria. Most flight
     * services will expose one or more streams that are readily available for
     * retrieval. This api allows listing the streams available for
     * consumption. A user can also provide a criteria. The criteria can limit
     * the subset of streams that can be listed via this interface. Each flight
     * service allows its own definition of how to consume criteria.
     * </pre>
     */
    public java.util.Iterator<org.apache.arrow.flight.impl.Flight.FlightGetInfo> listFlights(
        org.apache.arrow.flight.impl.Flight.Criteria request) {
      return blockingServerStreamingCall(
          getChannel(), getListFlightsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * For a given FlightDescriptor, get information about how the flight can be
     * consumed. This is a useful interface if the consumer of the interface
     * already can identify the specific flight to consume. This interface can
     * also allow a consumer to generate a flight stream through a specified
     * descriptor. For example, a flight descriptor might be something that
     * includes a SQL statement or a Pickled Python operation that will be
     * executed. In those cases, the descriptor will not be previously available
     * within the list of available streams provided by ListFlights but will be
     * available for consumption for the duration defined by the specific flight
     * service.
     * </pre>
     */
    public org.apache.arrow.flight.impl.Flight.FlightGetInfo getFlightInfo(org.apache.arrow.flight.impl.Flight.FlightDescriptor request) {
      return blockingUnaryCall(
          getChannel(), getGetFlightInfoMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Retrieve a single stream associated with a particular descriptor
     * associated with the referenced ticket. A Flight can be composed of one or
     * more streams where each stream can be retrieved using a separate opaque
     * ticket that the flight service uses for managing a collection of streams.
     * </pre>
     */
    public java.util.Iterator<org.apache.arrow.flight.impl.Flight.FlightData> doGet(
        org.apache.arrow.flight.impl.Flight.Ticket request) {
      return blockingServerStreamingCall(
          getChannel(), getDoGetMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Flight services can support an arbitrary number of simple actions in
     * addition to the possible ListFlights, GetFlightInfo, DoGet, DoPut
     * operations that are potentially available. DoAction allows a flight client
     * to do a specific action against a flight service. An action includes
     * opaque request and response objects that are specific to the type action
     * being undertaken.
     * </pre>
     */
    public java.util.Iterator<org.apache.arrow.flight.impl.Flight.Result> doAction(
        org.apache.arrow.flight.impl.Flight.Action request) {
      return blockingServerStreamingCall(
          getChannel(), getDoActionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * A flight service exposes all of the available action types that it has
     * along with descriptions. This allows different flight consumers to
     * understand the capabilities of the flight service.
     * </pre>
     */
    public java.util.Iterator<org.apache.arrow.flight.impl.Flight.ActionType> listActions(
        org.apache.arrow.flight.impl.Flight.Empty request) {
      return blockingServerStreamingCall(
          getChannel(), getListActionsMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * A flight service is an endpoint for retrieving or storing Arrow data. A
   * flight service can expose one or more predefined endpoints that can be
   * accessed using the Arrow Flight Protocol. Additionally, a flight service
   * can expose a set of actions that are available.
   * </pre>
   */
  public static final class FlightServiceFutureStub extends io.grpc.stub.AbstractStub<FlightServiceFutureStub> {
    private FlightServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private FlightServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected FlightServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new FlightServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * For a given FlightDescriptor, get information about how the flight can be
     * consumed. This is a useful interface if the consumer of the interface
     * already can identify the specific flight to consume. This interface can
     * also allow a consumer to generate a flight stream through a specified
     * descriptor. For example, a flight descriptor might be something that
     * includes a SQL statement or a Pickled Python operation that will be
     * executed. In those cases, the descriptor will not be previously available
     * within the list of available streams provided by ListFlights but will be
     * available for consumption for the duration defined by the specific flight
     * service.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.apache.arrow.flight.impl.Flight.FlightGetInfo> getFlightInfo(
        org.apache.arrow.flight.impl.Flight.FlightDescriptor request) {
      return futureUnaryCall(
          getChannel().newCall(getGetFlightInfoMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_LIST_FLIGHTS = 0;
  private static final int METHODID_GET_FLIGHT_INFO = 1;
  private static final int METHODID_DO_GET = 2;
  private static final int METHODID_DO_ACTION = 3;
  private static final int METHODID_LIST_ACTIONS = 4;
  private static final int METHODID_HANDSHAKE = 5;
  private static final int METHODID_DO_PUT = 6;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final FlightServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(FlightServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LIST_FLIGHTS:
          serviceImpl.listFlights((org.apache.arrow.flight.impl.Flight.Criteria) request,
              (io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.FlightGetInfo>) responseObserver);
          break;
        case METHODID_GET_FLIGHT_INFO:
          serviceImpl.getFlightInfo((org.apache.arrow.flight.impl.Flight.FlightDescriptor) request,
              (io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.FlightGetInfo>) responseObserver);
          break;
        case METHODID_DO_GET:
          serviceImpl.doGet((org.apache.arrow.flight.impl.Flight.Ticket) request,
              (io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.FlightData>) responseObserver);
          break;
        case METHODID_DO_ACTION:
          serviceImpl.doAction((org.apache.arrow.flight.impl.Flight.Action) request,
              (io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.Result>) responseObserver);
          break;
        case METHODID_LIST_ACTIONS:
          serviceImpl.listActions((org.apache.arrow.flight.impl.Flight.Empty) request,
              (io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.ActionType>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_HANDSHAKE:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.handshake(
              (io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.HandshakeResponse>) responseObserver);
        case METHODID_DO_PUT:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.doPut(
              (io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.PutResult>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class FlightServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    FlightServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return org.apache.arrow.flight.impl.Flight.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("FlightService");
    }
  }

  private static final class FlightServiceFileDescriptorSupplier
      extends FlightServiceBaseDescriptorSupplier {
    FlightServiceFileDescriptorSupplier() {}
  }

  private static final class FlightServiceMethodDescriptorSupplier
      extends FlightServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    FlightServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (FlightServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new FlightServiceFileDescriptorSupplier())
              .addMethod(getHandshakeMethod())
              .addMethod(getListFlightsMethod())
              .addMethod(getGetFlightInfoMethod())
              .addMethod(getDoGetMethod())
              .addMethod(getDoPutMethod())
              .addMethod(getDoActionMethod())
              .addMethod(getListActionsMethod())
              .build();
        }
      }
    }
    return result;
  }
}
