/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.consumer.ArrayConsumer;
import org.apache.arrow.adapter.jdbc.consumer.BigIntConsumer;
import org.apache.arrow.adapter.jdbc.consumer.BinaryConsumer;
import org.apache.arrow.adapter.jdbc.consumer.BitConsumer;
import org.apache.arrow.adapter.jdbc.consumer.BlobConsumer;
import org.apache.arrow.adapter.jdbc.consumer.ClobConsumer;
import org.apache.arrow.adapter.jdbc.consumer.CompositeJdbcConsumer;
import org.apache.arrow.adapter.jdbc.consumer.DateConsumer;
import org.apache.arrow.adapter.jdbc.consumer.DecimalConsumer;
import org.apache.arrow.adapter.jdbc.consumer.DoubleConsumer;
import org.apache.arrow.adapter.jdbc.consumer.FloatConsumer;
import org.apache.arrow.adapter.jdbc.consumer.IntConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.adapter.jdbc.consumer.SmallIntConsumer;
import org.apache.arrow.adapter.jdbc.consumer.TimeConsumer;
import org.apache.arrow.adapter.jdbc.consumer.TimestampConsumer;
import org.apache.arrow.adapter.jdbc.consumer.TinyIntConsumer;
import org.apache.arrow.adapter.jdbc.consumer.VarCharConsumer;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public class JdbcToArrowUtils {
    private static final int JDBC_ARRAY_VALUE_COLUMN = 2;

    public static Calendar getUtcCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
    }

    public static Schema jdbcToArrowSchema(ResultSetMetaData rsmd, Calendar calendar) throws SQLException {
        Preconditions.checkNotNull((Object)calendar, (Object)"Calendar object can't be null");
        return JdbcToArrowUtils.jdbcToArrowSchema(rsmd, new JdbcToArrowConfig((BaseAllocator)new RootAllocator(0L), calendar));
    }

    public static Schema jdbcToArrowSchema(ResultSetMetaData rsmd, JdbcToArrowConfig config) throws SQLException {
        Preconditions.checkNotNull((Object)rsmd, (Object)"JDBC ResultSetMetaData object can't be null");
        Preconditions.checkNotNull((Object)config, (Object)"The configuration object must not be null");
        ArrayList<Field> fields = new ArrayList<Field>();
        int columnCount = rsmd.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            HashMap<String, String> metadata;
            String columnName = rsmd.getColumnName(i);
            if (config.shouldIncludeMetadata()) {
                metadata = new HashMap<String, String>();
                metadata.put("SQL_CATALOG_NAME", rsmd.getCatalogName(i));
                metadata.put("SQL_TABLE_NAME", rsmd.getTableName(i));
                metadata.put("SQL_COLUMN_NAME", columnName);
                metadata.put("SQL_TYPE", rsmd.getColumnTypeName(i));
            } else {
                metadata = null;
            }
            ArrowType arrowType = JdbcToArrowUtils.getArrowTypeForJdbcField(new JdbcFieldInfo(rsmd, i), config.getCalendar());
            if (arrowType == null) continue;
            FieldType fieldType = new FieldType(true, arrowType, null, metadata);
            ArrayList<Field> children = null;
            if (arrowType.getTypeID() == ArrowType.List.TYPE_TYPE) {
                JdbcFieldInfo arrayFieldInfo = JdbcToArrowUtils.getJdbcFieldInfoForArraySubType(rsmd, i, config);
                if (arrayFieldInfo == null) {
                    throw new IllegalArgumentException("Configuration does not provide a mapping for array column " + i);
                }
                children = new ArrayList<Field>();
                ArrowType childType = JdbcToArrowUtils.getArrowTypeForJdbcField(arrayFieldInfo, config.getCalendar());
                children.add(new Field("child", FieldType.nullable((ArrowType)childType), null));
            }
            fields.add(new Field(columnName, fieldType, children));
        }
        return new Schema(fields, null);
    }

    public static ArrowType getArrowTypeForJdbcField(JdbcFieldInfo fieldInfo, Calendar calendar) {
        Preconditions.checkNotNull((Object)fieldInfo, (Object)"JdbcFieldInfo object cannot be null");
        String timezone = calendar != null ? calendar.getTimeZone().getID() : null;
        switch (fieldInfo.getJdbcType()) {
            case -7: 
            case 16: {
                return new ArrowType.Bool();
            }
            case -6: {
                return new ArrowType.Int(8, true);
            }
            case 5: {
                return new ArrowType.Int(16, true);
            }
            case 4: {
                return new ArrowType.Int(32, true);
            }
            case -5: {
                return new ArrowType.Int(64, true);
            }
            case 2: 
            case 3: {
                int precision = fieldInfo.getPrecision();
                int scale = fieldInfo.getScale();
                return new ArrowType.Decimal(precision, scale);
            }
            case 6: 
            case 7: {
                return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
            }
            case 8: {
                return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return new ArrowType.Utf8();
            }
            case 91: {
                return new ArrowType.Date(DateUnit.MILLISECOND);
            }
            case 92: {
                return new ArrowType.Time(TimeUnit.MILLISECOND, 32);
            }
            case 93: {
                return new ArrowType.Timestamp(TimeUnit.MILLISECOND, timezone);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return new ArrowType.Binary();
            }
            case 2003: {
                return new ArrowType.List();
            }
        }
        return null;
    }

    private static JdbcFieldInfo getJdbcFieldInfoForArraySubType(ResultSetMetaData rsmd, int arrayColumn, JdbcToArrowConfig config) throws SQLException {
        Preconditions.checkNotNull((Object)rsmd, (Object)"ResultSet MetaData object cannot be null");
        Preconditions.checkNotNull((Object)config, (Object)"Configuration must not be null");
        Preconditions.checkArgument((arrayColumn > 0 ? 1 : 0) != 0, (Object)"ResultSetMetaData columns start with 1; column cannot be less than 1");
        Preconditions.checkArgument((arrayColumn <= rsmd.getColumnCount() ? 1 : 0) != 0, (Object)"Column number cannot be more than the number of columns");
        JdbcFieldInfo fieldInfo = config.getArraySubTypeByColumnIndex(arrayColumn);
        if (fieldInfo == null) {
            fieldInfo = config.getArraySubTypeByColumnName(rsmd.getColumnName(arrayColumn));
        }
        return fieldInfo;
    }

    public static void jdbcToArrowVectors(ResultSet rs, VectorSchemaRoot root, Calendar calendar) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)calendar, (Object)"Calendar object can't be null");
        JdbcToArrowUtils.jdbcToArrowVectors(rs, root, new JdbcToArrowConfig((BaseAllocator)new RootAllocator(0L), calendar));
    }

    public static void jdbcToArrowVectors(ResultSet rs, VectorSchemaRoot root, JdbcToArrowConfig config) throws SQLException, IOException {
        block4: {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            JdbcConsumer[] consumers = new JdbcConsumer[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                consumers[i - 1] = JdbcToArrowUtils.getConsumer(rs, i, rs.getMetaData().getColumnType(i), root.getVector(rsmd.getColumnName(i)), config);
            }
            CompositeJdbcConsumer compositeConsumer = null;
            try {
                compositeConsumer = new CompositeJdbcConsumer(consumers);
                int readRowCount = 0;
                while (rs.next()) {
                    compositeConsumer.consume(rs);
                    ++readRowCount;
                }
                root.setRowCount(readRowCount);
            }
            catch (Exception e) {
                if (compositeConsumer == null) break block4;
                compositeConsumer.close();
            }
        }
    }

    static JdbcConsumer getConsumer(ResultSet resultSet, int columnIndex, int jdbcColType, FieldVector vector, JdbcToArrowConfig config) throws SQLException {
        Calendar calendar = config.getCalendar();
        switch (jdbcColType) {
            case -7: 
            case 16: {
                return new BitConsumer((BitVector)vector, columnIndex);
            }
            case -6: {
                return new TinyIntConsumer((TinyIntVector)vector, columnIndex);
            }
            case 5: {
                return new SmallIntConsumer((SmallIntVector)vector, columnIndex);
            }
            case 4: {
                return new IntConsumer((IntVector)vector, columnIndex);
            }
            case -5: {
                return new BigIntConsumer((BigIntVector)vector, columnIndex);
            }
            case 2: 
            case 3: {
                return new DecimalConsumer((DecimalVector)vector, columnIndex);
            }
            case 6: 
            case 7: {
                return new FloatConsumer((Float4Vector)vector, columnIndex);
            }
            case 8: {
                return new DoubleConsumer((Float8Vector)vector, columnIndex);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return new VarCharConsumer((VarCharVector)vector, columnIndex);
            }
            case 91: {
                return new DateConsumer((DateMilliVector)vector, columnIndex, calendar);
            }
            case 92: {
                return new TimeConsumer((TimeMilliVector)vector, columnIndex, calendar);
            }
            case 93: {
                return new TimestampConsumer((TimeStampMilliTZVector)vector, columnIndex, calendar);
            }
            case -4: 
            case -3: 
            case -2: {
                return new BinaryConsumer((VarBinaryVector)vector, columnIndex);
            }
            case 2003: {
                JdbcFieldInfo fieldInfo = JdbcToArrowUtils.getJdbcFieldInfoForArraySubType(resultSet.getMetaData(), columnIndex, config);
                if (fieldInfo == null) {
                    throw new IllegalArgumentException("Column " + columnIndex + " is an array of unknown type.");
                }
                JdbcConsumer delegate = JdbcToArrowUtils.getConsumer(resultSet, 2, fieldInfo.getJdbcType(), ((ListVector)vector).getDataVector(), config);
                return new ArrayConsumer((ListVector)vector, delegate, columnIndex);
            }
            case 2005: {
                return new ClobConsumer((VarCharVector)vector, columnIndex);
            }
            case 2004: {
                BinaryConsumer blobDelegate = new BinaryConsumer((VarBinaryVector)vector, columnIndex);
                return new BlobConsumer(blobDelegate, columnIndex);
            }
        }
        throw new UnsupportedOperationException();
    }
}

