/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.DateMilliVector;

public class DateConsumer
implements JdbcConsumer<DateMilliVector> {
    private DateMilliVector vector;
    private final int columnIndexInResultSet;
    private final Calendar calendar;
    private int currentIndex;

    public DateConsumer(DateMilliVector vector, int index) {
        this(vector, index, null);
    }

    public DateConsumer(DateMilliVector vector, int index, Calendar calendar) {
        this.vector = vector;
        this.columnIndexInResultSet = index;
        this.calendar = calendar;
    }

    @Override
    public void consume(ResultSet resultSet) throws SQLException {
        Date date;
        Date date2 = date = this.calendar == null ? resultSet.getDate(this.columnIndexInResultSet) : resultSet.getDate(this.columnIndexInResultSet, this.calendar);
        if (!resultSet.wasNull()) {
            this.vector.setSafe(this.currentIndex, date.getTime());
        }
        ++this.currentIndex;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(DateMilliVector vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }
}

