/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.TimeStampMilliTZVector;

public class TimestampConsumer
implements JdbcConsumer<TimeStampMilliTZVector> {
    private TimeStampMilliTZVector vector;
    private final int columnIndexInResultSet;
    private final Calendar calendar;
    private int currentIndex;

    public TimestampConsumer(TimeStampMilliTZVector vector, int index) {
        this(vector, index, null);
    }

    public TimestampConsumer(TimeStampMilliTZVector vector, int index, Calendar calendar) {
        this.vector = vector;
        this.columnIndexInResultSet = index;
        this.calendar = calendar;
    }

    @Override
    public void consume(ResultSet resultSet) throws SQLException {
        Timestamp timestamp;
        Timestamp timestamp2 = timestamp = this.calendar == null ? resultSet.getTimestamp(this.columnIndexInResultSet) : resultSet.getTimestamp(this.columnIndexInResultSet, this.calendar);
        if (!resultSet.wasNull()) {
            this.vector.setSafe(this.currentIndex, timestamp.getTime());
        }
        ++this.currentIndex;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(TimeStampMilliTZVector vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }
}

