/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ObjectMapperFactory;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JdbcToArrowCommentMetadataTest {
    private static final String COMMENT = "comment";
    private final ObjectWriter schemaSerializer = ObjectMapperFactory.newObjectMapper().writerWithDefaultPrettyPrinter();
    private Connection conn = null;

    @Before
    public void setUp() throws SQLException, ClassNotFoundException {
        String url = "jdbc:h2:mem:JdbcToArrowTest?characterEncoding=UTF-8;INIT=runscript from 'classpath:/h2/comment.sql'";
        String driver = "org.h2.Driver";
        Class.forName(driver);
        this.conn = DriverManager.getConnection(url);
    }

    @After
    public void tearDown() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    @Test
    public void schemaComment() throws Exception {
        boolean includeMetadata = false;
        String schemaJson = this.schemaSerializer.writeValueAsString((Object)this.getSchemaWithCommentFromQuery(includeMetadata));
        String expectedSchema = this.getExpectedSchema("/h2/expectedSchemaWithComments.json");
        Assertions.assertThat((String)schemaJson).isEqualTo(expectedSchema);
    }

    @Test
    public void schemaCommentWithDatabaseMetadata() throws Exception {
        boolean includeMetadata = true;
        String schemaJson = this.schemaSerializer.writeValueAsString((Object)this.getSchemaWithCommentFromQuery(includeMetadata));
        String expectedSchema = this.getExpectedSchema("/h2/expectedSchemaWithCommentsAndJdbcMeta.json");
        Assertions.assertThat((String)schemaJson).isEqualTo(expectedSchema);
    }

    /*
     * Exception decompiling
     */
    private Schema getSchemaWithCommentFromQuery(boolean includeMetadata) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getTableNameFromResultSetMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        HashSet<String> tablesFromQuery = new HashSet<String>();
        int columnCount = resultSetMetaData.getColumnCount();
        for (int idx = 1; idx <= columnCount; ++idx) {
            String tableName = resultSetMetaData.getTableName(idx);
            if (tableName == null || tableName.isEmpty()) continue;
            tablesFromQuery.add(tableName);
        }
        if (tablesFromQuery.size() == 1) {
            return (String)tablesFromQuery.iterator().next();
        }
        throw new RuntimeException("Table metadata is absent or ambiguous");
    }

    private Map<Integer, Map<String, String>> getColumnComments(DatabaseMetaData metaData, ResultSetMetaData resultSetMetaData) throws SQLException {
        HashMap<Integer, Map<String, String>> columnCommentByColumnIndex = new HashMap<Integer, Map<String, String>>();
        int columnCount = resultSetMetaData.getColumnCount();
        for (int columnIdx = 1; columnIdx <= columnCount; ++columnIdx) {
            String columnComment = this.getColumnComment(metaData, resultSetMetaData.getTableName(columnIdx), resultSetMetaData.getColumnName(columnIdx));
            if (columnComment == null || columnComment.isEmpty()) continue;
            columnCommentByColumnIndex.put(columnIdx, Collections.singletonMap(COMMENT, columnComment));
        }
        return columnCommentByColumnIndex;
    }

    private String getTableComment(DatabaseMetaData metaData, String tableName) throws SQLException {
        if (tableName == null || tableName.isEmpty()) {
            return null;
        }
        String comment = null;
        int rowCount = 0;
        try (ResultSet tableMetadata = metaData.getTables("%", "%", tableName, null);){
            if (tableMetadata.next()) {
                comment = tableMetadata.getString("REMARKS");
                ++rowCount;
            }
        }
        if (rowCount == 1) {
            return comment;
        }
        if (rowCount > 1) {
            throw new RuntimeException("Multiple tables found for table name");
        }
        throw new RuntimeException("Table comment not found");
    }

    private String getColumnComment(DatabaseMetaData metaData, String tableName, String columnName) throws SQLException {
        try (ResultSet tableMetadata = metaData.getColumns("%", "%", tableName, columnName);){
            if (tableMetadata.next()) {
                String string = tableMetadata.getString("REMARKS");
                return string;
            }
        }
        return null;
    }

    private String getExpectedSchema(String expectedResource) throws IOException, URISyntaxException {
        return new String(Files.readAllBytes(Paths.get(Objects.requireNonNull(JdbcToArrowCommentMetadataTest.class.getResource(expectedResource)).toURI())), StandardCharsets.UTF_8);
    }
}

