/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.junit.Assert;
import org.junit.Test;

public class JdbcToArrowConfigTest {
    private static final BufferAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
    private static final Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);

    @Test(expected=NullPointerException.class)
    public void testConfigNullArguments() {
        new JdbcToArrowConfig(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testBuilderNullArguments() {
        new JdbcToArrowConfigBuilder(null, null);
    }

    @Test
    public void testConfigNullCalendar() {
        JdbcToArrowConfig config = new JdbcToArrowConfig(allocator, null);
        Assert.assertNull((Object)config.getCalendar());
    }

    @Test
    public void testBuilderNullCalendar() {
        JdbcToArrowConfigBuilder builder = new JdbcToArrowConfigBuilder(allocator, null);
        JdbcToArrowConfig config = builder.build();
        Assert.assertNull((Object)config.getCalendar());
    }

    @Test(expected=NullPointerException.class)
    public void testConfigNullAllocator() {
        new JdbcToArrowConfig(null, calendar);
    }

    @Test(expected=NullPointerException.class)
    public void testBuilderNullAllocator() {
        new JdbcToArrowConfigBuilder(null, calendar);
    }

    @Test(expected=NullPointerException.class)
    public void testSetNullAllocator() {
        JdbcToArrowConfigBuilder builder = new JdbcToArrowConfigBuilder(allocator, calendar);
        builder.setAllocator(null);
    }

    @Test
    public void testSetNullCalendar() {
        JdbcToArrowConfigBuilder builder = new JdbcToArrowConfigBuilder(allocator, calendar);
        JdbcToArrowConfig config = builder.setCalendar(null).build();
        Assert.assertNull((Object)config.getCalendar());
    }

    @Test
    public void testConfig() {
        JdbcToArrowConfigBuilder builder = new JdbcToArrowConfigBuilder(allocator, calendar);
        JdbcToArrowConfig config = builder.build();
        Assert.assertTrue((allocator == config.getAllocator() ? 1 : 0) != 0);
        Assert.assertTrue((calendar == config.getCalendar() ? 1 : 0) != 0);
        Calendar newCalendar = Calendar.getInstance();
        RootAllocator newAllocator = new RootAllocator(32L);
        builder.setAllocator((BufferAllocator)newAllocator).setCalendar(newCalendar);
        config = builder.build();
        Assert.assertTrue((newAllocator == config.getAllocator() ? 1 : 0) != 0);
        Assert.assertTrue((newCalendar == config.getCalendar() ? 1 : 0) != 0);
    }

    @Test
    public void testIncludeMetadata() {
        JdbcToArrowConfigBuilder builder = new JdbcToArrowConfigBuilder(allocator, calendar, false);
        JdbcToArrowConfig config = builder.build();
        Assert.assertFalse((boolean)config.shouldIncludeMetadata());
        builder.setIncludeMetadata(true);
        config = builder.build();
        Assert.assertTrue((boolean)config.shouldIncludeMetadata());
        config = new JdbcToArrowConfigBuilder(allocator, calendar, true).build();
        Assert.assertTrue((boolean)config.shouldIncludeMetadata());
        config = new JdbcToArrowConfig(allocator, calendar, true, true, null, null, -1, null);
        Assert.assertTrue((boolean)config.shouldIncludeMetadata());
        Assert.assertTrue((boolean)config.isReuseVectorSchemaRoot());
        config = new JdbcToArrowConfig(allocator, calendar, false, false, null, null, -1, null);
        Assert.assertFalse((boolean)config.shouldIncludeMetadata());
        Assert.assertFalse((boolean)config.isReuseVectorSchemaRoot());
    }

    @Test
    public void testArraySubTypes() {
        JdbcToArrowConfigBuilder builder = new JdbcToArrowConfigBuilder(allocator, calendar, false);
        JdbcToArrowConfig config = builder.build();
        boolean columnIndex = true;
        String columnName = "COLUMN";
        Assert.assertNull((Object)config.getArraySubTypeByColumnIndex(1));
        Assert.assertNull((Object)config.getArraySubTypeByColumnName("COLUMN"));
        HashMap<Integer, JdbcFieldInfo> indexMapping = new HashMap<Integer, JdbcFieldInfo>();
        indexMapping.put(2, new JdbcFieldInfo(-5));
        HashMap<String, JdbcFieldInfo> fieldMapping = new HashMap<String, JdbcFieldInfo>();
        fieldMapping.put("NEW_COLUMN", new JdbcFieldInfo(-2));
        builder.setArraySubTypeByColumnIndexMap(indexMapping);
        builder.setArraySubTypeByColumnNameMap(fieldMapping);
        config = builder.build();
        Assert.assertNull((Object)config.getArraySubTypeByColumnIndex(1));
        Assert.assertNull((Object)config.getArraySubTypeByColumnName("COLUMN"));
        indexMapping.put(1, new JdbcFieldInfo(-7));
        fieldMapping.put("COLUMN", new JdbcFieldInfo(2004));
        Assert.assertNotNull((Object)config.getArraySubTypeByColumnIndex(1));
        Assert.assertEquals((long)-7L, (long)config.getArraySubTypeByColumnIndex(1).getJdbcType());
        Assert.assertEquals((long)2004L, (long)config.getArraySubTypeByColumnName("COLUMN").getJdbcType());
    }
}

