/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.ArrowVectorIterator;
import org.apache.arrow.adapter.jdbc.JdbcToArrow;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adapter.jdbc.ResultSetUtility;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class ResultSetUtilityTest {
    @Test
    public void testZeroRowResultSet() throws Exception {
        for (boolean reuseVectorSchemaRoot : new boolean[]{false, true}) {
            try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);){
                ResultSet rs = ResultSetUtility.generateEmptyResultSet();
                JdbcToArrowConfig config = new JdbcToArrowConfigBuilder((BufferAllocator)allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(reuseVectorSchemaRoot).build();
                ArrowVectorIterator iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);
                Assert.assertTrue((String)"Iterator on zero row ResultSet should haveNext() before use", (boolean)iter.hasNext());
                VectorSchemaRoot root = iter.next();
                Assert.assertNotNull((String)"VectorSchemaRoot from first next() result should never be null", (Object)root);
                Assert.assertEquals((String)"VectorSchemaRoot from empty ResultSet should have zero rows", (long)0L, (long)root.getRowCount());
                Assert.assertFalse((String)"hasNext() should return false on empty ResultSets after initial next() call", (boolean)iter.hasNext());
            }
        }
    }

    @Test
    public void testBasicResultSet() throws Exception {
        try (ResultSetUtility.MockResultSet resultSet = ResultSetUtility.generateBasicResultSet(3);){
            Assert.assertTrue((boolean)resultSet.isBeforeFirst());
            Assert.assertFalse((boolean)resultSet.isFirst());
            Assert.assertFalse((boolean)resultSet.isLast());
            Assert.assertFalse((boolean)resultSet.isAfterLast());
            Assertions.assertThrows(SQLException.class, () -> resultSet.getString(1));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertFalse((boolean)resultSet.isBeforeFirst());
            Assert.assertTrue((boolean)resultSet.isFirst());
            Assert.assertFalse((boolean)resultSet.isLast());
            Assert.assertFalse((boolean)resultSet.isAfterLast());
            Assert.assertEquals((Object)"row number: 1", (Object)resultSet.getString(1));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertFalse((boolean)resultSet.isBeforeFirst());
            Assert.assertFalse((boolean)resultSet.isFirst());
            Assert.assertFalse((boolean)resultSet.isLast());
            Assert.assertFalse((boolean)resultSet.isAfterLast());
            Assert.assertEquals((Object)"row number: 2", (Object)resultSet.getString(1));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertFalse((boolean)resultSet.isBeforeFirst());
            Assert.assertFalse((boolean)resultSet.isFirst());
            Assert.assertTrue((boolean)resultSet.isLast());
            Assert.assertFalse((boolean)resultSet.isAfterLast());
            Assert.assertEquals((Object)"row number: 3", (Object)resultSet.getString(1));
            Assert.assertFalse((boolean)resultSet.next());
            Assert.assertFalse((boolean)resultSet.isBeforeFirst());
            Assert.assertFalse((boolean)resultSet.isFirst());
            Assert.assertFalse((boolean)resultSet.isLast());
            Assert.assertTrue((boolean)resultSet.isAfterLast());
        }
    }

    @Test
    public void testMockDataTypes() throws SQLException {
        ResultSetUtility.MockDataElement element = new ResultSetUtility.MockDataElement(1L, 2);
        Assert.assertEquals((long)1L, (long)element.getLong());
        Assert.assertEquals((long)1L, (long)element.getInt());
        Assert.assertEquals((Object)"1", (Object)element.getString());
    }
}

