/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.arrow.adapter.jdbc.ArrowVectorIterator;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrow;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adapter.jdbc.ResultSetUtility;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnreliableMetaDataTest {
    private final boolean reuseVectorSchemaRoot;
    private BufferAllocator allocator;

    public UnreliableMetaDataTest(boolean reuseVectorSchemaRoot) {
        this.reuseVectorSchemaRoot = reuseVectorSchemaRoot;
    }

    @Before
    public void beforeEach() {
        this.allocator = new RootAllocator();
    }

    @After
    public void afterEach() {
        this.allocator.close();
    }

    @Parameterized.Parameters(name="reuseVectorSchemaRoot = {0}")
    public static Collection<Object[]> getTestData() {
        return Arrays.asList({false}, {true});
    }

    @Test
    public void testUnreliableMetaDataPrecisionAndScale() throws Exception {
        ResultSet rs = this.buildIncorrectPrecisionAndScaleMetaDataResultSet();
        ResultSetMetaData rsmd = rs.getMetaData();
        Assert.assertEquals((String)"Column type should be Types.DECIMAL", (long)3L, (long)rsmd.getColumnType(1));
        Assert.assertEquals((String)"Column scale should be zero", (long)0L, (long)rsmd.getScale(1));
        Assert.assertEquals((String)"Column precision should be zero", (long)0L, (long)rsmd.getPrecision(1));
        rs.next();
        BigDecimal bd1 = rs.getBigDecimal(1);
        Assert.assertEquals((String)"Value should be 1000000000000000.01", (Object)new BigDecimal("1000000000000000.01"), (Object)bd1);
        Assert.assertEquals((String)"Value scale should be 2", (long)2L, (long)bd1.scale());
        Assert.assertEquals((String)"Value precision should be 18", (long)18L, (long)bd1.precision());
        Assert.assertFalse((String)"No more rows!", (boolean)rs.next());
        rs.beforeFirst();
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder(this.allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(this.reuseVectorSchemaRoot).build();
        try (ArrowVectorIterator iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);){
            Assert.assertTrue((boolean)iter.hasNext());
            Assertions.assertThrows(RuntimeException.class, () -> ((ArrowVectorIterator)iter).next(), (String)"Expected to fail due to mismatched metadata!");
        }
        rs.beforeFirst();
        JdbcFieldInfo explicitMappingField = new JdbcFieldInfo(3, 18, 2);
        HashMap<Integer, JdbcFieldInfo> explicitMapping = new HashMap<Integer, JdbcFieldInfo>();
        explicitMapping.put(1, explicitMappingField);
        config = new JdbcToArrowConfigBuilder(this.allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(this.reuseVectorSchemaRoot).setExplicitTypesByColumnIndex(explicitMapping).build();
        try (ArrowVectorIterator iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);){
            while (iter.hasNext()) {
                iter.next();
            }
        }
    }

    @Test
    public void testInconsistentPrecisionAndScale() throws Exception {
        ResultSet rs = this.buildVaryingPrecisionAndScaleResultSet();
        ResultSetMetaData rsmd = rs.getMetaData();
        Assert.assertEquals((String)"Column type should be Types.DECIMAL", (long)3L, (long)rsmd.getColumnType(1));
        Assert.assertEquals((String)"Column scale should be zero", (long)0L, (long)rsmd.getScale(1));
        Assert.assertEquals((String)"Column precision should be zero", (long)0L, (long)rsmd.getPrecision(1));
        rs.next();
        BigDecimal bd1 = rs.getBigDecimal(1);
        Assert.assertEquals((String)"Value should be 1000000000000000.01", (Object)new BigDecimal("1000000000000000.01"), (Object)bd1);
        Assert.assertEquals((String)"Value scale should be 2", (long)2L, (long)bd1.scale());
        Assert.assertEquals((String)"Value precision should be 18", (long)18L, (long)bd1.precision());
        rs.next();
        BigDecimal bd2 = rs.getBigDecimal(1);
        Assert.assertEquals((String)"Value should be 1000000000300.0000001", (Object)new BigDecimal("1000000000300.0000001"), (Object)bd2);
        Assert.assertEquals((String)"Value scale should be 7", (long)7L, (long)bd2.scale());
        Assert.assertEquals((String)"Value precision should be 20", (long)20L, (long)bd2.precision());
        rs.beforeFirst();
        JdbcFieldInfo explicitMappingField = new JdbcFieldInfo(3, 20, 7);
        HashMap<Integer, JdbcFieldInfo> explicitMapping = new HashMap<Integer, JdbcFieldInfo>();
        explicitMapping.put(1, explicitMappingField);
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder(this.allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(this.reuseVectorSchemaRoot).setExplicitTypesByColumnIndex(explicitMapping).build();
        try (ArrowVectorIterator iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);){
            Assert.assertTrue((boolean)iter.hasNext());
            Assertions.assertThrows(RuntimeException.class, () -> ((ArrowVectorIterator)iter).next(), (String)"This is expected to fail due to inconsistent BigDecimal scales, while strict matching is enabled.");
        }
        config = new JdbcToArrowConfigBuilder(this.allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(this.reuseVectorSchemaRoot).setExplicitTypesByColumnIndex(explicitMapping).setBigDecimalRoundingMode(RoundingMode.UNNECESSARY).build();
        iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);
        var9_9 = null;
        try {
            while (iter.hasNext()) {
                iter.next();
            }
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (iter != null) {
                UnreliableMetaDataTest.$closeResource(var9_9, (AutoCloseable)iter);
            }
        }
    }

    @Test
    public void testIncorrectNullability() throws Exception {
        ResultSetUtility.MockResultSetMetaData.MockColumnMetaData columnMetaData = ResultSetUtility.MockResultSetMetaData.MockColumnMetaData.builder().index(1).sqlType(4).nullable(0).build();
        ResultSetUtility.MockResultSetMetaData metadata = new ResultSetUtility.MockResultSetMetaData(Collections.singletonList(columnMetaData));
        ResultSetUtility.MockResultSet.Builder resultSetBuilder = ResultSetUtility.MockResultSet.builder().setMetaData(metadata).addDataElement(new ResultSetUtility.MockDataElement(1024, 4)).finishRow().addDataElement(new ResultSetUtility.MockDataElement(null, 4)).finishRow();
        Schema notNullSchema = new Schema(Collections.singletonList(Field.notNullable(null, (ArrowType)new ArrowType.Int(32, true))));
        Schema nullSchema = new Schema(Collections.singletonList(Field.nullable(null, (ArrowType)new ArrowType.Int(32, true))));
        try (ResultSetUtility.MockResultSet rs = resultSetBuilder.build();){
            IntVector ints;
            VectorSchemaRoot root;
            JdbcToArrowConfig config = new JdbcToArrowConfigBuilder(this.allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(this.reuseVectorSchemaRoot).build();
            try (ArrowVectorIterator iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);){
                Assert.assertTrue((boolean)iter.hasNext());
                VectorSchemaRoot root2 = iter.next();
                Assert.assertEquals((Object)notNullSchema, (Object)root2.getSchema());
                Assert.assertEquals((long)2L, (long)root2.getRowCount());
                IntVector ints2 = (IntVector)root2.getVector(0);
                Assert.assertEquals((long)1024L, (long)ints2.get(0));
                Assert.assertFalse((boolean)ints2.isNull(1));
                Assert.assertFalse((boolean)iter.hasNext());
            }
            rs.beforeFirst();
            HashMap<Integer, JdbcFieldInfo> typeMapping = new HashMap<Integer, JdbcFieldInfo>();
            JdbcFieldInfo realFieldInfo = new JdbcFieldInfo(4, 1, 0, 0);
            typeMapping.put(1, realFieldInfo);
            config = new JdbcToArrowConfigBuilder(this.allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(this.reuseVectorSchemaRoot).setExplicitTypesByColumnIndex(typeMapping).build();
            try (ArrowVectorIterator iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);){
                Assert.assertTrue((boolean)iter.hasNext());
                root = iter.next();
                Assert.assertEquals((Object)nullSchema, (Object)root.getSchema());
                Assert.assertEquals((long)2L, (long)root.getRowCount());
                ints = (IntVector)root.getVector(0);
                Assert.assertEquals((long)1024L, (long)ints.get(0));
                Assert.assertTrue((boolean)ints.isNull(1));
                Assert.assertFalse((boolean)iter.hasNext());
            }
            rs.beforeFirst();
            realFieldInfo = new JdbcFieldInfo(4, 2, 0, 0);
            typeMapping.put(1, realFieldInfo);
            config = new JdbcToArrowConfigBuilder(this.allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(this.reuseVectorSchemaRoot).setExplicitTypesByColumnIndex(typeMapping).build();
            iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);
            var12_14 = null;
            try {
                Assert.assertTrue((boolean)iter.hasNext());
                root = iter.next();
                Assert.assertEquals((Object)notNullSchema, (Object)root.getSchema());
                Assert.assertEquals((long)2L, (long)root.getRowCount());
                ints = (IntVector)root.getVector(0);
                Assert.assertEquals((long)1024L, (long)ints.get(0));
                Assert.assertFalse((boolean)ints.isNull(1));
                Assert.assertFalse((boolean)iter.hasNext());
            }
            catch (Throwable throwable) {
                var12_14 = throwable;
                throw throwable;
            }
            finally {
                if (iter != null) {
                    UnreliableMetaDataTest.$closeResource(var12_14, (AutoCloseable)iter);
                }
            }
        }
    }

    private ResultSet buildIncorrectPrecisionAndScaleMetaDataResultSet() throws SQLException {
        ResultSetUtility.MockResultSetMetaData.MockColumnMetaData columnMetaData = ResultSetUtility.MockResultSetMetaData.MockColumnMetaData.builder().index(1).sqlType(3).precision(0).scale(0).build();
        ArrayList<ResultSetUtility.MockResultSetMetaData.MockColumnMetaData> cols = new ArrayList<ResultSetUtility.MockResultSetMetaData.MockColumnMetaData>();
        cols.add(columnMetaData);
        ResultSetUtility.MockResultSetMetaData metadata = new ResultSetUtility.MockResultSetMetaData(cols);
        return ResultSetUtility.MockResultSet.builder().setMetaData(metadata).addDataElement(new ResultSetUtility.MockDataElement(new BigDecimal("1000000000000000.01"), 3)).finishRow().build();
    }

    private ResultSet buildVaryingPrecisionAndScaleResultSet() throws SQLException {
        ResultSetUtility.MockResultSetMetaData.MockColumnMetaData columnMetaData = ResultSetUtility.MockResultSetMetaData.MockColumnMetaData.builder().index(1).sqlType(3).precision(0).scale(0).build();
        ArrayList<ResultSetUtility.MockResultSetMetaData.MockColumnMetaData> cols = new ArrayList<ResultSetUtility.MockResultSetMetaData.MockColumnMetaData>();
        cols.add(columnMetaData);
        ResultSetUtility.MockResultSetMetaData metadata = new ResultSetUtility.MockResultSetMetaData(cols);
        return ResultSetUtility.MockResultSet.builder().setMetaData(metadata).addDataElement(new ResultSetUtility.MockDataElement(new BigDecimal("1000000000000000.01"), 3)).finishRow().addDataElement(new ResultSetUtility.MockDataElement(new BigDecimal("1000000000300.0000001"), 3)).finishRow().build();
    }
}

