/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.arrow.adapter.jdbc.consumer.AbstractConsumerTest;
import org.apache.arrow.adapter.jdbc.consumer.BinaryConsumer;
import org.apache.arrow.vector.VarBinaryVector;
import org.junit.Assert;
import org.junit.Test;

public class BinaryConsumerTest
extends AbstractConsumerTest {
    private static final int INITIAL_VALUE_ALLOCATION = 3970;
    private static final int DEFAULT_RECORD_BYTE_COUNT = 8;

    protected void assertConsume(boolean nullable, InputStreamConsumer dataConsumer, byte[][] expect) throws IOException {
        try (VarBinaryVector vector = new VarBinaryVector("binary", this.allocator);){
            BinaryConsumer consumer = BinaryConsumer.createConsumer((VarBinaryVector)vector, (int)0, (boolean)nullable);
            dataConsumer.consume(consumer);
            Assert.assertEquals((long)(expect.length - 1), (long)vector.getLastSet());
            for (int i = 0; i < expect.length; ++i) {
                byte[] value = expect[i];
                if (value == null) {
                    Assert.assertTrue((boolean)vector.isNull(i));
                    continue;
                }
                Assert.assertArrayEquals((byte[])expect[i], (byte[])vector.get(i));
            }
        }
    }

    private byte[] createBytes(int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(i % 1024);
        }
        return bytes;
    }

    public void testConsumeInputStream(byte[][] values, boolean nullable) throws IOException {
        this.assertConsume(nullable, binaryConsumer -> {
            for (byte[] value : values) {
                binaryConsumer.consume((InputStream)new ByteArrayInputStream(value));
                binaryConsumer.moveWriterPosition();
            }
        }, values);
    }

    @Test
    public void testConsumeInputStream() throws IOException {
        this.testConsumeInputStream(new byte[][]{this.createBytes(8)}, false);
        this.testConsumeInputStream(new byte[][]{this.createBytes(8), this.createBytes(8)}, false);
        this.testConsumeInputStream(new byte[][]{this.createBytes(16), this.createBytes(8), this.createBytes(8)}, false);
        this.testConsumeInputStream(new byte[][]{this.createBytes(31760)}, false);
        this.testConsumeInputStream(new byte[][]{this.createBytes(317600)}, false);
        this.testConsumeInputStream(new byte[][]{this.createBytes(31760), this.createBytes(31760)}, false);
        this.testConsumeInputStream(new byte[][]{this.createBytes(31760), this.createBytes(8), this.createBytes(31760)}, false);
        byte[][] testRecords = new byte[7940][];
        for (int i = 0; i < testRecords.length; ++i) {
            testRecords[i] = this.createBytes(8);
        }
        this.testConsumeInputStream(testRecords, false);
    }

    static interface InputStreamConsumer {
        public void consume(BinaryConsumer var1) throws IOException;
    }
}

