/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.h2;

import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import org.apache.arrow.adapter.jdbc.AbstractJdbcToArrowTest;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowTestHelper;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adapter.jdbc.Table;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JdbcToArrowDataTypesTest
extends AbstractJdbcToArrowTest {
    private static final String BIGINT = "big_int";
    private static final String BINARY = "binary";
    private static final String BIT = "bit";
    private static final String BLOB = "blob";
    private static final String BOOL = "bool";
    private static final String CHAR = "char";
    private static final String CLOB = "clob";
    private static final String DATE = "date";
    private static final String DECIMAL = "decimal";
    private static final String DOUBLE = "double";
    private static final String INT = "int";
    private static final String LIST = "list";
    private static final String REAL = "real";
    private static final String SMALLINT = "small_int";
    private static final String TIME = "time";
    private static final String TIMESTAMP = "timestamp";
    private static final String TINYINT = "tiny_int";
    private static final String VARCHAR = "varchar";
    private static final String NULL = "null";
    private static final String[] testFiles = new String[]{"h2/test1_bigint_h2.yml", "h2/test1_binary_h2.yml", "h2/test1_bit_h2.yml", "h2/test1_blob_h2.yml", "h2/test1_bool_h2.yml", "h2/test1_char_h2.yml", "h2/test1_clob_h2.yml", "h2/test1_date_h2.yml", "h2/test1_decimal_h2.yml", "h2/test1_double_h2.yml", "h2/test1_int_h2.yml", "h2/test1_list_h2.yml", "h2/test1_real_h2.yml", "h2/test1_smallint_h2.yml", "h2/test1_time_h2.yml", "h2/test1_timestamp_h2.yml", "h2/test1_tinyint_h2.yml", "h2/test1_varchar_h2.yml", "h2/test1_null_h2.yml"};

    public JdbcToArrowDataTypesTest(Table table) {
        this.table = table;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getTestData() throws SQLException, ClassNotFoundException, IOException {
        return Arrays.asList(JdbcToArrowDataTypesTest.prepareTestData(testFiles, JdbcToArrowDataTypesTest.class));
    }

    @Override
    @Test
    public void testJdbcToArrowValues() throws SQLException, IOException {
        this.testDataSets(this.sqlToArrow(this.conn, this.table.getQuery(), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()), false);
        this.testDataSets(this.sqlToArrow(this.conn, this.table.getQuery(), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE)), false);
        this.testDataSets(JdbcToArrowDataTypesTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery()), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()), false);
        this.testDataSets(JdbcToArrowDataTypesTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery())), false);
        this.testDataSets(JdbcToArrowDataTypesTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery()), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE)), false);
        this.testDataSets(JdbcToArrowDataTypesTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery()), Calendar.getInstance()), false);
        this.testDataSets(JdbcToArrowDataTypesTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery()), new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build()), false);
        this.testDataSets(JdbcToArrowDataTypesTest.sqlToArrow(this.conn, this.table.getQuery(), new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build()), false);
    }

    @Test
    public void testJdbcSchemaMetadata() throws SQLException {
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(0L), Calendar.getInstance(), true).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build();
        ResultSetMetaData rsmd = this.conn.createStatement().executeQuery(this.table.getQuery()).getMetaData();
        Schema schema = JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)rsmd, (JdbcToArrowConfig)config);
        JdbcToArrowTestHelper.assertFieldMetadataMatchesResultSetMetadata(rsmd, schema);
    }

    @Override
    public void testDataSets(VectorSchemaRoot root, boolean isIncludeMapVector) {
        JdbcToArrowTestHelper.assertFieldMetadataIsEmpty(root);
        switch (this.table.getType()) {
            case "big_int": {
                JdbcToArrowTestHelper.assertBigIntVectorValues((BigIntVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getLongValues());
                break;
            }
            case "binary": 
            case "blob": {
                JdbcToArrowTestHelper.assertVarBinaryVectorValues((VarBinaryVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getBinaryValues());
                break;
            }
            case "bit": {
                JdbcToArrowTestHelper.assertBitVectorValues((BitVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getIntValues());
                break;
            }
            case "bool": {
                JdbcToArrowTestHelper.assertBooleanVectorValues((BitVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getBoolValues());
                break;
            }
            case "char": 
            case "varchar": 
            case "clob": {
                JdbcToArrowTestHelper.assertVarcharVectorValues((VarCharVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getCharValues());
                break;
            }
            case "date": {
                JdbcToArrowTestHelper.assertDateVectorValues((DateDayVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getIntValues());
                break;
            }
            case "time": {
                JdbcToArrowTestHelper.assertTimeVectorValues((TimeMilliVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getLongValues());
                break;
            }
            case "timestamp": {
                JdbcToArrowTestHelper.assertTimeStampVectorValues((TimeStampVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getLongValues());
                break;
            }
            case "decimal": {
                JdbcToArrowTestHelper.assertDecimalVectorValues((DecimalVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getBigDecimalValues());
                break;
            }
            case "double": {
                JdbcToArrowTestHelper.assertFloat8VectorValues((Float8Vector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getDoubleValues());
                break;
            }
            case "int": {
                JdbcToArrowTestHelper.assertIntVectorValues((IntVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getIntValues());
                break;
            }
            case "small_int": {
                JdbcToArrowTestHelper.assertSmallIntVectorValues((SmallIntVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getIntValues());
                break;
            }
            case "tiny_int": {
                JdbcToArrowTestHelper.assertTinyIntVectorValues((TinyIntVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getIntValues());
                break;
            }
            case "real": {
                JdbcToArrowTestHelper.assertFloat4VectorValues((Float4Vector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getFloatValues());
                break;
            }
            case "null": {
                JdbcToArrowTestHelper.assertNullVectorValues((NullVector)root.getVector(this.table.getVector()), this.table.getRowCount());
                break;
            }
            case "list": {
                JdbcToArrowTestHelper.assertListVectorValues((ListVector)root.getVector(this.table.getVector()), this.table.getValues().length, this.table.getListValues());
                break;
            }
        }
    }
}

