/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.h2;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.apache.arrow.adapter.jdbc.AbstractJdbcToArrowTest;
import org.apache.arrow.adapter.jdbc.JdbcToArrowTestHelper;
import org.apache.arrow.adapter.jdbc.Table;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Field;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JdbcToArrowOptionalColumnsTest
extends AbstractJdbcToArrowTest {
    private static final String[] testFiles = new String[]{"h2/test1_null_and_notnull.yml"};

    public JdbcToArrowOptionalColumnsTest(Table table) {
        this.table = table;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getTestData() throws SQLException, ClassNotFoundException, IOException {
        return Arrays.asList(JdbcToArrowOptionalColumnsTest.prepareTestData(testFiles, JdbcToArrowOptionalColumnsTest.class));
    }

    @Override
    @Test
    public void testJdbcToArrowValues() throws SQLException, IOException {
        this.testDataSets(this.sqlToArrow(this.conn, this.table.getQuery(), (BufferAllocator)new RootAllocator(Integer.MAX_VALUE)), false);
    }

    @Override
    public void testDataSets(VectorSchemaRoot root, boolean isIncludeMapVector) {
        JdbcToArrowTestHelper.assertFieldMetadataIsEmpty(root);
        TestCase.assertTrue((boolean)((Field)root.getSchema().getFields().get(0)).isNullable());
        Assert.assertFalse((boolean)((Field)root.getSchema().getFields().get(1)).isNullable());
    }
}

