/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.h2;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.apache.arrow.adapter.jdbc.ArrowVectorIterator;
import org.apache.arrow.adapter.jdbc.JdbcToArrow;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowTestHelper;
import org.apache.arrow.adapter.jdbc.Table;
import org.apache.arrow.adapter.jdbc.h2.JdbcToArrowTest;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JdbcToArrowVectorIteratorTest
extends JdbcToArrowTest {
    public JdbcToArrowVectorIteratorTest(Table table, boolean reuseVectorSchemaRoot) {
        super(table, reuseVectorSchemaRoot);
    }

    @Override
    @Test
    public void testJdbcToArrowValues() throws SQLException, IOException {
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).setTargetBatchSize(3).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build();
        ArrowVectorIterator iterator = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)this.conn.createStatement().executeQuery(this.table.getQuery()), (JdbcToArrowConfig)config);
        this.validate(iterator);
    }

    @Test
    public void testVectorSchemaRootReuse() throws SQLException, IOException {
        Integer[][] intValues = new Integer[][]{{101, 102, 103}, {104, null, null}, {107, 108, 109}, {110}};
        Integer[][][] listValues = new Integer[][][]{{{1, 2, 3}, {1, 2}, {1}}, {{2, 3, 4}, {2, 3}, {2}}, {{3, 4, 5}, {3, 4}, {3}}, {new Integer[0]}};
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).setTargetBatchSize(3).setReuseVectorSchemaRoot(this.reuseVectorSchemaRoot).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build();
        ArrowVectorIterator iterator = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)this.conn.createStatement().executeQuery(this.table.getQuery()), (JdbcToArrowConfig)config);
        int batchCount = 0;
        VectorSchemaRoot prev = null;
        while (iterator.hasNext()) {
            VectorSchemaRoot cur = iterator.next();
            Assert.assertNotNull((Object)cur);
            ArrayList<IntVector> intVectors = new ArrayList<IntVector>();
            intVectors.add((IntVector)cur.getVector(0));
            this.assertIntVectorValues(intVectors, intValues[batchCount].length, intValues[batchCount]);
            ArrayList<ListVector> listVectors = new ArrayList<ListVector>();
            listVectors.add((ListVector)cur.getVector(18));
            JdbcToArrowVectorIteratorTest.assertListVectorValues(listVectors, listValues[batchCount].length, listValues[batchCount]);
            if (prev != null) {
                if (this.reuseVectorSchemaRoot) {
                    Assertions.assertTrue((prev == cur ? 1 : 0) != 0);
                } else {
                    Assert.assertFalse((prev == cur ? 1 : 0) != 0);
                    cur.close();
                }
            }
            prev = cur;
            ++batchCount;
        }
        Assertions.assertTrue((batchCount > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testJdbcToArrowValuesNoLimit() throws SQLException, IOException {
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).setTargetBatchSize(-1).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build();
        ArrowVectorIterator iterator = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)this.conn.createStatement().executeQuery(this.table.getQuery()), (JdbcToArrowConfig)config);
        this.validate(iterator);
    }

    @Test
    public void testTimeStampConsumer() throws SQLException, IOException {
        VectorSchemaRoot root;
        String sql = "select timestamp_field11 from table1";
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).setTargetBatchSize(3).setReuseVectorSchemaRoot(this.reuseVectorSchemaRoot).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build();
        Assert.assertNotNull((Object)config.getCalendar());
        try (ArrowVectorIterator iterator = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)this.conn.createStatement().executeQuery("select timestamp_field11 from table1"), (JdbcToArrowConfig)config);){
            root = iterator.next();
            Assert.assertEquals((long)1L, (long)root.getFieldVectors().size());
            Assertions.assertTrue((boolean)(root.getVector(0) instanceof TimeStampMilliTZVector));
        }
        config = new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), null).setTargetBatchSize(3).setReuseVectorSchemaRoot(this.reuseVectorSchemaRoot).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build();
        Assertions.assertNull((Object)config.getCalendar());
        iterator = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)this.conn.createStatement().executeQuery("select timestamp_field11 from table1"), (JdbcToArrowConfig)config);
        var4_4 = null;
        try {
            root = iterator.next();
            Assert.assertEquals((long)1L, (long)root.getFieldVectors().size());
            Assertions.assertTrue((boolean)(root.getVector(0) instanceof TimeStampMilliVector));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                JdbcToArrowVectorIteratorTest.$closeResource(var4_4, (AutoCloseable)iterator);
            }
        }
    }

    private void validate(ArrowVectorIterator iterator) throws SQLException, IOException {
        ArrayList<BigIntVector> bigIntVectors = new ArrayList<BigIntVector>();
        ArrayList<TinyIntVector> tinyIntVectors = new ArrayList<TinyIntVector>();
        ArrayList<IntVector> intVectors = new ArrayList<IntVector>();
        ArrayList<SmallIntVector> smallIntVectors = new ArrayList<SmallIntVector>();
        ArrayList<VarBinaryVector> vectorsForBinary = new ArrayList<VarBinaryVector>();
        ArrayList<VarBinaryVector> vectorsForBlob = new ArrayList<VarBinaryVector>();
        ArrayList<VarCharVector> vectorsForClob = new ArrayList<VarCharVector>();
        ArrayList<VarCharVector> vectorsForVarChar = new ArrayList<VarCharVector>();
        ArrayList<VarCharVector> vectorsForChar = new ArrayList<VarCharVector>();
        ArrayList<BitVector> vectorsForBit = new ArrayList<BitVector>();
        ArrayList<BitVector> vectorsForBool = new ArrayList<BitVector>();
        ArrayList<DateDayVector> dateDayVectors = new ArrayList<DateDayVector>();
        ArrayList<TimeMilliVector> timeMilliVectors = new ArrayList<TimeMilliVector>();
        ArrayList<TimeStampVector> timeStampVectors = new ArrayList<TimeStampVector>();
        ArrayList<DecimalVector> decimalVectors = new ArrayList<DecimalVector>();
        ArrayList<Float4Vector> float4Vectors = new ArrayList<Float4Vector>();
        ArrayList<Float8Vector> float8Vectors = new ArrayList<Float8Vector>();
        ArrayList<ListVector> listVectors = new ArrayList<ListVector>();
        ArrayList<VectorSchemaRoot> roots = new ArrayList<VectorSchemaRoot>();
        while (iterator.hasNext()) {
            VectorSchemaRoot root2 = iterator.next();
            roots.add(root2);
            JdbcToArrowTestHelper.assertFieldMetadataIsEmpty(root2);
            bigIntVectors.add((BigIntVector)root2.getVector("BIGINT_FIELD5"));
            tinyIntVectors.add((TinyIntVector)root2.getVector("TINYINT_FIELD3"));
            intVectors.add((IntVector)root2.getVector("INT_FIELD1"));
            smallIntVectors.add((SmallIntVector)root2.getVector("SMALLINT_FIELD4"));
            vectorsForBinary.add((VarBinaryVector)root2.getVector("BINARY_FIELD12"));
            vectorsForBlob.add((VarBinaryVector)root2.getVector("BLOB_FIELD14"));
            vectorsForClob.add((VarCharVector)root2.getVector("CLOB_FIELD15"));
            vectorsForVarChar.add((VarCharVector)root2.getVector("VARCHAR_FIELD13"));
            vectorsForChar.add((VarCharVector)root2.getVector("CHAR_FIELD16"));
            vectorsForBit.add((BitVector)root2.getVector("BIT_FIELD17"));
            vectorsForBool.add((BitVector)root2.getVector("BOOL_FIELD2"));
            dateDayVectors.add((DateDayVector)root2.getVector("DATE_FIELD10"));
            timeMilliVectors.add((TimeMilliVector)root2.getVector("TIME_FIELD9"));
            timeStampVectors.add((TimeStampVector)root2.getVector("TIMESTAMP_FIELD11"));
            decimalVectors.add((DecimalVector)root2.getVector("DECIMAL_FIELD6"));
            float4Vectors.add((Float4Vector)root2.getVector("REAL_FIELD8"));
            float8Vectors.add((Float8Vector)root2.getVector("DOUBLE_FIELD7"));
            listVectors.add((ListVector)root2.getVector("LIST_FIELD19"));
        }
        this.assertBigIntVectorValues(bigIntVectors, this.table.getRowCount(), JdbcToArrowTestHelper.getLongValues(this.table.getValues(), "BIGINT_FIELD5"));
        this.assertTinyIntVectorValues(tinyIntVectors, this.table.getRowCount(), JdbcToArrowTestHelper.getIntValues(this.table.getValues(), "TINYINT_FIELD3"));
        this.assertIntVectorValues(intVectors, this.table.getRowCount(), JdbcToArrowTestHelper.getIntValues(this.table.getValues(), "INT_FIELD1"));
        this.assertSmallIntVectorValues(smallIntVectors, this.table.getRowCount(), JdbcToArrowTestHelper.getIntValues(this.table.getValues(), "SMALLINT_FIELD4"));
        this.assertBinaryVectorValues(vectorsForBinary, this.table.getRowCount(), JdbcToArrowTestHelper.getBinaryValues(this.table.getValues(), "BINARY_FIELD12"));
        this.assertBinaryVectorValues(vectorsForBlob, this.table.getRowCount(), JdbcToArrowTestHelper.getBinaryValues(this.table.getValues(), "BLOB_FIELD14"));
        this.assertVarCharVectorValues(vectorsForClob, this.table.getRowCount(), JdbcToArrowTestHelper.getCharArray(this.table.getValues(), "CLOB_FIELD15"));
        this.assertVarCharVectorValues(vectorsForVarChar, this.table.getRowCount(), JdbcToArrowTestHelper.getCharArray(this.table.getValues(), "VARCHAR_FIELD13"));
        this.assertVarCharVectorValues(vectorsForChar, this.table.getRowCount(), JdbcToArrowTestHelper.getCharArray(this.table.getValues(), "CHAR_FIELD16"));
        this.assertBitVectorValues(vectorsForBit, this.table.getRowCount(), JdbcToArrowTestHelper.getIntValues(this.table.getValues(), "BIT_FIELD17"));
        this.assertBooleanVectorValues(vectorsForBool, this.table.getRowCount(), JdbcToArrowTestHelper.getBooleanValues(this.table.getValues(), "BOOL_FIELD2"));
        this.assertDateDayVectorValues(dateDayVectors, this.table.getRowCount(), JdbcToArrowTestHelper.getLongValues(this.table.getValues(), "DATE_FIELD10"));
        this.assertTimeMilliVectorValues(timeMilliVectors, this.table.getRowCount(), JdbcToArrowTestHelper.getLongValues(this.table.getValues(), "TIME_FIELD9"));
        this.assertTimeStampVectorValues(timeStampVectors, this.table.getRowCount(), JdbcToArrowTestHelper.getLongValues(this.table.getValues(), "TIMESTAMP_FIELD11"));
        this.assertDecimalVectorValues(decimalVectors, this.table.getRowCount(), JdbcToArrowTestHelper.getDecimalValues(this.table.getValues(), "DECIMAL_FIELD6"));
        this.assertFloat4VectorValues(float4Vectors, this.table.getRowCount(), JdbcToArrowTestHelper.getFloatValues(this.table.getValues(), "REAL_FIELD8"));
        this.assertFloat8VectorValues(float8Vectors, this.table.getRowCount(), JdbcToArrowTestHelper.getDoubleValues(this.table.getValues(), "DOUBLE_FIELD7"));
        JdbcToArrowVectorIteratorTest.assertListVectorValues(listVectors, this.table.getRowCount(), JdbcToArrowTestHelper.getListValues(this.table.getValues(), "LIST_FIELD19"));
        roots.forEach(root -> root.close());
    }

    private void assertFloat8VectorValues(List<Float8Vector> vectors, int rowCount, Double[] values) {
        int valueCount = vectors.stream().mapToInt(ValueVector::getValueCount).sum();
        Assert.assertEquals((long)rowCount, (long)valueCount);
        int index = 0;
        for (Float8Vector vector : vectors) {
            for (int i = 0; i < vector.getValueCount(); ++i) {
                Assert.assertEquals((double)values[index++], (double)vector.get(i), (double)0.01);
            }
        }
    }

    private void assertFloat4VectorValues(List<Float4Vector> vectors, int rowCount, Float[] values) {
        int valueCount = vectors.stream().mapToInt(ValueVector::getValueCount).sum();
        Assert.assertEquals((long)rowCount, (long)valueCount);
        int index = 0;
        for (Float4Vector vector : vectors) {
            for (int i = 0; i < vector.getValueCount(); ++i) {
                Assert.assertEquals((double)values[index++].floatValue(), (double)vector.get(i), (double)0.01);
            }
        }
    }

    private void assertDecimalVectorValues(List<DecimalVector> vectors, int rowCount, BigDecimal[] values) {
        int valueCount = vectors.stream().mapToInt(ValueVector::getValueCount).sum();
        Assert.assertEquals((long)rowCount, (long)valueCount);
        int index = 0;
        for (DecimalVector vector : vectors) {
            for (int i = 0; i < vector.getValueCount(); ++i) {
                Assert.assertNotNull((Object)vector.getObject(i));
                Assert.assertEquals((double)values[index++].doubleValue(), (double)vector.getObject(i).doubleValue(), (double)0.0);
            }
        }
    }

    private void assertTimeStampVectorValues(List<TimeStampVector> vectors, int rowCount, Long[] values) {
        int valueCount = vectors.stream().mapToInt(ValueVector::getValueCount).sum();
        Assert.assertEquals((long)rowCount, (long)valueCount);
        int index = 0;
        for (TimeStampVector vector : vectors) {
            for (int i = 0; i < vector.getValueCount(); ++i) {
                Assert.assertEquals((long)values[index++], (long)vector.get(i));
            }
        }
    }

    private void assertTimeMilliVectorValues(List<TimeMilliVector> vectors, int rowCount, Long[] values) {
        int valueCount = vectors.stream().mapToInt(ValueVector::getValueCount).sum();
        Assert.assertEquals((long)rowCount, (long)valueCount);
        int index = 0;
        for (TimeMilliVector vector : vectors) {
            for (int i = 0; i < vector.getValueCount(); ++i) {
                Assert.assertEquals((long)values[index++], (long)vector.get(i));
            }
        }
    }

    private void assertDateDayVectorValues(List<DateDayVector> vectors, int rowCount, Long[] values) {
        int valueCount = vectors.stream().mapToInt(ValueVector::getValueCount).sum();
        Assert.assertEquals((long)rowCount, (long)valueCount);
        int index = 0;
        for (DateDayVector vector : vectors) {
            for (int i = 0; i < vector.getValueCount(); ++i) {
                Assert.assertEquals((long)values[index++], (long)vector.get(i));
            }
        }
    }

    private void assertBitVectorValues(List<BitVector> vectors, int rowCount, Integer[] values) {
        int valueCount = vectors.stream().mapToInt(ValueVector::getValueCount).sum();
        Assert.assertEquals((long)rowCount, (long)valueCount);
        int index = 0;
        for (BitVector vector : vectors) {
            for (int i = 0; i < vector.getValueCount(); ++i) {
                Assert.assertEquals((long)values[index++].intValue(), (long)vector.get(i));
            }
        }
    }

    private void assertBooleanVectorValues(List<BitVector> vectors, int rowCount, Boolean[] values) {
        int valueCount = vectors.stream().mapToInt(ValueVector::getValueCount).sum();
        Assert.assertEquals((long)rowCount, (long)valueCount);
        int index = 0;
        for (BitVector vector : vectors) {
            for (int i = 0; i < vector.getValueCount(); ++i) {
                Assert.assertEquals((Object)values[index++], (Object)(vector.get(i) == 1 ? 1 : 0));
            }
        }
    }

    private void assertVarCharVectorValues(List<VarCharVector> vectors, int rowCount, byte[][] values) {
        int valueCount = vectors.stream().mapToInt(ValueVector::getValueCount).sum();
        Assert.assertEquals((long)rowCount, (long)valueCount);
        int index = 0;
        for (VarCharVector vector : vectors) {
            for (int i = 0; i < vector.getValueCount(); ++i) {
                Assert.assertArrayEquals((byte[])values[index++], (byte[])vector.get(i));
            }
        }
    }

    private void assertBinaryVectorValues(List<VarBinaryVector> vectors, int rowCount, byte[][] values) {
        int valueCount = vectors.stream().mapToInt(ValueVector::getValueCount).sum();
        Assert.assertEquals((long)rowCount, (long)valueCount);
        int index = 0;
        for (VarBinaryVector vector : vectors) {
            for (int i = 0; i < vector.getValueCount(); ++i) {
                Assert.assertArrayEquals((byte[])values[index++], (byte[])vector.get(i));
            }
        }
    }

    private void assertSmallIntVectorValues(List<SmallIntVector> vectors, int rowCount, Integer[] values) {
        int valueCount = vectors.stream().mapToInt(ValueVector::getValueCount).sum();
        Assert.assertEquals((long)rowCount, (long)valueCount);
        int index = 0;
        for (SmallIntVector vector : vectors) {
            for (int i = 0; i < vector.getValueCount(); ++i) {
                Assert.assertEquals((long)values[index++].intValue(), (long)vector.get(i));
            }
        }
    }

    private void assertTinyIntVectorValues(List<TinyIntVector> vectors, int rowCount, Integer[] values) {
        int valueCount = vectors.stream().mapToInt(ValueVector::getValueCount).sum();
        Assert.assertEquals((long)rowCount, (long)valueCount);
        int index = 0;
        for (TinyIntVector vector : vectors) {
            for (int i = 0; i < vector.getValueCount(); ++i) {
                Assert.assertEquals((long)values[index++].intValue(), (long)vector.get(i));
            }
        }
    }

    private void assertBigIntVectorValues(List<BigIntVector> vectors, int rowCount, Long[] values) {
        int valueCount = vectors.stream().mapToInt(ValueVector::getValueCount).sum();
        Assert.assertEquals((long)rowCount, (long)valueCount);
        int index = 0;
        for (BigIntVector vector : vectors) {
            for (int i = 0; i < vector.getValueCount(); ++i) {
                Assert.assertEquals((long)values[index++], (long)vector.get(i));
            }
        }
    }

    private void assertIntVectorValues(List<IntVector> vectors, int rowCount, Integer[] values) {
        int valueCount = vectors.stream().mapToInt(ValueVector::getValueCount).sum();
        Assert.assertEquals((long)rowCount, (long)valueCount);
        int index = 0;
        for (IntVector vector : vectors) {
            for (int i = 0; i < vector.getValueCount(); ++i) {
                if (values[index] == null) {
                    Assertions.assertTrue((boolean)vector.isNull(i));
                } else {
                    Assert.assertEquals((long)values[index].longValue(), (long)vector.get(i));
                }
                ++index;
            }
        }
    }

    public static void assertListVectorValues(List<ListVector> vectors, int rowCount, Integer[][] values) {
        int valueCount = vectors.stream().mapToInt(ValueVector::getValueCount).sum();
        Assert.assertEquals((long)rowCount, (long)valueCount);
        int index = 0;
        for (ListVector vector : vectors) {
            for (int i = 0; i < vector.getValueCount(); ++i) {
                if (values[index] == null) {
                    Assertions.assertTrue((boolean)vector.isNull(i));
                } else {
                    List list = vector.getObject(i);
                    Assert.assertEquals(Arrays.asList(values[index]), (Object)list);
                }
                ++index;
            }
        }
    }

    private FieldVector getQueryResult(JdbcToArrowConfig config) throws SQLException, IOException {
        ArrowVectorIterator iterator = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)this.conn.createStatement().executeQuery("select real_field8 from table1"), (JdbcToArrowConfig)config);
        VectorSchemaRoot root = iterator.next();
        Assert.assertEquals((long)1L, (long)root.getFieldVectors().size());
        FieldVector result = root.getVector(0);
        Assertions.assertTrue((result.getValueCount() > 0 ? 1 : 0) != 0);
        return result;
    }

    @Test
    public void testJdbcToArrowCustomTypeConversion() throws SQLException, IOException {
        JdbcToArrowConfigBuilder builder = new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).setTargetBatchSize(-1).setReuseVectorSchemaRoot(this.reuseVectorSchemaRoot).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP);
        JdbcToArrowConfig config = builder.build();
        try (FieldVector vector = this.getQueryResult(config);){
            Assertions.assertTrue((boolean)(vector instanceof Float4Vector));
        }
        builder.setJdbcToArrowTypeConverter(fieldInfo -> {
            switch (fieldInfo.getJdbcType()) {
                case 7: {
                    return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
                }
            }
            return null;
        });
        config = builder.build();
        vector = this.getQueryResult(config);
        var4_4 = null;
        try {
            Assertions.assertTrue((boolean)(vector instanceof Float8Vector));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (vector != null) {
                JdbcToArrowVectorIteratorTest.$closeResource(var4_4, (AutoCloseable)vector);
            }
        }
    }
}

