/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.binder;

import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.binder.BaseColumnBinder;
import org.apache.arrow.memory.util.ArrowBufPointer;
import org.apache.arrow.vector.ElementAddressableVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VariableWidthVector;

public class VarCharBinder<T extends FieldVector & VariableWidthVector>
extends BaseColumnBinder<T> {
    private final ArrowBufPointer element = new ArrowBufPointer();

    public VarCharBinder(T vector, int jdbcType) {
        super(vector, jdbcType);
    }

    @Override
    public void bind(PreparedStatement statement, int parameterIndex, int rowIndex) throws SQLException {
        ((ElementAddressableVector)this.vector).getDataPointer(rowIndex, this.element);
        if (this.element.getBuf() == null) {
            statement.setNull(parameterIndex, this.jdbcType);
            return;
        }
        if (this.element.getLength() > Integer.MAX_VALUE) {
            String message = String.format("Length of value at index %d (%d) exceeds Integer.MAX_VALUE", rowIndex, this.element.getLength());
            throw new RuntimeException(message);
        }
        byte[] utf8Bytes = new byte[(int)this.element.getLength()];
        this.element.getBuf().getBytes(this.element.getOffset(), utf8Bytes);
        statement.setString(parameterIndex, new String(utf8Bytes, StandardCharsets.UTF_8));
    }
}

