/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.h2;

import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.arrow.adapter.jdbc.AbstractJdbcToArrowTest;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JdbcToArrowArrayTest {
    private Connection conn = null;
    private static final String CREATE_STATEMENT = "CREATE TABLE array_table (id INTEGER, int_array ARRAY, float_array ARRAY, string_array ARRAY);";
    private static final String INSERT_STATEMENT = "INSERT INTO array_table (id, int_array, float_array, string_array) VALUES (?, ?, ?, ?);";
    private static final String QUERY = "SELECT int_array, float_array, string_array FROM array_table ORDER BY id;";
    private static final String DROP_STATEMENT = "DROP TABLE array_table;";
    private static Map<String, JdbcFieldInfo> arrayFieldMapping;
    private static final String INT_ARRAY_FIELD_NAME = "INT_ARRAY";
    private static final String FLOAT_ARRAY_FIELD_NAME = "FLOAT_ARRAY";
    private static final String STRING_ARRAY_FIELD_NAME = "STRING_ARRAY";

    @Before
    public void setUp() throws Exception {
        String url = "jdbc:h2:mem:JdbcToArrowTest";
        String driver = "org.h2.Driver";
        Class.forName(driver);
        this.conn = DriverManager.getConnection(url);
        try (Statement stmt = this.conn.createStatement();){
            stmt.executeUpdate(CREATE_STATEMENT);
        }
        arrayFieldMapping = new HashMap<String, JdbcFieldInfo>();
        arrayFieldMapping.put(INT_ARRAY_FIELD_NAME, new JdbcFieldInfo(4));
        arrayFieldMapping.put(FLOAT_ARRAY_FIELD_NAME, new JdbcFieldInfo(7));
        arrayFieldMapping.put(STRING_ARRAY_FIELD_NAME, new JdbcFieldInfo(12));
    }

    @Test
    public void testReadH2Array() throws Exception {
        int rowCount = 4;
        Integer[][] intArrays = this.generateIntegerArrayField(rowCount);
        Float[][] floatArrays = this.generateFloatArrayField(rowCount);
        String[][] strArrays = this.generateStringArrayField(rowCount);
        this.insertRows(rowCount, intArrays, floatArrays, strArrays);
        try (ResultSet resultSet = this.conn.createStatement().executeQuery(QUERY);){
            ResultSetMetaData rsmd = resultSet.getMetaData();
            Assert.assertEquals((long)3L, (long)rsmd.getColumnCount());
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                Assert.assertEquals((long)2003L, (long)rsmd.getColumnType(i));
            }
            int rowNum = 0;
            while (resultSet.next()) {
                Array intArray = resultSet.getArray(INT_ARRAY_FIELD_NAME);
                Assert.assertFalse((boolean)resultSet.wasNull());
                try (ResultSet rs = intArray.getResultSet();){
                    int arrayIndex = 0;
                    while (rs.next()) {
                        Assert.assertEquals((long)intArrays[rowNum][arrayIndex].intValue(), (long)rs.getInt(2));
                        ++arrayIndex;
                    }
                    Assert.assertEquals((long)intArrays[rowNum].length, (long)arrayIndex);
                }
                Array floatArray = resultSet.getArray(FLOAT_ARRAY_FIELD_NAME);
                Assert.assertFalse((boolean)resultSet.wasNull());
                try (ResultSet rs = floatArray.getResultSet();){
                    int arrayIndex = 0;
                    while (rs.next()) {
                        Assert.assertEquals((double)floatArrays[rowNum][arrayIndex].floatValue(), (double)rs.getFloat(2), (double)0.001);
                        ++arrayIndex;
                    }
                    Assert.assertEquals((long)floatArrays[rowNum].length, (long)arrayIndex);
                }
                Array strArray = resultSet.getArray(STRING_ARRAY_FIELD_NAME);
                Assert.assertFalse((boolean)resultSet.wasNull());
                try (ResultSet rs = strArray.getResultSet();){
                    int arrayIndex = 0;
                    while (rs.next()) {
                        Assert.assertEquals((Object)strArrays[rowNum][arrayIndex], (Object)rs.getString(2));
                        ++arrayIndex;
                    }
                    Assert.assertEquals((long)strArrays[rowNum].length, (long)arrayIndex);
                }
                ++rowNum;
            }
            Assert.assertEquals((long)rowCount, (long)rowNum);
        }
    }

    @Test
    public void testJdbcToArrow() throws Exception {
        int rowCount = 4;
        Integer[][] intArrays = this.generateIntegerArrayField(rowCount);
        Float[][] floatArrays = this.generateFloatArrayField(rowCount);
        String[][] strArrays = this.generateStringArrayField(rowCount);
        this.insertRows(rowCount, intArrays, floatArrays, strArrays);
        JdbcToArrowConfigBuilder builder = new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), JdbcToArrowUtils.getUtcCalendar(), false);
        builder.setArraySubTypeByColumnNameMap(arrayFieldMapping);
        JdbcToArrowConfig config = builder.build();
        try (ResultSet resultSet = this.conn.createStatement().executeQuery(QUERY);){
            VectorSchemaRoot vector = AbstractJdbcToArrowTest.sqlToArrow(resultSet, config);
            Assert.assertEquals((long)rowCount, (long)vector.getRowCount());
            this.assertIntegerVectorEquals((ListVector)vector.getVector(INT_ARRAY_FIELD_NAME), rowCount, intArrays);
            this.assertFloatVectorEquals((ListVector)vector.getVector(FLOAT_ARRAY_FIELD_NAME), rowCount, floatArrays);
            this.assertStringVectorEquals((ListVector)vector.getVector(STRING_ARRAY_FIELD_NAME), rowCount, strArrays);
        }
    }

    @Test
    public void testJdbcToArrowWithNulls() throws Exception {
        int rowCount = 4;
        Integer[][] intArrays = new Integer[][]{null, {0}, {1}, new Integer[0]};
        Float[][] floatArrays = new Float[][]{{Float.valueOf(2.0f)}, null, {Float.valueOf(3.0f)}, new Float[0]};
        String[][] stringArrays = new String[][]{{"4"}, null, {"5"}, new String[0]};
        this.insertRows(rowCount, intArrays, floatArrays, stringArrays);
        JdbcToArrowConfigBuilder builder = new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), JdbcToArrowUtils.getUtcCalendar(), false);
        builder.setArraySubTypeByColumnNameMap(arrayFieldMapping);
        JdbcToArrowConfig config = builder.build();
        try (ResultSet resultSet = this.conn.createStatement().executeQuery(QUERY);){
            VectorSchemaRoot vector = AbstractJdbcToArrowTest.sqlToArrow(resultSet, config);
            Assert.assertEquals((long)rowCount, (long)vector.getRowCount());
            this.assertIntegerVectorEquals((ListVector)vector.getVector(INT_ARRAY_FIELD_NAME), rowCount, intArrays);
            this.assertFloatVectorEquals((ListVector)vector.getVector(FLOAT_ARRAY_FIELD_NAME), rowCount, floatArrays);
            this.assertStringVectorEquals((ListVector)vector.getVector(STRING_ARRAY_FIELD_NAME), rowCount, stringArrays);
        }
    }

    private void assertIntegerVectorEquals(ListVector listVector, int rowCount, Integer[][] expectedValues) {
        IntVector vector = (IntVector)listVector.getDataVector();
        ArrowBuf offsetBuffer = listVector.getOffsetBuffer();
        int prevOffset = 0;
        for (int row = 0; row < rowCount; ++row) {
            int offset = offsetBuffer.getInt((long)((row + 1) * 4));
            if (expectedValues[row] == null) {
                Assert.assertEquals((long)0L, (long)listVector.isSet(row));
                Assert.assertEquals((long)0L, (long)(offset - prevOffset));
                continue;
            }
            Assert.assertEquals((long)1L, (long)listVector.isSet(row));
            Assert.assertEquals((long)expectedValues[row].length, (long)(offset - prevOffset));
            for (int i = prevOffset; i < offset; ++i) {
                Assert.assertEquals((long)expectedValues[row][i - prevOffset].intValue(), (long)vector.get(i));
            }
            prevOffset = offset;
        }
    }

    private void assertFloatVectorEquals(ListVector listVector, int rowCount, Float[][] expectedValues) {
        Float4Vector vector = (Float4Vector)listVector.getDataVector();
        ArrowBuf offsetBuffer = listVector.getOffsetBuffer();
        int prevOffset = 0;
        for (int row = 0; row < rowCount; ++row) {
            int offset = offsetBuffer.getInt((long)((row + 1) * 4));
            if (expectedValues[row] == null) {
                Assert.assertEquals((long)0L, (long)listVector.isSet(row));
                Assert.assertEquals((long)0L, (long)(offset - prevOffset));
                continue;
            }
            Assert.assertEquals((long)1L, (long)listVector.isSet(row));
            Assert.assertEquals((long)expectedValues[row].length, (long)(offset - prevOffset));
            for (int i = prevOffset; i < offset; ++i) {
                Assert.assertEquals((float)expectedValues[row][i - prevOffset].floatValue(), (float)vector.get(i), (float)0.0f);
            }
            prevOffset = offset;
        }
    }

    private void assertStringVectorEquals(ListVector listVector, int rowCount, String[][] expectedValues) {
        VarCharVector vector = (VarCharVector)listVector.getDataVector();
        ArrowBuf offsetBuffer = listVector.getOffsetBuffer();
        int prevOffset = 0;
        for (int row = 0; row < rowCount; ++row) {
            int offset = offsetBuffer.getInt((long)((row + 1) * 4));
            if (expectedValues[row] == null) {
                Assert.assertEquals((long)0L, (long)listVector.isSet(row));
                Assert.assertEquals((long)0L, (long)(offset - prevOffset));
                continue;
            }
            Assert.assertEquals((long)1L, (long)listVector.isSet(row));
            Assert.assertEquals((long)expectedValues[row].length, (long)(offset - prevOffset));
            for (int i = prevOffset; i < offset; ++i) {
                Assert.assertArrayEquals((byte[])expectedValues[row][i - prevOffset].getBytes(), (byte[])vector.get(i));
            }
            prevOffset = offset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws SQLException {
        try (Statement stmt = this.conn.createStatement();){
            stmt.executeUpdate(DROP_STATEMENT);
        }
        finally {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
    }

    private Integer[][] generateIntegerArrayField(int numRows) {
        Integer[][] result = new Integer[numRows][];
        for (int i = 0; i < numRows; ++i) {
            int val = i * 4;
            result[i] = new Integer[]{val, val + 1, val + 2, val + 3};
        }
        return result;
    }

    private Float[][] generateFloatArrayField(int numRows) {
        Float[][] result = new Float[numRows][];
        for (int i = 0; i < numRows; ++i) {
            int val = i * 4;
            result[i] = new Float[]{Float.valueOf(val), Float.valueOf((float)val + 1.0f), Float.valueOf((float)val + 2.0f), Float.valueOf((float)val + 3.0f)};
        }
        return result;
    }

    private String[][] generateStringArrayField(int numRows) {
        String[][] result = new String[numRows][];
        for (int i = 0; i < numRows; ++i) {
            int val = i * 4;
            result[i] = new String[]{String.valueOf(val), String.valueOf(val + 1), String.valueOf(val + 2), String.valueOf(val + 3)};
        }
        return result;
    }

    private void insertRows(int numRows, Integer[][] integerArrays, Float[][] floatArrays, String[][] strArrays) throws SQLException {
        try (PreparedStatement stmt = this.conn.prepareStatement(INSERT_STATEMENT);){
            for (int i = 0; i < numRows; ++i) {
                Object[] integerArray = integerArrays[i];
                Object[] floatArray = floatArrays[i];
                Object[] strArray = strArrays[i];
                Array intArray = this.conn.createArrayOf("INT", integerArray);
                Array realArray = this.conn.createArrayOf("REAL", floatArray);
                Array varcharArray = this.conn.createArrayOf("VARCHAR", strArray);
                stmt.setInt(1, i);
                stmt.setArray(2, intArray);
                stmt.setArray(3, realArray);
                stmt.setArray(4, varcharArray);
                stmt.executeUpdate();
                intArray.free();
                realArray.free();
                varcharArray.free();
            }
        }
    }
}

