/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.h2;

import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Calendar;
import org.apache.arrow.adapter.jdbc.AbstractJdbcToArrowTest;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowTestHelper;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.MapVector;
import org.junit.Test;

public class JdbcToArrowMapDataTypeTest
extends AbstractJdbcToArrowTest {
    public JdbcToArrowMapDataTypeTest() throws IOException {
        this.table = JdbcToArrowMapDataTypeTest.getTable("h2/test1_map_h2.yml", JdbcToArrowMapDataTypeTest.class);
    }

    @Override
    @Test
    public void testJdbcToArrowValues() throws SQLException, IOException {
        Calendar calendar = Calendar.getInstance();
        ResultSetMetaData rsmd = this.getQueryMetaData(this.table.getQuery());
        this.testDataSets(JdbcToArrowMapDataTypeTest.sqlToArrow(this.conn.createStatement().executeQuery(this.table.getQuery()), new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).setJdbcToArrowTypeConverter(this.jdbcToArrowTypeConverter(calendar, rsmd)).build()), true);
        this.testDataSets(JdbcToArrowMapDataTypeTest.sqlToArrow(this.conn, this.table.getQuery(), new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), Calendar.getInstance()).setJdbcToArrowTypeConverter(this.jdbcToArrowTypeConverter(calendar, rsmd)).build()), true);
    }

    @Override
    public void testDataSets(VectorSchemaRoot root, boolean isIncludeMapVector) {
        JdbcToArrowTestHelper.assertMapVectorValues((MapVector)root.getVector("MAP_FIELD20"), this.table.getRowCount(), JdbcToArrowTestHelper.getMapValues(this.table.getValues(), "MAP_FIELD20"));
    }
}

