/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;

public class CompositeJdbcConsumer
implements JdbcConsumer {
    private final JdbcConsumer[] consumers;

    public CompositeJdbcConsumer(JdbcConsumer[] consumers) {
        this.consumers = consumers;
    }

    @Override
    public void consume(ResultSet rs) throws SQLException, IOException {
        for (int i = 0; i < this.consumers.length; ++i) {
            this.consumers[i].consume(rs);
        }
    }

    @Override
    public void close() {
        try {
            AutoCloseables.close((AutoCloseable[])this.consumers);
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while releasing resources.", e);
        }
    }

    public void resetValueVector(ValueVector vector) {
    }

    public void resetVectorSchemaRoot(VectorSchemaRoot root) {
        assert (root.getFieldVectors().size() == this.consumers.length);
        for (int i = 0; i < this.consumers.length; ++i) {
            this.consumers[i].resetValueVector(root.getVector(i));
        }
    }
}

