/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.binder;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import org.apache.arrow.adapter.jdbc.binder.BaseColumnBinder;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeSecVector;

public class Time32Binder
extends BaseColumnBinder<BaseFixedWidthVector> {
    private static final long TYPE_WIDTH = 4L;
    private final long factor;

    public Time32Binder(TimeSecVector vector) {
        this(vector, 92);
    }

    public Time32Binder(TimeMilliVector vector) {
        this(vector, 92);
    }

    public Time32Binder(TimeSecVector vector, int jdbcType) {
        this((BaseFixedWidthVector)vector, 1000L, jdbcType);
    }

    public Time32Binder(TimeMilliVector vector, int jdbcType) {
        this((BaseFixedWidthVector)vector, 1L, jdbcType);
    }

    Time32Binder(BaseFixedWidthVector vector, long factor, int jdbcType) {
        super(vector, jdbcType);
        this.factor = factor;
    }

    @Override
    public void bind(PreparedStatement statement, int parameterIndex, int rowIndex) throws SQLException {
        Time value = new Time((long)((BaseFixedWidthVector)this.vector).getDataBuffer().getInt((long)rowIndex * 4L) * this.factor);
        statement.setTime(parameterIndex, value);
    }
}

