/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.binder;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import org.apache.arrow.adapter.jdbc.binder.BaseColumnBinder;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeNanoVector;

public class Time64Binder
extends BaseColumnBinder<BaseFixedWidthVector> {
    private static final long TYPE_WIDTH = 8L;
    private final long factor;

    public Time64Binder(TimeMicroVector vector) {
        this(vector, 92);
    }

    public Time64Binder(TimeNanoVector vector) {
        this(vector, 92);
    }

    public Time64Binder(TimeMicroVector vector, int jdbcType) {
        this((BaseFixedWidthVector)vector, 1000L, jdbcType);
    }

    public Time64Binder(TimeNanoVector vector, int jdbcType) {
        this((BaseFixedWidthVector)vector, 1000000L, jdbcType);
    }

    Time64Binder(BaseFixedWidthVector vector, long factor, int jdbcType) {
        super(vector, jdbcType);
        this.factor = factor;
    }

    @Override
    public void bind(PreparedStatement statement, int parameterIndex, int rowIndex) throws SQLException {
        Time value = new Time(((BaseFixedWidthVector)this.vector).getDataBuffer().getLong((long)rowIndex * 8L) / this.factor);
        statement.setTime(parameterIndex, value);
    }
}

