/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.BigIntVector;

public class BigIntConsumer {
    public static JdbcConsumer<BigIntVector> createConsumer(BigIntVector vector, int index, boolean nullable) {
        if (nullable) {
            return new NullableBigIntConsumer(vector, index);
        }
        return new NonNullableBigIntConsumer(vector, index);
    }

    static class NullableBigIntConsumer
    extends BaseConsumer<BigIntVector> {
        public NullableBigIntConsumer(BigIntVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            long value = resultSet.getLong(this.columnIndexInResultSet);
            if (!resultSet.wasNull()) {
                ((BigIntVector)this.vector).set(this.currentIndex, value);
            }
            ++this.currentIndex;
        }
    }

    static class NonNullableBigIntConsumer
    extends BaseConsumer<BigIntVector> {
        public NonNullableBigIntConsumer(BigIntVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            long value = resultSet.getLong(this.columnIndexInResultSet);
            ((BigIntVector)this.vector).set(this.currentIndex, value);
            ++this.currentIndex;
        }
    }
}

