/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.BitVector;

public class BitConsumer {
    public static JdbcConsumer<BitVector> createConsumer(BitVector vector, int index, boolean nullable) {
        if (nullable) {
            return new NullableBitConsumer(vector, index);
        }
        return new NonNullableBitConsumer(vector, index);
    }

    static class NullableBitConsumer
    extends BaseConsumer<BitVector> {
        public NullableBitConsumer(BitVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            boolean value = resultSet.getBoolean(this.columnIndexInResultSet);
            if (!resultSet.wasNull()) {
                ((BitVector)this.vector).set(this.currentIndex, value ? 1 : 0);
            }
            ++this.currentIndex;
        }
    }

    static class NonNullableBitConsumer
    extends BaseConsumer<BitVector> {
        public NonNullableBitConsumer(BitVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            boolean value = resultSet.getBoolean(this.columnIndexInResultSet);
            ((BitVector)this.vector).set(this.currentIndex, value ? 1 : 0);
            ++this.currentIndex;
        }
    }
}

