/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.adapter.jdbc.consumer.exceptions.JdbcConsumerException;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class CompositeJdbcConsumer
implements JdbcConsumer {
    private final JdbcConsumer[] consumers;

    public CompositeJdbcConsumer(JdbcConsumer[] consumers) {
        this.consumers = consumers;
    }

    @Override
    public void consume(ResultSet rs) throws SQLException, IOException {
        for (int i = 0; i < this.consumers.length; ++i) {
            try {
                this.consumers[i].consume(rs);
                continue;
            }
            catch (Exception e) {
                if (this.consumers[i] instanceof BaseConsumer) {
                    BaseConsumer consumer = (BaseConsumer)this.consumers[i];
                    JdbcFieldInfo fieldInfo = new JdbcFieldInfo(rs.getMetaData(), consumer.columnIndexInResultSet);
                    ArrowType arrowType = consumer.vector.getMinorType().getType();
                    throw new JdbcConsumerException("Exception while consuming JDBC value", (Throwable)e, fieldInfo, arrowType);
                }
                throw e;
            }
        }
    }

    @Override
    public void close() {
        try {
            AutoCloseables.close((AutoCloseable[])this.consumers);
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while releasing resources.", e);
        }
    }

    public void resetValueVector(ValueVector vector) {
    }

    public void resetVectorSchemaRoot(VectorSchemaRoot root) {
        assert (root.getFieldVectors().size() == this.consumers.length);
        for (int i = 0; i < this.consumers.length; ++i) {
            this.consumers[i].resetValueVector(root.getVector(i));
        }
    }
}

