/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.TimeStampMilliVector;

public abstract class TimestampConsumer {
    public static JdbcConsumer<TimeStampMilliVector> createConsumer(TimeStampMilliVector vector, int index, boolean nullable) {
        if (nullable) {
            return new NullableTimestampConsumer(vector, index);
        }
        return new NonNullableTimestampConsumer(vector, index);
    }

    static class NullableTimestampConsumer
    extends BaseConsumer<TimeStampMilliVector> {
        public NullableTimestampConsumer(TimeStampMilliVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            Timestamp timestamp = resultSet.getTimestamp(this.columnIndexInResultSet);
            if (!resultSet.wasNull()) {
                ((TimeStampMilliVector)this.vector).set(this.currentIndex, timestamp.getTime());
            }
            ++this.currentIndex;
        }
    }

    static class NonNullableTimestampConsumer
    extends BaseConsumer<TimeStampMilliVector> {
        public NonNullableTimestampConsumer(TimeStampMilliVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            Timestamp timestamp = resultSet.getTimestamp(this.columnIndexInResultSet);
            ((TimeStampMilliVector)this.vector).set(this.currentIndex, timestamp.getTime());
            ++this.currentIndex;
        }
    }
}

