/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.DecimalVector;

public class DecimalConsumer {
    public static JdbcConsumer<DecimalVector> createConsumer(DecimalVector vector, int index, boolean nullable) {
        if (nullable) {
            return new NullableDecimalConsumer(vector, index);
        }
        return new NonNullableDecimalConsumer(vector, index);
    }

    static class NonNullableDecimalConsumer
    extends BaseConsumer<DecimalVector> {
        public NonNullableDecimalConsumer(DecimalVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            BigDecimal value = resultSet.getBigDecimal(this.columnIndexInResultSet);
            ((DecimalVector)this.vector).set(this.currentIndex, value);
            ++this.currentIndex;
        }
    }

    static class NullableDecimalConsumer
    extends BaseConsumer<DecimalVector> {
        public NullableDecimalConsumer(DecimalVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            BigDecimal value = resultSet.getBigDecimal(this.columnIndexInResultSet);
            if (!resultSet.wasNull()) {
                ((DecimalVector)this.vector).set(this.currentIndex, value);
            }
            ++this.currentIndex;
        }
    }
}

