/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ExpandableByteBuf;
import io.netty.buffer.NettyArrowBuf;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.junit.Assert;
import org.junit.Test;

public class TestExpandableByteBuf {
    @Test
    public void testCapacity() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(20L);){
            NettyArrowBuf srcByteBuf = NettyArrowBuf.unwrapBuffer((ArrowBuf)buf);
            ExpandableByteBuf expandableByteBuf = new ExpandableByteBuf((ByteBuf)srcByteBuf, (BufferAllocator)allocator);
            ByteBuf newByteBuf = expandableByteBuf.capacity(31);
            int capacity = newByteBuf.capacity();
            Assert.assertEquals((long)32L, (long)capacity);
        }
    }

    @Test
    public void testCapacity1() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(20L);){
            NettyArrowBuf srcByteBuf = NettyArrowBuf.unwrapBuffer((ArrowBuf)buf);
            ExpandableByteBuf expandableByteBuf = new ExpandableByteBuf((ByteBuf)srcByteBuf, (BufferAllocator)allocator);
            ByteBuf newByteBuf = expandableByteBuf.capacity(32);
            int capacity = newByteBuf.capacity();
            Assert.assertEquals((long)32L, (long)capacity);
        }
    }

    @Test
    public void testSetAndGetIntValues() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(20L);){
            int[] intVals;
            NettyArrowBuf srcByteBuf = NettyArrowBuf.unwrapBuffer((ArrowBuf)buf);
            ExpandableByteBuf expandableByteBuf = new ExpandableByteBuf((ByteBuf)srcByteBuf, (BufferAllocator)allocator);
            for (int intValue : intVals = new int[]{Integer.MIN_VALUE, -32769, Short.MIN_VALUE, 0, Short.MAX_VALUE, 32768, Integer.MAX_VALUE}) {
                expandableByteBuf.setInt(0, intValue);
                Assert.assertEquals((long)expandableByteBuf.getInt(0), (long)intValue);
                Assert.assertEquals((long)expandableByteBuf.getIntLE(0), (long)Integer.reverseBytes(intValue));
            }
        }
    }

    @Test
    public void testSetAndGetLongValues() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(20L);){
            long[] longVals;
            NettyArrowBuf srcByteBuf = NettyArrowBuf.unwrapBuffer((ArrowBuf)buf);
            ExpandableByteBuf expandableByteBuf = new ExpandableByteBuf((ByteBuf)srcByteBuf, (BufferAllocator)allocator);
            for (long longValue : longVals = new long[]{Long.MIN_VALUE, 0L, Long.MAX_VALUE}) {
                expandableByteBuf.setLong(0, longValue);
                Assert.assertEquals((long)expandableByteBuf.getLong(0), (long)longValue);
                Assert.assertEquals((long)expandableByteBuf.getLongLE(0), (long)Long.reverseBytes(longValue));
            }
        }
    }

    @Test
    public void testSetAndGetShortValues() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(20L);){
            short[] shortVals;
            NettyArrowBuf srcByteBuf = NettyArrowBuf.unwrapBuffer((ArrowBuf)buf);
            ExpandableByteBuf expandableByteBuf = new ExpandableByteBuf((ByteBuf)srcByteBuf, (BufferAllocator)allocator);
            for (short shortValue : shortVals = new short[]{Short.MIN_VALUE, 0, Short.MAX_VALUE}) {
                expandableByteBuf.setShort(0, (int)shortValue);
                Assert.assertEquals((long)expandableByteBuf.getShort(0), (long)shortValue);
                Assert.assertEquals((long)expandableByteBuf.getShortLE(0), (long)Short.reverseBytes(shortValue));
            }
        }
    }

    @Test
    public void testSetAndGetByteValues() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(20L);){
            byte[] byteVals;
            NettyArrowBuf srcByteBuf = NettyArrowBuf.unwrapBuffer((ArrowBuf)buf);
            ExpandableByteBuf expandableByteBuf = new ExpandableByteBuf((ByteBuf)srcByteBuf, (BufferAllocator)allocator);
            byte[] byArray = byteVals = new byte[]{-128, 0, 127};
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                short byteValue = byArray[i];
                expandableByteBuf.setByte(0, (int)byteValue);
                Assert.assertEquals((long)expandableByteBuf.getByte(0), (long)byteValue);
            }
        }
    }
}

