/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.NettyArrowBuf;
import java.nio.ByteBuffer;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.ArrowByteBufAllocator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.junit.Assert;
import org.junit.Test;

public class TestNettyArrowBuf {
    @Test
    public void testSliceWithoutArgs() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(20L);){
            NettyArrowBuf nettyBuf = NettyArrowBuf.unwrapBuffer((ArrowBuf)buf);
            nettyBuf.writerIndex(20);
            nettyBuf.readerIndex(10);
            NettyArrowBuf slicedBuffer = nettyBuf.slice();
            int readableBytes = slicedBuffer.readableBytes();
            Assert.assertEquals((long)10L, (long)readableBytes);
        }
    }

    @Test
    public void testNioBuffer() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(20L);){
            NettyArrowBuf nettyBuf = NettyArrowBuf.unwrapBuffer((ArrowBuf)buf);
            ByteBuffer byteBuffer = nettyBuf.nioBuffer(4, 6);
            Assert.assertEquals((long)0L, (long)byteBuffer.position());
            Assert.assertEquals((long)6L, (long)byteBuffer.limit());
            Assert.assertEquals((long)28L, (long)byteBuffer.capacity());
        }
    }

    @Test
    public void testInternalNioBuffer() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(20L);){
            NettyArrowBuf nettyBuf = NettyArrowBuf.unwrapBuffer((ArrowBuf)buf);
            ByteBuffer byteBuffer = nettyBuf.internalNioBuffer(4, 6);
            Assert.assertEquals((long)0L, (long)byteBuffer.position());
            Assert.assertEquals((long)6L, (long)byteBuffer.limit());
            Assert.assertEquals((long)28L, (long)byteBuffer.capacity());
        }
    }

    @Test
    public void testSetLEValues() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(20L);){
            short[] shortVals;
            long[] longVals;
            int[] intVals;
            NettyArrowBuf nettyBuf = NettyArrowBuf.unwrapBuffer((ArrowBuf)buf);
            for (int intValue : intVals = new int[]{Integer.MIN_VALUE, -32769, Short.MIN_VALUE, 0, Short.MAX_VALUE, 32768, Integer.MAX_VALUE}) {
                nettyBuf._setInt(0, intValue);
                Assert.assertEquals((long)nettyBuf._getIntLE(0), (long)Integer.reverseBytes(intValue));
            }
            for (long longValue : longVals = new long[]{Long.MIN_VALUE, 0L, Long.MAX_VALUE}) {
                nettyBuf._setLong(0, longValue);
                Assert.assertEquals((long)nettyBuf._getLongLE(0), (long)Long.reverseBytes(longValue));
            }
            for (short shortValue : shortVals = new short[]{Short.MIN_VALUE, 0, Short.MAX_VALUE}) {
                nettyBuf._setShort(0, (int)shortValue);
                Assert.assertEquals((long)nettyBuf._getShortLE(0), (long)Short.reverseBytes(shortValue));
            }
        }
    }

    @Test
    public void testSetCompositeBuffer() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(20L);
             NettyArrowBuf buf2 = NettyArrowBuf.unwrapBuffer((ArrowBuf)allocator.buffer(20L));){
            CompositeByteBuf byteBufs = new CompositeByteBuf((ByteBufAllocator)new ArrowByteBufAllocator((BufferAllocator)allocator), true, 1);
            int expected = 4;
            buf2.setInt(0, expected);
            buf2.writerIndex(4);
            byteBufs.addComponent(true, (ByteBuf)buf2);
            NettyArrowBuf.unwrapBuffer((ArrowBuf)buf).setBytes(0, (ByteBuf)byteBufs, 4);
            int actual = buf.getInt(0L);
            Assert.assertEquals((long)expected, (long)actual);
        }
    }

    @Test
    public void testGetCompositeBuffer() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(20L);){
            CompositeByteBuf byteBufs = new CompositeByteBuf((ByteBufAllocator)new ArrowByteBufAllocator((BufferAllocator)allocator), true, 1);
            int expected = 4;
            buf.setInt(0L, expected);
            NettyArrowBuf buf2 = NettyArrowBuf.unwrapBuffer((ArrowBuf)allocator.buffer(20L));
            byteBufs.addComponent(true, (ByteBuf)buf2);
            byteBufs.capacity(20);
            NettyArrowBuf.unwrapBuffer((ArrowBuf)buf).getBytes(0, (ByteBuf)byteBufs, 4);
            int actual = byteBufs.getInt(0);
            Assert.assertEquals((long)expected, (long)actual);
            byteBufs.component(0).release();
        }
    }

    @Test
    public void testUnwrapReturnsNull() {
        try (RootAllocator allocator = new RootAllocator(128L);
             ArrowBuf buf = allocator.buffer(20L);){
            NettyArrowBuf nettyBuf = NettyArrowBuf.unwrapBuffer((ArrowBuf)buf);
            Assert.assertNull((Object)nettyBuf.unwrap());
        }
    }
}

