/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.LargeBuffer;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnsafeDirectLittleEndian;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class TestUnsafeDirectLittleEndian {
    private static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;

    @Test
    public void testPrimitiveGetSet() {
        ByteBuf byteBuf = Unpooled.directBuffer((int)64);
        UnsafeDirectLittleEndian unsafeDirect = new UnsafeDirectLittleEndian(new LargeBuffer(byteBuf));
        unsafeDirect.setByte(0, 127);
        unsafeDirect.setByte(1, -1);
        unsafeDirect.setShort(2, Short.MAX_VALUE);
        unsafeDirect.setShort(4, -2);
        unsafeDirect.setInt(8, Integer.MAX_VALUE);
        unsafeDirect.setInt(12, -66052);
        unsafeDirect.setLong(16, Long.MAX_VALUE);
        unsafeDirect.setLong(24, -4295098372L);
        unsafeDirect.setFloat(32, 1.23f);
        unsafeDirect.setFloat(36, -1.23f);
        unsafeDirect.setDouble(40, 1.234567);
        unsafeDirect.setDouble(48, -1.234567);
        Assert.assertEquals((long)127L, (long)unsafeDirect.getByte(0));
        Assert.assertEquals((long)-1L, (long)unsafeDirect.getByte(1));
        Assert.assertEquals((long)32767L, (long)unsafeDirect.getShort(2));
        Assert.assertEquals((long)-2L, (long)unsafeDirect.getShort(4));
        Assert.assertEquals((long)65534L, (long)unsafeDirect.getChar(4));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)unsafeDirect.getInt(8));
        Assert.assertEquals((long)-66052L, (long)unsafeDirect.getInt(12));
        Assert.assertEquals((long)4294901244L, (long)unsafeDirect.getUnsignedInt(12));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)unsafeDirect.getLong(16));
        Assert.assertEquals((long)-4295098372L, (long)unsafeDirect.getLong(24));
        Assert.assertEquals((double)1.23f, (double)unsafeDirect.getFloat(32), (double)0.0);
        Assert.assertEquals((double)-1.23f, (double)unsafeDirect.getFloat(36), (double)0.0);
        Assert.assertEquals((double)1.234567, (double)unsafeDirect.getDouble(40), (double)0.0);
        Assert.assertEquals((double)-1.234567, (double)unsafeDirect.getDouble(48), (double)0.0);
        byte[] inBytes = "1234567".getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(inBytes);
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Assert.assertEquals((long)5L, (long)unsafeDirect.setBytes(56, (InputStream)bais, 5));
            unsafeDirect.getBytes(56, (OutputStream)baos, 5);
            Assert.assertEquals((Object)"12345", (Object)new String(baos.toByteArray(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

