/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import org.apache.arrow.memory.AllocationListener;
import org.apache.arrow.memory.AllocationOutcome;
import org.apache.arrow.memory.BufferAllocator;

final class CountingAllocationListener
implements AllocationListener {
    private int numPreCalls;
    private int numCalls = 0;
    private int numReleaseCalls;
    private int numChildren = 0;
    private long totalMem = 0L;
    private long currentMem = 0L;
    private boolean expandOnFail = false;
    BufferAllocator expandAlloc = null;
    long expandLimit = 0L;

    CountingAllocationListener() {
    }

    public void onPreAllocation(long size) {
        ++this.numPreCalls;
    }

    public void onAllocation(long size) {
        ++this.numCalls;
        this.totalMem += size;
        this.currentMem += size;
    }

    public boolean onFailedAllocation(long size, AllocationOutcome outcome) {
        if (this.expandOnFail) {
            this.expandAlloc.setLimit(this.expandLimit);
            return true;
        }
        return false;
    }

    public void onRelease(long size) {
        ++this.numReleaseCalls;
        this.currentMem -= size;
    }

    public void onChildAdded(BufferAllocator parentAllocator, BufferAllocator childAllocator) {
        ++this.numChildren;
    }

    public void onChildRemoved(BufferAllocator parentAllocator, BufferAllocator childAllocator) {
        --this.numChildren;
    }

    void setExpandOnFail(BufferAllocator expandAlloc, long expandLimit) {
        this.expandOnFail = true;
        this.expandAlloc = expandAlloc;
        this.expandLimit = expandLimit;
    }

    int getNumPreCalls() {
        return this.numPreCalls;
    }

    int getNumReleaseCalls() {
        return this.numReleaseCalls;
    }

    int getNumCalls() {
        return this.numCalls;
    }

    int getNumChildren() {
        return this.numChildren;
    }

    long getTotalMem() {
        return this.totalMem;
    }

    long getCurrentMem() {
        return this.currentMem;
    }
}

