/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import java.util.ArrayList;
import org.apache.arrow.memory.AllocationListener;
import org.apache.arrow.memory.AllocationOutcome;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.CountingAllocationListener;
import org.apache.arrow.memory.ForeignAllocation;
import org.apache.arrow.memory.OutOfMemoryException;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.MemoryUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestForeignAllocation {
    BufferAllocator allocator;

    @Before
    public void before() {
        this.allocator = new RootAllocator();
    }

    @After
    public void after() {
        this.allocator.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void wrapForeignAllocation() {
        long bufferSize = 16L;
        UnsafeForeignAllocation allocation = new UnsafeForeignAllocation(16L);
        try {
            Assert.assertEquals((long)0L, (long)this.allocator.getAllocatedMemory());
            ArrowBuf buf = this.allocator.wrapForeignAllocation((ForeignAllocation)allocation);
            Assert.assertEquals((long)16L, (long)buf.capacity());
            buf.close();
            Assert.assertTrue((boolean)allocation.released);
        }
        finally {
            allocation.release0();
        }
        Assert.assertEquals((long)0L, (long)this.allocator.getAllocatedMemory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void wrapForeignAllocationWithAllocationListener() {
        long bufferSize = 16L;
        CountingAllocationListener listener = new CountingAllocationListener();
        try (BufferAllocator listenedAllocator = this.allocator.newChildAllocator("child", (AllocationListener)listener, 0L, this.allocator.getLimit());){
            UnsafeForeignAllocation allocation = new UnsafeForeignAllocation(16L);
            try {
                Assert.assertEquals((long)0L, (long)listenedAllocator.getAllocatedMemory());
                ArrowBuf buf = listenedAllocator.wrapForeignAllocation((ForeignAllocation)allocation);
                Assert.assertEquals((long)16L, (long)buf.capacity());
                Assert.assertEquals((long)16L, (long)listener.getCurrentMem());
                buf.close();
                Assert.assertEquals((long)0L, (long)listener.getCurrentMem());
                Assert.assertTrue((boolean)allocation.released);
            }
            finally {
                allocation.release0();
            }
            Assert.assertEquals((long)0L, (long)listenedAllocator.getAllocatedMemory());
        }
        Assert.assertEquals((long)1L, (long)listener.getNumPreCalls());
        Assert.assertEquals((long)1L, (long)listener.getNumCalls());
        Assert.assertEquals((long)1L, (long)listener.getNumReleaseCalls());
        Assert.assertEquals((long)16L, (long)listener.getTotalMem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=OutOfMemoryException.class)
    public void wrapForeignAllocationFailedWithAllocationListener() {
        long bufferSize = 16L;
        long limit = 15L;
        CountingAllocationListener listener = new CountingAllocationListener();
        try (BufferAllocator listenedAllocator = this.allocator.newChildAllocator("child", (AllocationListener)listener, 0L, 15L);){
            UnsafeForeignAllocation allocation = new UnsafeForeignAllocation(16L);
            try {
                Assert.assertEquals((long)0L, (long)listenedAllocator.getAllocatedMemory());
                ArrowBuf buf = listenedAllocator.wrapForeignAllocation((ForeignAllocation)allocation);
                Assert.assertEquals((long)16L, (long)buf.capacity());
                buf.close();
                Assert.assertTrue((boolean)allocation.released);
            }
            finally {
                allocation.release0();
            }
        }
    }

    @Test
    public void wrapForeignAllocationWithAllocationListenerReclaimingSpace() {
        long bufferSize = 16L;
        long limit = 31L;
        final ArrayList<ArrowBuf> buffersToBeFreed = new ArrayList<ArrowBuf>();
        AllocationListener listener = new AllocationListener(){

            public boolean onFailedAllocation(long size, AllocationOutcome outcome) {
                buffersToBeFreed.forEach(ArrowBuf::close);
                return true;
            }
        };
        try (BufferAllocator listenedAllocator = this.allocator.newChildAllocator("child", listener, 0L, 31L);){
            ArrowBuf buffer1 = listenedAllocator.buffer(16L);
            buffersToBeFreed.add(buffer1);
            UnsafeForeignAllocation allocation = new UnsafeForeignAllocation(16L);
            try (ArrowBuf buffer2 = listenedAllocator.wrapForeignAllocation((ForeignAllocation)allocation);){
                Assert.assertEquals((long)16L, (long)buffer2.capacity());
                Assert.assertEquals((long)0L, (long)buffer1.getReferenceManager().getRefCount());
            }
        }
    }

    private static class UnsafeForeignAllocation
    extends ForeignAllocation {
        boolean released = false;

        public UnsafeForeignAllocation(long bufferSize) {
            super(bufferSize, MemoryUtil.UNSAFE.allocateMemory(bufferSize));
        }

        protected void release0() {
            if (!this.released) {
                MemoryUtil.UNSAFE.freeMemory(this.memoryAddress());
                this.released = true;
            }
        }
    }
}

