/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.NettyArrowBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.BoundsChecking;
import org.apache.arrow.memory.BufferManager;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.arrow.memory.util.HistoricalLog;
import org.apache.arrow.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArrowBuf
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ArrowBuf.class);
    private static final int SHORT_SIZE = 2;
    private static final int INT_SIZE = 4;
    private static final int FLOAT_SIZE = 4;
    private static final int DOUBLE_SIZE = 8;
    private static final int LONG_SIZE = 8;
    private static final AtomicLong idGenerator = new AtomicLong(0L);
    private static final int LOG_BYTES_PER_ROW = 10;
    private final long id = idGenerator.incrementAndGet();
    private final ReferenceManager referenceManager;
    private final BufferManager bufferManager;
    private final long addr;
    private final boolean isEmpty;
    private int readerIndex;
    private int writerIndex;
    private final HistoricalLog historicalLog = BaseAllocator.DEBUG ? new HistoricalLog(6, "ArrowBuf[%d]", this.id) : null;
    private volatile int length;

    public ArrowBuf(ReferenceManager referenceManager, BufferManager bufferManager, int length, long memoryAddress, boolean isEmpty) {
        this.referenceManager = referenceManager;
        this.bufferManager = bufferManager;
        this.isEmpty = isEmpty;
        this.addr = memoryAddress;
        this.length = length;
        this.readerIndex = 0;
        this.writerIndex = 0;
        if (BaseAllocator.DEBUG) {
            this.historicalLog.recordEvent("create()", new Object[0]);
        }
    }

    public int refCnt() {
        return this.isEmpty ? 1 : this.referenceManager.getRefCount();
    }

    public void checkBytes(int start, int end) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            this.checkIndexD(start, end - start);
        }
    }

    private void ensureAccessible() {
        if (this.refCnt() == 0) {
            throw new IllegalStateException("Ref count should be >= 1 for accessing the ArrowBuf");
        }
    }

    public NettyArrowBuf asNettyBuffer() {
        NettyArrowBuf nettyArrowBuf = new NettyArrowBuf(this, this.isEmpty ? null : this.referenceManager.getAllocator().getAsByteBufAllocator(), this.length);
        nettyArrowBuf.readerIndex(this.readerIndex);
        nettyArrowBuf.writerIndex(this.writerIndex);
        return nettyArrowBuf;
    }

    public ReferenceManager getReferenceManager() {
        return this.referenceManager;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public int capacity() {
        return this.length;
    }

    public synchronized ArrowBuf capacity(int newCapacity) {
        if (newCapacity == this.length) {
            return this;
        }
        Preconditions.checkArgument(newCapacity >= 0);
        if (newCapacity < this.length) {
            this.length = newCapacity;
            return this;
        }
        throw new UnsupportedOperationException("Buffers don't support resizing that increases the size.");
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    public int readableBytes() {
        Preconditions.checkState(this.writerIndex >= this.readerIndex, "Writer index cannot be less than reader index");
        return this.writerIndex - this.readerIndex;
    }

    public int writableBytes() {
        return this.capacity() - this.writerIndex;
    }

    public ArrowBuf slice() {
        return this.slice(this.readerIndex, this.readableBytes());
    }

    public ArrowBuf slice(int index, int length) {
        if (this.isEmpty) {
            return this;
        }
        Preconditions.checkPositionIndex(index, this.length);
        Preconditions.checkPositionIndex(index + length, this.length);
        ArrowBuf newBuf = this.referenceManager.deriveBuffer(this, index, length);
        newBuf.writerIndex(length);
        return newBuf;
    }

    public ByteBuffer nioBuffer() {
        return this.isEmpty ? ByteBuffer.allocateDirect(0) : this.asNettyBuffer().nioBuffer();
    }

    public ByteBuffer nioBuffer(int index, int length) {
        return this.isEmpty ? ByteBuffer.allocateDirect(0) : this.asNettyBuffer().nioBuffer(index, length);
    }

    public long memoryAddress() {
        return this.addr;
    }

    public String toString() {
        return String.format("ArrowBuf[%d], address:%d, length:%d", this.id, this.memoryAddress(), this.length);
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    private long addr(int index) {
        return this.addr + (long)index;
    }

    private void chk(int index, int length) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            this.checkIndexD(index, length);
        }
    }

    private void checkIndexD(int index, int fieldLength) {
        this.ensureAccessible();
        Preconditions.checkArgument(fieldLength >= 0, "expecting non-negative data length");
        if (index < 0 || index > this.capacity() - fieldLength) {
            if (BaseAllocator.DEBUG) {
                this.historicalLog.logHistory(logger);
            }
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index, fieldLength, this.capacity()));
        }
    }

    public long getLong(int index) {
        this.chk(index, 8);
        return PlatformDependent.getLong((long)this.addr(index));
    }

    public void setLong(int index, long value) {
        this.chk(index, 8);
        PlatformDependent.putLong((long)this.addr(index), (long)value);
    }

    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    public void setFloat(int index, float value) {
        this.chk(index, 4);
        PlatformDependent.putInt((long)this.addr(index), (int)Float.floatToRawIntBits(value));
    }

    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    public void setDouble(int index, double value) {
        this.chk(index, 8);
        PlatformDependent.putLong((long)this.addr(index), (long)Double.doubleToRawLongBits(value));
    }

    public char getChar(int index) {
        return (char)this.getShort(index);
    }

    public void setChar(int index, int value) {
        this.chk(index, 2);
        PlatformDependent.putShort((long)this.addr(index), (short)((short)value));
    }

    public int getInt(int index) {
        this.chk(index, 4);
        return PlatformDependent.getInt((long)this.addr(index));
    }

    public void setInt(int index, int value) {
        this.chk(index, 4);
        PlatformDependent.putInt((long)this.addr(index), (int)value);
    }

    public short getShort(int index) {
        this.chk(index, 2);
        return PlatformDependent.getShort((long)this.addr(index));
    }

    public void setShort(int index, int value) {
        this.setShort(index, (short)value);
    }

    public void setShort(int index, short value) {
        this.chk(index, 2);
        PlatformDependent.putShort((long)this.addr(index), (short)value);
    }

    public void setByte(int index, int value) {
        this.chk(index, 1);
        PlatformDependent.putByte((long)this.addr(index), (byte)((byte)value));
    }

    public void setByte(int index, byte value) {
        this.chk(index, 1);
        PlatformDependent.putByte((long)this.addr(index), (byte)value);
    }

    public byte getByte(int index) {
        this.chk(index, 1);
        return PlatformDependent.getByte((long)this.addr(index));
    }

    private void ensureWritable(int length) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            Preconditions.checkArgument(length >= 0, "expecting non-negative length");
            this.ensureAccessible();
            if (length > this.writableBytes()) {
                throw new IndexOutOfBoundsException(String.format("writerIndex(%d) + length(%d) exceeds capacity(%d)", this.writerIndex, length, this.capacity()));
            }
        }
    }

    private void ensureReadable(int length) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            Preconditions.checkArgument(length >= 0, "expecting non-negative length");
            this.ensureAccessible();
            if (length > this.readableBytes()) {
                throw new IndexOutOfBoundsException(String.format("readerIndex(%d) + length(%d) exceeds writerIndex(%d)", this.readerIndex, length, this.writerIndex));
            }
        }
    }

    public byte readByte() {
        this.ensureReadable(1);
        byte b = this.getByte(this.readerIndex);
        ++this.readerIndex;
        return b;
    }

    public void readBytes(byte[] dst) {
        Preconditions.checkArgument(dst != null, "expecting valid dst bytearray");
        this.ensureReadable(dst.length);
        this.getBytes(this.readerIndex, dst, 0, dst.length);
    }

    public void writeByte(byte value) {
        this.ensureWritable(1);
        PlatformDependent.putByte((long)this.addr(this.writerIndex), (byte)value);
        ++this.writerIndex;
    }

    public void writeByte(int value) {
        this.ensureWritable(1);
        PlatformDependent.putByte((long)this.addr(this.writerIndex), (byte)((byte)value));
        ++this.writerIndex;
    }

    public void writeBytes(byte[] src) {
        Preconditions.checkArgument(src != null, "expecting valid src array");
        this.writeBytes(src, 0, src.length);
    }

    public void writeBytes(byte[] src, int srcIndex, int length) {
        this.ensureWritable(length);
        this.setBytes(this.writerIndex, src, srcIndex, length);
        this.writerIndex += length;
    }

    public void writeShort(int value) {
        this.ensureWritable(2);
        PlatformDependent.putShort((long)this.addr(this.writerIndex), (short)((short)value));
        this.writerIndex += 2;
    }

    public void writeInt(int value) {
        this.ensureWritable(4);
        PlatformDependent.putInt((long)this.addr(this.writerIndex), (int)value);
        this.writerIndex += 4;
    }

    public void writeLong(long value) {
        this.ensureWritable(8);
        PlatformDependent.putLong((long)this.addr(this.writerIndex), (long)value);
        this.writerIndex += 8;
    }

    public void writeFloat(float value) {
        this.ensureWritable(4);
        PlatformDependent.putInt((long)this.addr(this.writerIndex), (int)Float.floatToRawIntBits(value));
        this.writerIndex += 4;
    }

    public void writeDouble(double value) {
        this.ensureWritable(8);
        PlatformDependent.putLong((long)this.addr(this.writerIndex), (long)Double.doubleToRawLongBits(value));
        this.writerIndex += 8;
    }

    private static boolean isOutOfBounds(int index, int length, int capacity) {
        return (index | length | index + length | capacity - (index + length)) < 0;
    }

    private void checkIndex(int index, int fieldLength) {
        this.ensureAccessible();
        if (ArrowBuf.isOutOfBounds(index, fieldLength, this.capacity())) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index, fieldLength, this.capacity()));
        }
    }

    public void getBytes(int index, byte[] dst) {
        this.getBytes(index, dst, 0, dst.length);
    }

    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        Preconditions.checkArgument(dst != null, "expecting a valid dst byte array");
        if (ArrowBuf.isOutOfBounds(dstIndex, length, dst.length)) {
            throw new IndexOutOfBoundsException("Not enough space to copy data into destination" + dstIndex);
        }
        if (length != 0) {
            PlatformDependent.copyMemory((long)this.addr(index), (byte[])dst, (int)dstIndex, (long)length);
        }
    }

    public void setBytes(int index, byte[] src) {
        this.setBytes(index, src, 0, src.length);
    }

    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        this.checkIndex(index, length);
        Preconditions.checkArgument(src != null, "expecting a valid src byte array");
        if (ArrowBuf.isOutOfBounds(srcIndex, length, src.length)) {
            throw new IndexOutOfBoundsException("Not enough space to copy data from byte array" + srcIndex);
        }
        if (length > 0) {
            PlatformDependent.copyMemory((byte[])src, (int)srcIndex, (long)this.addr(index), (long)length);
        }
    }

    public void getBytes(int index, ByteBuffer dst) {
        this.checkIndex(index, dst.remaining());
        if (dst.remaining() != 0) {
            long srcAddress = this.addr(index);
            if (dst.isDirect()) {
                if (dst.isReadOnly()) {
                    throw new ReadOnlyBufferException();
                }
                long dstAddress = PlatformDependent.directBufferAddress((ByteBuffer)dst) + (long)dst.position();
                PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)dst.remaining());
                dst.position(dst.position() + dst.remaining());
            } else if (dst.hasArray()) {
                int dstIndex = dst.arrayOffset() + dst.position();
                PlatformDependent.copyMemory((long)srcAddress, (byte[])dst.array(), (int)dstIndex, (long)dst.remaining());
                dst.position(dst.position() + dst.remaining());
            } else {
                throw new UnsupportedOperationException("Copy from this ArrowBuf to ByteBuffer is not supported");
            }
        }
    }

    public void setBytes(int index, ByteBuffer src) {
        this.checkIndex(index, src.remaining());
        int length = src.remaining();
        long dstAddress = this.addr(index);
        if (length != 0) {
            if (src.isDirect()) {
                long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)src) + (long)src.position();
                PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)length);
                src.position(src.position() + length);
            } else if (src.hasArray()) {
                int srcIndex = src.arrayOffset() + src.position();
                PlatformDependent.copyMemory((byte[])src.array(), (int)srcIndex, (long)dstAddress, (long)length);
                src.position(src.position() + length);
            } else {
                while (length >= 8) {
                    PlatformDependent.putLong((long)dstAddress, (long)src.getLong());
                    length -= 8;
                    dstAddress += 8L;
                }
                while (length > 0) {
                    PlatformDependent.putByte((long)dstAddress, (byte)src.get());
                    --length;
                    ++dstAddress;
                }
            }
        }
    }

    public void setBytes(int index, ByteBuffer src, int srcIndex, int length) {
        this.checkIndex(index, length);
        if (src.isDirect()) {
            long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)src) + (long)srcIndex;
            long dstAddress = this.addr(index);
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)length);
        } else if (srcIndex == 0 && src.capacity() == length) {
            this.setBytes(index, src);
        } else {
            ByteBuffer newBuf = src.duplicate();
            newBuf.position(srcIndex);
            newBuf.limit(srcIndex + length);
            this.setBytes(index, newBuf);
        }
    }

    public void getBytes(int index, ArrowBuf dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        Preconditions.checkArgument(dst != null, "expecting a valid ArrowBuf");
        if (ArrowBuf.isOutOfBounds(dstIndex, length, dst.capacity())) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", dstIndex, length, dst.capacity()));
        }
        if (length != 0) {
            long srcAddress = this.addr(index);
            long dstAddress = dst.memoryAddress() + (long)dstIndex;
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)length);
        }
    }

    public void setBytes(int index, ArrowBuf src, int srcIndex, int length) {
        this.checkIndex(index, length);
        Preconditions.checkArgument(src != null, "expecting a valid ArrowBuf");
        if (ArrowBuf.isOutOfBounds(srcIndex, length, src.capacity())) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index, length, src.capacity()));
        }
        if (length != 0) {
            long srcAddress = src.memoryAddress() + (long)srcIndex;
            long dstAddress = this.addr(index);
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)length);
        }
    }

    public void setBytes(int index, ArrowBuf src) {
        Preconditions.checkArgument(src != null, "expecting valid ArrowBuf");
        int length = src.readableBytes();
        this.checkIndex(index, length);
        long srcAddress = src.memoryAddress() + (long)src.readerIndex;
        long dstAddress = this.addr(index);
        PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)length);
        src.readerIndex(src.readerIndex + length);
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        byte[] tmp;
        Preconditions.checkArgument(in != null, "expecting valid input stream");
        this.checkIndex(index, length);
        int readBytes = 0;
        if (length > 0 && (readBytes = in.read(tmp = new byte[length])) > 0) {
            PlatformDependent.copyMemory((byte[])tmp, (int)0, (long)this.addr(index), (long)readBytes);
        }
        return readBytes;
    }

    public void getBytes(int index, OutputStream out, int length) throws IOException {
        Preconditions.checkArgument(out != null, "expecting valid output stream");
        this.checkIndex(index, length);
        if (length > 0) {
            byte[] tmp = new byte[length];
            PlatformDependent.copyMemory((long)this.addr(index), (byte[])tmp, (int)0, (long)length);
            out.write(tmp);
        }
    }

    @Override
    public void close() {
        this.referenceManager.release();
    }

    public int getPossibleMemoryConsumed() {
        return this.isEmpty ? 0 : this.referenceManager.getSize();
    }

    public int getActualMemoryConsumed() {
        return this.isEmpty ? 0 : this.referenceManager.getAccountedSize();
    }

    public String toHexString(int start, int length) {
        int roundedStart = start / 10 * 10;
        StringBuilder sb = new StringBuilder("buffer byte dump\n");
        int index = roundedStart;
        for (int nLogged = 0; nLogged < length; nLogged += 10) {
            sb.append(String.format(" [%05d-%05d]", index, index + 10 - 1));
            for (int i = 0; i < 10; ++i) {
                try {
                    byte b = this.getByte(index++);
                    sb.append(String.format(" 0x%02x", b));
                    continue;
                }
                catch (IndexOutOfBoundsException ioob) {
                    sb.append(" <ioob>");
                }
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public long getId() {
        return this.id;
    }

    public void print(StringBuilder sb, int indent, BaseAllocator.Verbosity verbosity) {
        BaseAllocator.indent(sb, indent).append(this.toString());
        if (BaseAllocator.DEBUG && !this.isEmpty && verbosity.includeHistoricalLog) {
            sb.append("\n");
            this.historicalLog.buildHistory(sb, indent + 1, verbosity.includeStackTraces);
        }
    }

    public int readerIndex() {
        return this.readerIndex;
    }

    public int writerIndex() {
        return this.writerIndex;
    }

    public ArrowBuf readerIndex(int readerIndex) {
        this.readerIndex = readerIndex;
        return this;
    }

    public ArrowBuf writerIndex(int writerIndex) {
        this.writerIndex = writerIndex;
        return this;
    }

    public ArrowBuf setZero(int index, int length) {
        if (length != 0) {
            this.checkIndex(index, length);
            PlatformDependent.setMemory((long)(this.addr + (long)index), (long)length, (byte)0);
        }
        return this;
    }

    public ArrowBuf reallocIfNeeded(int size) {
        Preconditions.checkArgument(size >= 0, "reallocation size must be non-negative");
        if (this.capacity() >= size) {
            return this;
        }
        if (this.bufferManager != null) {
            return this.bufferManager.replace(this, size);
        }
        throw new UnsupportedOperationException("Realloc is only available in the context of operator's UDFs");
    }

    @Deprecated
    public void release() {
        this.referenceManager.release();
    }

    @Deprecated
    public void release(int decrement) {
        this.referenceManager.release(decrement);
    }

    @Deprecated
    public void retain() {
        this.referenceManager.retain();
    }

    @Deprecated
    public void retain(int increment) {
        this.referenceManager.retain(increment);
    }

    @Deprecated
    public ArrowBuf clear() {
        this.writerIndex = 0;
        this.readerIndex = 0;
        return this;
    }

    @Deprecated
    public ArrowBuf setIndex(int readerIndex, int writerIndex) {
        if (readerIndex >= 0 && readerIndex <= writerIndex && writerIndex <= this.capacity()) {
            this.readerIndex = readerIndex;
            this.writerIndex = writerIndex;
            return this;
        }
        throw new IndexOutOfBoundsException(String.format("readerIndex: %d, writerIndex: %d (expected:0 <= readerIndex <= writerIndex <= capacity(%d))", readerIndex, writerIndex, this.capacity()));
    }
}

