/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.gandiva.evaluator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.arrow.gandiva.evaluator.ExpressionRegistryJniHelper;
import org.apache.arrow.gandiva.evaluator.FunctionSignature;
import org.apache.arrow.gandiva.evaluator.JniLoader;
import org.apache.arrow.gandiva.exceptions.GandivaException;
import org.apache.arrow.gandiva.ipc.GandivaTypes;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class ExpressionRegistry {
    private static final int BIT_WIDTH8 = 8;
    private static final int BIT_WIDTH_16 = 16;
    private static final int BIT_WIDTH_32 = 32;
    private static final int BIT_WIDTH_64 = 64;
    private static final boolean IS_SIGNED_FALSE = false;
    private static final boolean IS_SIGNED_TRUE = true;
    private final Set<ArrowType> supportedTypes;
    private final Set<FunctionSignature> functionSignatures;
    private static volatile ExpressionRegistry INSTANCE;

    private ExpressionRegistry(Set<ArrowType> supportedTypes, Set<FunctionSignature> functionSignatures) {
        this.supportedTypes = supportedTypes;
        this.functionSignatures = functionSignatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExpressionRegistry getInstance() throws GandivaException {
        if (INSTANCE != null) return INSTANCE;
        Class<ExpressionRegistry> clazz = ExpressionRegistry.class;
        synchronized (ExpressionRegistry.class) {
            if (INSTANCE != null) return INSTANCE;
            JniLoader.getInstance();
            Set<ArrowType> typesFromGandiva = ExpressionRegistry.getSupportedTypesFromGandiva();
            Set<FunctionSignature> functionsFromGandiva = ExpressionRegistry.getSupportedFunctionsFromGandiva();
            INSTANCE = new ExpressionRegistry(typesFromGandiva, functionsFromGandiva);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public Set<FunctionSignature> getSupportedFunctions() {
        return this.functionSignatures;
    }

    public Set<ArrowType> getSupportedTypes() {
        return this.supportedTypes;
    }

    private static Set<ArrowType> getSupportedTypesFromGandiva() throws GandivaException {
        HashSet supportedTypes = Sets.newHashSet();
        try {
            byte[] gandivaSupportedDataTypes = new ExpressionRegistryJniHelper().getGandivaSupportedDataTypes();
            GandivaTypes.GandivaDataTypes gandivaDataTypes = GandivaTypes.GandivaDataTypes.parseFrom(gandivaSupportedDataTypes);
            for (GandivaTypes.ExtGandivaType type : gandivaDataTypes.getDataTypeList()) {
                supportedTypes.add(ExpressionRegistry.getArrowType(type));
            }
        }
        catch (InvalidProtocolBufferException invalidProtException) {
            throw new GandivaException("Could not get supported types.", (Exception)((Object)invalidProtException));
        }
        return supportedTypes;
    }

    private static Set<FunctionSignature> getSupportedFunctionsFromGandiva() throws GandivaException {
        HashSet supportedTypes = Sets.newHashSet();
        try {
            byte[] gandivaSupportedFunctions = new ExpressionRegistryJniHelper().getGandivaSupportedFunctions();
            GandivaTypes.GandivaFunctions gandivaFunctions = GandivaTypes.GandivaFunctions.parseFrom(gandivaSupportedFunctions);
            for (GandivaTypes.FunctionSignature protoFunctionSignature : gandivaFunctions.getFunctionList()) {
                String functionName = protoFunctionSignature.getName();
                ArrowType returnType = ExpressionRegistry.getArrowType(protoFunctionSignature.getReturnType());
                ArrayList paramTypes = Lists.newArrayList();
                for (GandivaTypes.ExtGandivaType type : protoFunctionSignature.getParamTypesList()) {
                    paramTypes.add(ExpressionRegistry.getArrowType(type));
                }
                FunctionSignature functionSignature = new FunctionSignature(functionName, returnType, paramTypes);
                supportedTypes.add(functionSignature);
            }
        }
        catch (InvalidProtocolBufferException invalidProtException) {
            throw new GandivaException("Could not get supported functions.", (Exception)((Object)invalidProtException));
        }
        return supportedTypes;
    }

    private static ArrowType getArrowType(GandivaTypes.ExtGandivaType type) {
        switch (type.getType().getNumber()) {
            case 1: {
                return ArrowType.Bool.INSTANCE;
            }
            case 2: {
                return new ArrowType.Int(8, false);
            }
            case 3: {
                return new ArrowType.Int(8, true);
            }
            case 4: {
                return new ArrowType.Int(16, false);
            }
            case 5: {
                return new ArrowType.Int(16, true);
            }
            case 6: {
                return new ArrowType.Int(32, false);
            }
            case 7: {
                return new ArrowType.Int(32, true);
            }
            case 8: {
                return new ArrowType.Int(64, false);
            }
            case 9: {
                return new ArrowType.Int(64, true);
            }
            case 10: {
                return new ArrowType.FloatingPoint(FloatingPointPrecision.HALF);
            }
            case 11: {
                return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
            }
            case 12: {
                return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
            }
            case 13: {
                return new ArrowType.Utf8();
            }
            case 14: {
                return new ArrowType.Binary();
            }
            case 16: {
                return new ArrowType.Date(DateUnit.DAY);
            }
            case 17: {
                return new ArrowType.Date(DateUnit.MILLISECOND);
            }
            case 18: {
                return new ArrowType.Timestamp(ExpressionRegistry.mapArrowTimeUnit(type.getTimeUnit()), null);
            }
            case 19: {
                return new ArrowType.Time(ExpressionRegistry.mapArrowTimeUnit(type.getTimeUnit()), 32);
            }
            case 20: {
                return new ArrowType.Time(ExpressionRegistry.mapArrowTimeUnit(type.getTimeUnit()), 64);
            }
            case 0: {
                return new ArrowType.Null();
            }
            case 22: {
                return new ArrowType.Decimal(0, 0, 128);
            }
            case 21: {
                return new ArrowType.Interval(ExpressionRegistry.mapArrowIntervalUnit(type.getIntervalType()));
            }
        }
        assert (false);
        return null;
    }

    private static TimeUnit mapArrowTimeUnit(GandivaTypes.TimeUnit timeUnit) {
        switch (timeUnit.getNumber()) {
            case 2: {
                return TimeUnit.MICROSECOND;
            }
            case 1: {
                return TimeUnit.MILLISECOND;
            }
            case 3: {
                return TimeUnit.NANOSECOND;
            }
            case 0: {
                return TimeUnit.SECOND;
            }
        }
        return null;
    }

    private static IntervalUnit mapArrowIntervalUnit(GandivaTypes.IntervalType intervalType) {
        switch (intervalType.getNumber()) {
            case 0: {
                return IntervalUnit.YEAR_MONTH;
            }
            case 1: {
                return IntervalUnit.DAY_TIME;
            }
        }
        return null;
    }
}

