/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.gandiva.evaluator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.arrow.gandiva.evaluator.ConfigurationBuilder;
import org.apache.arrow.gandiva.evaluator.JniWrapper;
import org.apache.arrow.gandiva.exceptions.GandivaException;

class JniLoader {
    private static final String LIBRARY_NAME = "gandiva_jni";
    private static volatile JniLoader INSTANCE;
    private static volatile long defaultConfiguration;
    private static final ConcurrentMap<ConfigurationBuilder.ConfigOptions, Long> configurationMap;
    private final JniWrapper wrapper = new JniWrapper();

    private JniLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static JniLoader getInstance() throws GandivaException {
        if (INSTANCE != null) return INSTANCE;
        Class<JniLoader> clazz = JniLoader.class;
        synchronized (JniLoader.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = JniLoader.setupInstance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static JniLoader setupInstance() throws GandivaException {
        try {
            String tempDir = System.getProperty("java.io.tmpdir");
            JniLoader.loadGandivaLibraryFromJar(tempDir);
            return new JniLoader();
        }
        catch (IOException ioException) {
            throw new GandivaException("unable to create native instance", ioException);
        }
    }

    private static void loadGandivaLibraryFromJar(String tmpDir) throws IOException, GandivaException {
        String libraryToLoad = JniLoader.getNormalizedArch() + "/" + System.mapLibraryName(LIBRARY_NAME);
        File libraryFile = JniLoader.moveFileFromJarToTemp(tmpDir, libraryToLoad, LIBRARY_NAME);
        System.load(libraryFile.getAbsolutePath());
    }

    private static String getNormalizedArch() {
        String arch;
        switch (arch = System.getProperty("os.arch").toLowerCase(Locale.US)) {
            case "amd64": {
                arch = "x86_64";
                break;
            }
            case "aarch64": {
                arch = "aarch_64";
                break;
            }
        }
        return arch;
    }

    private static File moveFileFromJarToTemp(String tmpDir, String libraryToLoad, String libraryName) throws IOException, GandivaException {
        File temp = JniLoader.setupFile(tmpDir, libraryName);
        try (InputStream is = JniLoader.class.getClassLoader().getResourceAsStream(libraryToLoad);){
            if (is == null) {
                throw new GandivaException(libraryToLoad + " was not found inside JAR.");
            }
            Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return temp;
    }

    private static File setupFile(String tmpDir, String libraryToLoad) throws IOException, GandivaException {
        String randomizeFileName = libraryToLoad + UUID.randomUUID();
        File temp = new File(tmpDir, randomizeFileName);
        if (temp.exists() && !temp.delete()) {
            throw new GandivaException("File: " + temp.getAbsolutePath() + " already exists and cannot be removed.");
        }
        if (!temp.createNewFile()) {
            throw new GandivaException("File: " + temp.getAbsolutePath() + " could not be created.");
        }
        temp.deleteOnExit();
        return temp;
    }

    JniWrapper getWrapper() throws GandivaException {
        return this.wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static long getConfiguration(ConfigurationBuilder.ConfigOptions configOptions) throws GandivaException {
        if (configurationMap.containsKey(configOptions)) return (Long)configurationMap.get(configOptions);
        Class<ConfigurationBuilder> clazz = ConfigurationBuilder.class;
        synchronized (ConfigurationBuilder.class) {
            if (configurationMap.containsKey(configOptions)) return (Long)configurationMap.get(configOptions);
            JniLoader.getInstance();
            long configInstance = new ConfigurationBuilder().buildConfigInstance(configOptions);
            configurationMap.put(configOptions, configInstance);
            if (!ConfigurationBuilder.ConfigOptions.getDefault().equals(configOptions)) return configInstance;
            defaultConfiguration = configInstance;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return configInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static long getDefaultConfiguration() throws GandivaException {
        if (defaultConfiguration != 0L) return defaultConfiguration;
        Class<ConfigurationBuilder> clazz = ConfigurationBuilder.class;
        synchronized (ConfigurationBuilder.class) {
            if (defaultConfiguration != 0L) return defaultConfiguration;
            JniLoader.getInstance();
            ConfigurationBuilder.ConfigOptions defaultConfigOptons = ConfigurationBuilder.ConfigOptions.getDefault();
            defaultConfiguration = new ConfigurationBuilder().buildConfigInstance(defaultConfigOptons);
            configurationMap.put(defaultConfigOptons, defaultConfiguration);
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void removeConfiguration(ConfigurationBuilder.ConfigOptions configOptions) {
        if (!configurationMap.containsKey(configOptions)) return;
        Class<ConfigurationBuilder> clazz = ConfigurationBuilder.class;
        synchronized (ConfigurationBuilder.class) {
            if (!configurationMap.containsKey(configOptions)) return;
            new ConfigurationBuilder().releaseConfigInstance((Long)configurationMap.remove(configOptions));
            if (!configOptions.equals(ConfigurationBuilder.ConfigOptions.getDefault())) return;
            defaultConfiguration = 0L;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        defaultConfiguration = 0L;
        configurationMap = new ConcurrentHashMap<ConfigurationBuilder.ConfigOptions, Long>();
    }
}

