/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.gandiva.evaluator;

import org.apache.arrow.vector.BaseVariableWidthVector;

public class VectorExpander {
    private final BaseVariableWidthVector[] vectors;

    public VectorExpander(BaseVariableWidthVector[] vectors) {
        this.vectors = vectors;
    }

    public ExpandResult expandOutputVectorAtIndex(int index, long toCapacity) {
        if (index >= this.vectors.length || this.vectors[index] == null) {
            throw new IllegalArgumentException("invalid index " + index);
        }
        BaseVariableWidthVector vector = this.vectors[index];
        while (vector.getDataBuffer().capacity() < toCapacity) {
            vector.reallocDataBuffer();
        }
        return new ExpandResult(vector.getDataBuffer().memoryAddress(), vector.getDataBuffer().capacity());
    }

    public static class ExpandResult {
        public long address;
        public long capacity;

        public ExpandResult(long address, long capacity) {
            this.address = address;
            this.capacity = capacity;
        }
    }
}

