/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.gandiva.expression;

import org.apache.arrow.gandiva.exceptions.GandivaException;
import org.apache.arrow.gandiva.exceptions.UnsupportedTypeException;
import org.apache.arrow.gandiva.ipc.GandivaTypes;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;

public class ArrowTypeHelper {
    static final int WIDTH_8 = 8;
    static final int WIDTH_16 = 16;
    static final int WIDTH_32 = 32;
    static final int WIDTH_64 = 64;

    private ArrowTypeHelper() {
    }

    private static void initArrowTypeInt(ArrowType.Int intType, GandivaTypes.ExtGandivaType.Builder builder) throws GandivaException {
        int width = intType.getBitWidth();
        if (intType.getIsSigned()) {
            switch (width) {
                case 8: {
                    builder.setType(GandivaTypes.GandivaType.INT8);
                    return;
                }
                case 16: {
                    builder.setType(GandivaTypes.GandivaType.INT16);
                    return;
                }
                case 32: {
                    builder.setType(GandivaTypes.GandivaType.INT32);
                    return;
                }
                case 64: {
                    builder.setType(GandivaTypes.GandivaType.INT64);
                    return;
                }
            }
            throw new UnsupportedTypeException("Unsupported width for integer type");
        }
        switch (width) {
            case 8: {
                builder.setType(GandivaTypes.GandivaType.UINT8);
                return;
            }
            case 16: {
                builder.setType(GandivaTypes.GandivaType.UINT16);
                return;
            }
            case 32: {
                builder.setType(GandivaTypes.GandivaType.UINT32);
                return;
            }
            case 64: {
                builder.setType(GandivaTypes.GandivaType.UINT64);
                return;
            }
        }
        throw new UnsupportedTypeException("Unsupported width for integer type");
    }

    private static void initArrowTypeFloat(ArrowType.FloatingPoint floatType, GandivaTypes.ExtGandivaType.Builder builder) throws GandivaException {
        switch (floatType.getPrecision()) {
            case HALF: {
                builder.setType(GandivaTypes.GandivaType.HALF_FLOAT);
                break;
            }
            case SINGLE: {
                builder.setType(GandivaTypes.GandivaType.FLOAT);
                break;
            }
            case DOUBLE: {
                builder.setType(GandivaTypes.GandivaType.DOUBLE);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Floating point type with unknown precision");
            }
        }
    }

    private static void initArrowTypeDecimal(ArrowType.Decimal decimalType, GandivaTypes.ExtGandivaType.Builder builder) {
        Preconditions.checkArgument((decimalType.getPrecision() > 0 && decimalType.getPrecision() <= 38 ? 1 : 0) != 0, (Object)("Gandiva only supports decimals of upto 38 precision. Input precision : " + decimalType.getPrecision()));
        builder.setPrecision(decimalType.getPrecision());
        builder.setScale(decimalType.getScale());
        builder.setType(GandivaTypes.GandivaType.DECIMAL);
    }

    private static void initArrowTypeDate(ArrowType.Date dateType, GandivaTypes.ExtGandivaType.Builder builder) {
        short dateUnit = dateType.getUnit().getFlatbufID();
        switch (dateUnit) {
            case 0: {
                builder.setType(GandivaTypes.GandivaType.DATE32);
                break;
            }
            case 1: {
                builder.setType(GandivaTypes.GandivaType.DATE64);
                break;
            }
        }
    }

    private static void initArrowTypeTime(ArrowType.Time timeType, GandivaTypes.ExtGandivaType.Builder builder) {
        short timeUnit = timeType.getUnit().getFlatbufID();
        switch (timeUnit) {
            case 0: {
                builder.setType(GandivaTypes.GandivaType.TIME32);
                builder.setTimeUnit(GandivaTypes.TimeUnit.SEC);
                break;
            }
            case 1: {
                builder.setType(GandivaTypes.GandivaType.TIME32);
                builder.setTimeUnit(GandivaTypes.TimeUnit.MILLISEC);
                break;
            }
            case 2: {
                builder.setType(GandivaTypes.GandivaType.TIME64);
                builder.setTimeUnit(GandivaTypes.TimeUnit.MICROSEC);
                break;
            }
            case 3: {
                builder.setType(GandivaTypes.GandivaType.TIME64);
                builder.setTimeUnit(GandivaTypes.TimeUnit.NANOSEC);
                break;
            }
        }
    }

    private static void initArrowTypeTimestamp(ArrowType.Timestamp timestampType, GandivaTypes.ExtGandivaType.Builder builder) {
        short timeUnit = timestampType.getUnit().getFlatbufID();
        switch (timeUnit) {
            case 0: {
                builder.setType(GandivaTypes.GandivaType.TIMESTAMP);
                builder.setTimeUnit(GandivaTypes.TimeUnit.SEC);
                break;
            }
            case 1: {
                builder.setType(GandivaTypes.GandivaType.TIMESTAMP);
                builder.setTimeUnit(GandivaTypes.TimeUnit.MILLISEC);
                break;
            }
            case 2: {
                builder.setType(GandivaTypes.GandivaType.TIMESTAMP);
                builder.setTimeUnit(GandivaTypes.TimeUnit.MICROSEC);
                break;
            }
            case 3: {
                builder.setType(GandivaTypes.GandivaType.TIMESTAMP);
                builder.setTimeUnit(GandivaTypes.TimeUnit.NANOSEC);
                break;
            }
        }
    }

    private static void initArrowTypeInterval(ArrowType.Interval interval, GandivaTypes.ExtGandivaType.Builder builder) {
        short intervalUnit = interval.getUnit().getFlatbufID();
        switch (intervalUnit) {
            case 0: {
                builder.setType(GandivaTypes.GandivaType.INTERVAL);
                builder.setIntervalType(GandivaTypes.IntervalType.YEAR_MONTH);
                break;
            }
            case 1: {
                builder.setType(GandivaTypes.GandivaType.INTERVAL);
                builder.setIntervalType(GandivaTypes.IntervalType.DAY_TIME);
                break;
            }
        }
    }

    public static GandivaTypes.ExtGandivaType arrowTypeToProtobuf(ArrowType arrowType) throws GandivaException {
        GandivaTypes.ExtGandivaType.Builder builder = GandivaTypes.ExtGandivaType.newBuilder();
        byte typeId = arrowType.getTypeID().getFlatbufID();
        switch (typeId) {
            case 0: {
                builder.setType(GandivaTypes.GandivaType.NONE);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                ArrowTypeHelper.initArrowTypeInt((ArrowType.Int)arrowType, builder);
                break;
            }
            case 3: {
                ArrowTypeHelper.initArrowTypeFloat((ArrowType.FloatingPoint)arrowType, builder);
                break;
            }
            case 4: {
                builder.setType(GandivaTypes.GandivaType.BINARY);
                break;
            }
            case 5: {
                builder.setType(GandivaTypes.GandivaType.UTF8);
                break;
            }
            case 6: {
                builder.setType(GandivaTypes.GandivaType.BOOL);
                break;
            }
            case 7: {
                ArrowTypeHelper.initArrowTypeDecimal((ArrowType.Decimal)arrowType, builder);
                break;
            }
            case 8: {
                ArrowTypeHelper.initArrowTypeDate((ArrowType.Date)arrowType, builder);
                break;
            }
            case 9: {
                ArrowTypeHelper.initArrowTypeTime((ArrowType.Time)arrowType, builder);
                break;
            }
            case 10: {
                ArrowTypeHelper.initArrowTypeTimestamp((ArrowType.Timestamp)arrowType, builder);
                break;
            }
            case 11: {
                ArrowTypeHelper.initArrowTypeInterval((ArrowType.Interval)arrowType, builder);
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
        }
        if (!builder.hasType()) {
            throw new UnsupportedTypeException("Unsupported type " + arrowType.toString());
        }
        return builder.build();
    }

    public static GandivaTypes.Field arrowFieldToProtobuf(Field field) throws GandivaException {
        GandivaTypes.Field.Builder builder = GandivaTypes.Field.newBuilder();
        builder.setName(field.getName());
        builder.setType(ArrowTypeHelper.arrowTypeToProtobuf(field.getType()));
        builder.setNullable(field.isNullable());
        for (Field child : field.getChildren()) {
            builder.addChildren(ArrowTypeHelper.arrowFieldToProtobuf(child));
        }
        return builder.build();
    }

    public static GandivaTypes.Schema arrowSchemaToProtobuf(Schema schema) throws GandivaException {
        GandivaTypes.Schema.Builder builder = GandivaTypes.Schema.newBuilder();
        for (Field field : schema.getFields()) {
            builder.addColumns(ArrowTypeHelper.arrowFieldToProtobuf(field));
        }
        return builder.build();
    }
}

