/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.gandiva.expression;

import java.util.List;
import org.apache.arrow.gandiva.exceptions.GandivaException;
import org.apache.arrow.gandiva.expression.ArrowTypeHelper;
import org.apache.arrow.gandiva.expression.TreeNode;
import org.apache.arrow.gandiva.ipc.GandivaTypes;
import org.apache.arrow.vector.types.pojo.ArrowType;

class FunctionNode
implements TreeNode {
    private final String function;
    private final List<TreeNode> children;
    private final ArrowType retType;

    FunctionNode(String function, List<TreeNode> children, ArrowType retType) {
        this.function = function;
        this.children = children;
        this.retType = retType;
    }

    @Override
    public GandivaTypes.TreeNode toProtobuf() throws GandivaException {
        GandivaTypes.FunctionNode.Builder fnNode = GandivaTypes.FunctionNode.newBuilder();
        fnNode.setFunctionName(this.function);
        fnNode.setReturnType(ArrowTypeHelper.arrowTypeToProtobuf(this.retType));
        for (TreeNode arg : this.children) {
            fnNode.addInArgs(arg.toProtobuf());
        }
        GandivaTypes.TreeNode.Builder builder = GandivaTypes.TreeNode.newBuilder();
        builder.setFnNode(fnNode.build());
        return builder.build();
    }
}

