/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.gandiva.expression;

import com.google.protobuf.ByteString;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Set;
import org.apache.arrow.gandiva.exceptions.GandivaException;
import org.apache.arrow.gandiva.expression.TreeNode;
import org.apache.arrow.gandiva.ipc.GandivaTypes;

public class InNode
implements TreeNode {
    private static final Charset charset = Charset.forName("UTF-8");
    private final Set<Integer> intValues;
    private final Set<Long> longValues;
    private final Set<Float> floatValues;
    private final Set<Double> doubleValues;
    private final Set<BigDecimal> decimalValues;
    private final Set<String> stringValues;
    private final Set<byte[]> binaryValues;
    private final TreeNode input;
    private final Integer precision;
    private final Integer scale;

    private InNode(Set<Integer> values, Set<Long> longValues, Set<String> stringValues, Set<byte[]> binaryValues, Set<BigDecimal> decimalValues, Integer precision, Integer scale, Set<Float> floatValues, Set<Double> doubleValues, TreeNode node) {
        this.intValues = values;
        this.longValues = longValues;
        this.decimalValues = decimalValues;
        this.precision = precision;
        this.scale = scale;
        this.stringValues = stringValues;
        this.binaryValues = binaryValues;
        this.floatValues = floatValues;
        this.doubleValues = doubleValues;
        this.input = node;
    }

    public static InNode makeIntInExpr(TreeNode node, Set<Integer> intValues) {
        return new InNode(intValues, null, null, null, null, null, null, null, null, node);
    }

    public static InNode makeLongInExpr(TreeNode node, Set<Long> longValues) {
        return new InNode(null, longValues, null, null, null, null, null, null, null, node);
    }

    public static InNode makeFloatInExpr(TreeNode node, Set<Float> floatValues) {
        return new InNode(null, null, null, null, null, null, null, floatValues, null, node);
    }

    public static InNode makeDoubleInExpr(TreeNode node, Set<Double> doubleValues) {
        return new InNode(null, null, null, null, null, null, null, null, doubleValues, node);
    }

    public static InNode makeDecimalInExpr(TreeNode node, Set<BigDecimal> decimalValues, Integer precision, Integer scale) {
        return new InNode(null, null, null, null, decimalValues, precision, scale, null, null, node);
    }

    public static InNode makeStringInExpr(TreeNode node, Set<String> stringValues) {
        return new InNode(null, null, stringValues, null, null, null, null, null, null, node);
    }

    public static InNode makeBinaryInExpr(TreeNode node, Set<byte[]> binaryValues) {
        return new InNode(null, null, null, binaryValues, null, null, null, null, null, node);
    }

    @Override
    public GandivaTypes.TreeNode toProtobuf() throws GandivaException {
        GandivaTypes.InNode.Builder inNode = GandivaTypes.InNode.newBuilder();
        inNode.setNode(this.input.toProtobuf());
        if (this.intValues != null) {
            GandivaTypes.IntConstants.Builder intConstants = GandivaTypes.IntConstants.newBuilder();
            this.intValues.stream().forEach(val -> intConstants.addIntValues(GandivaTypes.IntNode.newBuilder().setValue((int)val).build()));
            inNode.setIntValues(intConstants.build());
        } else if (this.longValues != null) {
            GandivaTypes.LongConstants.Builder longConstants = GandivaTypes.LongConstants.newBuilder();
            this.longValues.stream().forEach(val -> longConstants.addLongValues(GandivaTypes.LongNode.newBuilder().setValue((long)val).build()));
            inNode.setLongValues(longConstants.build());
        } else if (this.floatValues != null) {
            GandivaTypes.FloatConstants.Builder floatConstants = GandivaTypes.FloatConstants.newBuilder();
            this.floatValues.stream().forEach(val -> floatConstants.addFloatValues(GandivaTypes.FloatNode.newBuilder().setValue(val.floatValue()).build()));
            inNode.setFloatValues(floatConstants.build());
        } else if (this.doubleValues != null) {
            GandivaTypes.DoubleConstants.Builder doubleConstants = GandivaTypes.DoubleConstants.newBuilder();
            this.doubleValues.stream().forEach(val -> doubleConstants.addDoubleValues(GandivaTypes.DoubleNode.newBuilder().setValue((double)val).build()));
            inNode.setDoubleValues(doubleConstants.build());
        } else if (this.decimalValues != null) {
            GandivaTypes.DecimalConstants.Builder decimalConstants = GandivaTypes.DecimalConstants.newBuilder();
            this.decimalValues.stream().forEach(val -> decimalConstants.addDecimalValues(GandivaTypes.DecimalNode.newBuilder().setValue(val.toPlainString()).setPrecision(this.precision).setScale(this.scale).build()));
            inNode.setDecimalValues(decimalConstants.build());
        } else if (this.stringValues != null) {
            GandivaTypes.StringConstants.Builder stringConstants = GandivaTypes.StringConstants.newBuilder();
            this.stringValues.stream().forEach(val -> stringConstants.addStringValues(GandivaTypes.StringNode.newBuilder().setValue(ByteString.copyFrom((byte[])val.getBytes(charset))).build()));
            inNode.setStringValues(stringConstants.build());
        } else if (this.binaryValues != null) {
            GandivaTypes.BinaryConstants.Builder binaryConstants = GandivaTypes.BinaryConstants.newBuilder();
            this.binaryValues.stream().forEach(val -> binaryConstants.addBinaryValues(GandivaTypes.BinaryNode.newBuilder().setValue(ByteString.copyFrom((byte[])val)).build()));
            inNode.setBinaryValues(binaryConstants.build());
        }
        GandivaTypes.TreeNode.Builder builder = GandivaTypes.TreeNode.newBuilder();
        builder.setInNode(inNode.build());
        return builder.build();
    }
}

