/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.gandiva.expression;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.arrow.gandiva.expression.AndNode;
import org.apache.arrow.gandiva.expression.BinaryNode;
import org.apache.arrow.gandiva.expression.BooleanNode;
import org.apache.arrow.gandiva.expression.Condition;
import org.apache.arrow.gandiva.expression.DecimalNode;
import org.apache.arrow.gandiva.expression.DoubleNode;
import org.apache.arrow.gandiva.expression.ExpressionTree;
import org.apache.arrow.gandiva.expression.FieldNode;
import org.apache.arrow.gandiva.expression.FloatNode;
import org.apache.arrow.gandiva.expression.FunctionNode;
import org.apache.arrow.gandiva.expression.IfNode;
import org.apache.arrow.gandiva.expression.InNode;
import org.apache.arrow.gandiva.expression.IntNode;
import org.apache.arrow.gandiva.expression.LongNode;
import org.apache.arrow.gandiva.expression.NullNode;
import org.apache.arrow.gandiva.expression.OrNode;
import org.apache.arrow.gandiva.expression.StringNode;
import org.apache.arrow.gandiva.expression.TreeNode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public class TreeBuilder {
    private TreeBuilder() {
    }

    public static TreeNode makeLiteral(Boolean booleanConstant) {
        return new BooleanNode(booleanConstant);
    }

    public static TreeNode makeLiteral(Float floatConstant) {
        return new FloatNode(floatConstant);
    }

    public static TreeNode makeLiteral(Double doubleConstant) {
        return new DoubleNode(doubleConstant);
    }

    public static TreeNode makeLiteral(Integer integerConstant) {
        return new IntNode(integerConstant);
    }

    public static TreeNode makeLiteral(Long longConstant) {
        return new LongNode(longConstant);
    }

    public static TreeNode makeStringLiteral(String stringConstant) {
        return new StringNode(stringConstant);
    }

    public static TreeNode makeBinaryLiteral(byte[] binaryConstant) {
        return new BinaryNode(binaryConstant);
    }

    public static TreeNode makeDecimalLiteral(String decimalConstant, int precision, int scale) {
        return new DecimalNode(decimalConstant, precision, scale);
    }

    public static TreeNode makeNull(ArrowType type) {
        return new NullNode(type);
    }

    public static TreeNode makeField(Field field) {
        return new FieldNode(field);
    }

    public static TreeNode makeFunction(String function, List<TreeNode> children, ArrowType retType) {
        return new FunctionNode(function, children, retType);
    }

    public static TreeNode makeIf(TreeNode condition, TreeNode thenNode, TreeNode elseNode, ArrowType retType) {
        return new IfNode(condition, thenNode, elseNode, retType);
    }

    public static TreeNode makeAnd(List<TreeNode> nodes) {
        return new AndNode(nodes);
    }

    public static TreeNode makeOr(List<TreeNode> nodes) {
        return new OrNode(nodes);
    }

    public static ExpressionTree makeExpression(TreeNode root, Field resultField) {
        return new ExpressionTree(root, resultField);
    }

    public static ExpressionTree makeExpression(String function, List<Field> inFields, Field resultField) {
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(inFields.size());
        for (Field field : inFields) {
            children.add(TreeBuilder.makeField(field));
        }
        TreeNode root = TreeBuilder.makeFunction(function, children, resultField.getType());
        return TreeBuilder.makeExpression(root, resultField);
    }

    public static Condition makeCondition(TreeNode root) {
        return new Condition(root);
    }

    public static Condition makeCondition(String function, List<Field> inFields) {
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(inFields.size());
        for (Field field : inFields) {
            children.add(TreeBuilder.makeField(field));
        }
        TreeNode root = TreeBuilder.makeFunction(function, children, (ArrowType)new ArrowType.Bool());
        return TreeBuilder.makeCondition(root);
    }

    public static TreeNode makeInExpressionInt32(TreeNode resultNode, Set<Integer> intValues) {
        return InNode.makeIntInExpr(resultNode, intValues);
    }

    public static TreeNode makeInExpressionBigInt(TreeNode resultNode, Set<Long> longValues) {
        return InNode.makeLongInExpr(resultNode, longValues);
    }

    public static TreeNode makeInExpressionDecimal(TreeNode resultNode, Set<BigDecimal> decimalValues, Integer precision, Integer scale) {
        return InNode.makeDecimalInExpr(resultNode, decimalValues, precision, scale);
    }

    public static TreeNode makeInExpressionFloat(TreeNode resultNode, Set<Float> floatValues) {
        return InNode.makeFloatInExpr(resultNode, floatValues);
    }

    public static TreeNode makeInExpressionDouble(TreeNode resultNode, Set<Double> doubleValues) {
        return InNode.makeDoubleInExpr(resultNode, doubleValues);
    }

    public static TreeNode makeInExpressionString(TreeNode resultNode, Set<String> stringValues) {
        return InNode.makeStringInExpr(resultNode, stringValues);
    }

    public static TreeNode makeInExpressionBinary(TreeNode resultNode, Set<byte[]> binaryValues) {
        return InNode.makeBinaryInExpr(resultNode, binaryValues);
    }
}

