/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.gandiva.evaluator;

import org.apache.arrow.vector.types.pojo.ArrowType;

public class DecimalTypeUtil {
    private static final int MIN_ADJUSTED_SCALE = 6;
    private static final int MAX_PRECISION = 38;

    private DecimalTypeUtil() {
    }

    public static ArrowType.Decimal getResultTypeForOperation(OperationType operation, ArrowType.Decimal operand1, ArrowType.Decimal operand2) {
        int s1 = operand1.getScale();
        int s2 = operand2.getScale();
        int p1 = operand1.getPrecision();
        int p2 = operand2.getPrecision();
        int resultScale = 0;
        int resultPrecision = 0;
        switch (operation) {
            case ADD: 
            case SUBTRACT: {
                resultScale = Math.max(operand1.getScale(), operand2.getScale());
                resultPrecision = resultScale + Math.max(operand1.getPrecision() - operand1.getScale(), operand2.getPrecision() - operand2.getScale()) + 1;
                break;
            }
            case MULTIPLY: {
                resultScale = s1 + s2;
                resultPrecision = p1 + p2 + 1;
                break;
            }
            case DIVIDE: {
                resultScale = Math.max(6, operand1.getScale() + operand2.getPrecision() + 1);
                resultPrecision = operand1.getPrecision() - operand1.getScale() + operand2.getScale() + resultScale;
                break;
            }
            case MOD: {
                resultScale = Math.max(operand1.getScale(), operand2.getScale());
                resultPrecision = Math.min(operand1.getPrecision() - operand1.getScale(), operand2.getPrecision() - operand2.getScale()) + resultScale;
                break;
            }
            default: {
                throw new RuntimeException("Needs support");
            }
        }
        return DecimalTypeUtil.adjustScaleIfNeeded(resultPrecision, resultScale);
    }

    private static ArrowType.Decimal adjustScaleIfNeeded(int precision, int scale) {
        if (precision > 38) {
            int minScale = Math.min(scale, 6);
            int delta = precision - 38;
            precision = 38;
            scale = Math.max(scale - delta, minScale);
        }
        return new ArrowType.Decimal(precision, scale, 128);
    }

    public static enum OperationType {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MOD;

    }
}

