/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.gandiva.evaluator;

import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.gandiva.evaluator.ConfigurationBuilder;
import org.apache.arrow.gandiva.evaluator.JniLoader;
import org.apache.arrow.gandiva.evaluator.JniWrapper;
import org.apache.arrow.gandiva.evaluator.SelectionVector;
import org.apache.arrow.gandiva.exceptions.EvaluatorClosedException;
import org.apache.arrow.gandiva.exceptions.GandivaException;
import org.apache.arrow.gandiva.expression.ArrowTypeHelper;
import org.apache.arrow.gandiva.expression.Condition;
import org.apache.arrow.gandiva.ipc.GandivaTypes;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.ipc.message.ArrowBuffer;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Filter {
    private static final Logger logger = LoggerFactory.getLogger(Filter.class);
    private final JniWrapper wrapper;
    private final long moduleId;
    private final Schema schema;
    private boolean closed;

    private Filter(JniWrapper wrapper, long moduleId, Schema schema) {
        this.wrapper = wrapper;
        this.moduleId = moduleId;
        this.schema = schema;
        this.closed = false;
    }

    public static Filter make(Schema schema, Condition condition) throws GandivaException {
        return Filter.make(schema, condition, JniLoader.getDefaultConfiguration());
    }

    public static Filter make(Schema schema, Condition condition, ConfigurationBuilder.ConfigOptions configOptions) throws GandivaException {
        return Filter.make(schema, condition, JniLoader.getConfiguration(configOptions));
    }

    @Deprecated
    public static Filter make(Schema schema, Condition condition, boolean optimize) throws GandivaException {
        return Filter.make(schema, condition, JniLoader.getConfiguration(new ConfigurationBuilder.ConfigOptions().withOptimize(optimize)));
    }

    public static Filter make(Schema schema, Condition condition, long configurationId) throws GandivaException {
        GandivaTypes.Condition conditionBuf = condition.toProtobuf();
        GandivaTypes.Schema schemaBuf = ArrowTypeHelper.arrowSchemaToProtobuf(schema);
        JniWrapper wrapper = JniLoader.getInstance().getWrapper();
        long moduleId = wrapper.buildFilter(schemaBuf.toByteArray(), conditionBuf.toByteArray(), configurationId);
        logger.debug("Created module for the filter with id {}", (Object)moduleId);
        return new Filter(wrapper, moduleId, schema);
    }

    public void evaluate(ArrowRecordBatch recordBatch, SelectionVector selectionVector) throws GandivaException {
        this.evaluate(recordBatch.getLength(), recordBatch.getBuffers(), recordBatch.getBuffersLayout(), selectionVector);
    }

    public void evaluate(int numRows, List<ArrowBuf> buffers, SelectionVector selectionVector) throws GandivaException {
        ArrayList<ArrowBuffer> buffersLayout = new ArrayList<ArrowBuffer>();
        long offset = 0L;
        for (ArrowBuf arrowBuf : buffers) {
            long size = arrowBuf.readableBytes();
            buffersLayout.add(new ArrowBuffer(offset, size));
            offset += size;
        }
        this.evaluate(numRows, buffers, buffersLayout, selectionVector);
    }

    private void evaluate(int numRows, List<ArrowBuf> buffers, List<ArrowBuffer> buffersLayout, SelectionVector selectionVector) throws GandivaException {
        if (this.closed) {
            throw new EvaluatorClosedException();
        }
        if (selectionVector.getMaxRecords() < numRows) {
            logger.error("selectionVector has capacity for " + selectionVector.getMaxRecords() + " rows, minimum required " + numRows);
            throw new GandivaException("SelectionVector too small");
        }
        long[] bufAddrs = new long[buffers.size()];
        long[] bufSizes = new long[buffers.size()];
        int idx = 0;
        for (ArrowBuf buf : buffers) {
            bufAddrs[idx++] = buf.memoryAddress();
        }
        idx = 0;
        for (ArrowBuffer bufLayout : buffersLayout) {
            bufSizes[idx++] = bufLayout.getSize();
        }
        int numRecords = this.wrapper.evaluateFilter(this.moduleId, numRows, bufAddrs, bufSizes, selectionVector.getType().getNumber(), selectionVector.getBuffer().memoryAddress(), selectionVector.getBuffer().capacity());
        if (numRecords >= 0) {
            selectionVector.setRecordCount(numRecords);
        }
    }

    public void close() throws GandivaException {
        if (this.closed) {
            return;
        }
        this.wrapper.closeFilter(this.moduleId);
        this.closed = true;
    }
}

