/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.gandiva.evaluator;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.List;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class FunctionSignature {
    private final String name;
    private final ArrowType returnType;
    private final List<ArrowType> paramTypes;

    public ArrowType getReturnType() {
        return this.returnType;
    }

    public List<ArrowType> getParamTypes() {
        return this.paramTypes;
    }

    public String getName() {
        return this.name;
    }

    public FunctionSignature(String name, ArrowType returnType, List<ArrowType> paramTypes) {
        this.name = name;
        this.returnType = returnType;
        this.paramTypes = paramTypes;
    }

    public boolean equals(Object signature) {
        if (signature == null) {
            return false;
        }
        if (this.getClass() != signature.getClass()) {
            return false;
        }
        FunctionSignature other = (FunctionSignature)signature;
        return this.name.equalsIgnoreCase(other.name) && Objects.equal((Object)this.returnType, (Object)other.returnType) && Objects.equal(this.paramTypes, other.paramTypes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name.toLowerCase(), this.returnType, this.paramTypes});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name ", (Object)this.name).add("return type ", (Object)this.returnType).add("param types ", this.paramTypes).toString();
    }
}

