/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.gandiva.evaluator;

import org.apache.arrow.gandiva.ipc.GandivaTypes;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.util.LargeMemoryUtil;

public abstract class SelectionVector {
    private int recordCount;
    private ArrowBuf buffer;

    public SelectionVector(ArrowBuf buffer) {
        this.buffer = buffer;
    }

    public final ArrowBuf getBuffer() {
        return this.buffer;
    }

    public final int getMaxRecords() {
        return LargeMemoryUtil.capAtMaxInt((long)(this.buffer.capacity() / (long)this.getRecordSize()));
    }

    public final int getRecordCount() {
        return this.recordCount;
    }

    final void setRecordCount(int recordCount) {
        if ((long)(recordCount * this.getRecordSize()) > this.buffer.capacity()) {
            throw new IllegalArgumentException("recordCount " + recordCount + " of size " + this.getRecordSize() + " exceeds buffer capacity " + this.buffer.capacity());
        }
        this.recordCount = recordCount;
    }

    public abstract int getIndex(int var1);

    abstract int getRecordSize();

    abstract GandivaTypes.SelectionVectorType getType();

    final void checkReadBounds(int index) {
        if (index >= this.recordCount) {
            throw new IllegalArgumentException("index " + index + " is >= recordCount " + this.recordCount);
        }
    }
}

